/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.service.impl;

import com.club.core.common.Page;
import com.club.web.image.service.ImageService;
import com.club.web.image.service.vo.ImageVo;
import com.club.web.stock.domain.CargoBrandDo;
import com.club.web.stock.domain.repository.CargoBrandRepository;
import com.club.web.stock.service.CargoBrandService;
import com.club.web.stock.service.CargoClassifyService;
import com.club.web.stock.vo.CargoBrandVo;
import com.club.web.util.CommonUtil;
import com.club.web.util.IdGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cargoBrandService")
@Transactional
public class CargoBrandServiceImpl
implements CargoBrandService {
    private Logger logger = LoggerFactory.getLogger(CargoBrandServiceImpl.class);
    @Autowired
    CargoBrandRepository cargoBrandRepository;
    @Autowired
    ImageService imageService;
    @Autowired
    private CargoClassifyService cargoClassify;

    @Override
    public Map<String, Object> saveOrUpdateCargoBrand(CargoBrandVo cargoBrand, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (cargoBrand != null) {
            if (null == cargoBrand.getName() || "".equals(cargoBrand.getName())) {
                result.put("success", false);
                result.put("msg", "\u8bf7\u8f93\u5165\u54c1\u724c\u540d\u79f0");
                return result;
            }
            List<CargoBrandVo> cargoBrandByName = this.cargoBrandRepository.queryCargoBrandByName(cargoBrand.getName());
            int count = cargoBrandByName.size();
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            if (cargoBrand.getId() == null || "".equals(cargoBrand.getId())) {
                if (count > 0) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u54c1\u724c\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
                    return result;
                }
                cargoBrand.setId(IdGenerator.getDefault().nextId() + "");
                if (cargoBrand.getLogo() != null && !"".equals(cargoBrand.getLogo())) {
                    ImageVo imageVo = this.imageService.saveImage(cargoBrand.getLogo());
                    cargoBrand.setLogo(imageVo.getId() + "");
                }
                cargoBrand.setCreateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    cargoBrand.setCreateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                cargoBrand.setUpdateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    cargoBrand.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                CargoBrandDo cargoBrandDo = this.cargoBrandRepository.create(cargoBrand);
                cargoBrandDo.insert();
            } else {
                CargoBrandDo cargoBrandDo = this.cargoBrandRepository.getCargoBrandDoById(Long.parseLong(cargoBrand.getId()));
                if (count > 0 && !cargoBrandDo.getName().equalsIgnoreCase(cargoBrand.getName())) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u54c1\u724c\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
                    return result;
                }
                if (cargoBrandDo.getLogo() == null || "".equals(cargoBrandDo.getLogo())) {
                    if (cargoBrand.getLogo() != null && !"".equals(cargoBrand.getLogo())) {
                        ImageVo imageVo = this.imageService.saveImage(cargoBrand.getLogo());
                        cargoBrandDo.setLogo(imageVo.getId() + "");
                    }
                } else if (cargoBrand.getLogo() != null && !"".equals(cargoBrand.getLogo())) {
                    ImageVo imageVo = this.imageService.selectImageById(Long.parseLong(cargoBrandDo.getLogo()));
                    imageVo.setPicUrl(cargoBrand.getLogo());
                    this.imageService.updateImage(imageVo);
                } else {
                    this.imageService.deleteById(Long.parseLong(cargoBrandDo.getLogo()));
                    cargoBrandDo.setLogo(null);
                }
                cargoBrandDo.setName(cargoBrand.getName());
                cargoBrandDo.setUrl(cargoBrand.getUrl());
                cargoBrandDo.setSupplierName(cargoBrand.getSupplierName());
                cargoBrandDo.setBrandRecommendation(cargoBrand.getBrandRecommendation());
                cargoBrandDo.setUpdateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    cargoBrandDo.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                cargoBrandDo.update();
            }
            result.put("success", true);
        } else {
            result.put("success", false);
            result.put("msg", "\u54c1\u724c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @Override
    public Page<Map<String, Object>> queryCargoBrandPage(Page<Map<String, Object>> page) {
        Page<Map<String, Object>> result = new Page<Map<String, Object>>();
        result.setStart(page.getStart());
        result.setLimit(page.getLimit());
        List<Map<String, Object>> list = this.cargoBrandRepository.queryCargoBrandPage(page);
        Long count = this.cargoBrandRepository.queryCargoBrandCountPage(page);
        result.setResultList(CommonUtil.listObjTransToListMap(list));
        result.setTotalRecords(count.intValue());
        return result;
    }

    @Override
    public List<CargoBrandVo> findListAll() {
        List<CargoBrandVo> list = null;
        list = this.cargoBrandRepository.findListAll();
        return list;
    }

    @Override
    public List<CargoBrandVo> findListAllNotNull(String classify) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (classify != null && !"".equals(classify) && Long.parseLong(classify) > 0L) {
            try {
                List<Long> listClassify = this.cargoClassify.getAllIdsByIdAndStatus(Long.parseLong(classify), null);
                param.put("classify", listClassify);
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u5206\u7c7b\u5b50Id\u5f02\u5e38<getWeixinGoodListSer>:", (Throwable)e);
            }
        }
        List<CargoBrandVo> list = null;
        list = this.cargoBrandRepository.findListAllNotNull(param);
        return list;
    }

    @Override
    public List<CargoBrandVo> findListAllNotNullByCategory(String category) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("category", category);
        return this.cargoBrandRepository.findListAllNotNull(param);
    }

    @Override
    public Map<String, Object> deleteCargoBrand(String idStr) {
        String[] Ids = idStr.split(",");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String id : Ids) {
            CargoBrandDo cargoBrandDo = this.cargoBrandRepository.getCargoBrandDoById(Long.parseLong(id));
            if (cargoBrandDo.getLogo() != null && !"".equals(cargoBrandDo.getLogo())) {
                this.imageService.deleteById(Long.parseLong(cargoBrandDo.getLogo()));
            }
            cargoBrandDo.delete();
        }
        result.put("success", true);
        return result;
    }

    @Override
    public CargoBrandVo findCargoBrandById(Long id) {
        CargoBrandVo cargoBrand = null;
        cargoBrand = this.cargoBrandRepository.getCargoBrandVoById(id);
        return cargoBrand;
    }
}

