/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.service.impl;

import com.club.core.common.Page;
import com.club.framework.util.ListUtils;
import com.club.framework.util.StringUtils;
import com.club.web.stock.constant.CargoClassifyStatus;
import com.club.web.stock.dao.base.po.CargoClassify;
import com.club.web.stock.domain.CargoClassifyDo;
import com.club.web.stock.domain.repository.CargoClassifyRepository;
import com.club.web.stock.service.CargoClassifyService;
import com.club.web.stock.service.CargoService;
import com.club.web.stock.vo.CargoClassifyAppVo;
import com.club.web.stock.vo.CargoClassifyVo;
import com.club.web.util.IdGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"classpath:/config/props/version-switch.properties"})
public class CargoClassifyServiceImpl
implements CargoClassifyService {
    @Autowired
    private CargoClassifyRepository cargoClassifyRepository;
    @Autowired
    private CargoService cargoService;
    @Value(value="${server.version}")
    private String serverVersion;

    @Override
    public boolean updateStatus(String ids, Integer status, long userId) throws Exception {
        if (StringUtils.isNotEmpty(ids) && status != null) {
            Date updateTime = new Date();
            List<CargoClassifyDo> doList = this.cargoClassifyRepository.findDoListByIds(ids);
            for (CargoClassifyDo cargoClassifyDo : doList) {
                if (CargoClassifyStatus.\u7981\u7528.getDbData() == status.intValue()) {
                    cargoClassifyDo.updateStop(updateTime, userId, status);
                    continue;
                }
                cargoClassifyDo.updateStart(updateTime, userId, status);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteByIds(String ids) throws Exception {
        List<CargoClassifyDo> doList = this.cargoClassifyRepository.findDoListByIds(ids);
        HashSet<Long> idSet = new HashSet<Long>();
        for (CargoClassifyDo cargoClassifyDo : doList) {
            idSet.addAll(cargoClassifyDo.getAllIds(null));
        }
        if (this.cargoService.queryCargoCountByClassifyIds(new ArrayList<Long>(idSet)) > 0) {
            throw new Exception("\u8d27\u54c1\u4e2d\u5b58\u5728\u88ab\u5f15\u7528\u7684\u8d27\u54c1\u5206\u7c7b\uff0c\u8bf7\u4fee\u6539\u6240\u6709\u88ab\u5f15\u7528\u7684\u8d27\u54c1\u5206\u7c7b\u518d\u5220\u9664\uff01");
        }
        for (CargoClassifyDo cargoClassifyDo : doList) {
            cargoClassifyDo.delete();
        }
        return true;
    }

    @Override
    public boolean add(long userId, CargoClassifyVo cargoClassifyVo) throws Exception {
        cargoClassifyVo.setId(IdGenerator.getDefault().nextId() + "");
        cargoClassifyVo.setCreateBy(userId);
        cargoClassifyVo.setUpdateBy(userId);
        Date date = new Date();
        cargoClassifyVo.setCreateTime(date);
        cargoClassifyVo.setUpdateTime(date);
        cargoClassifyVo.setParentId(cargoClassifyVo.getParentId() == null ? "1" : cargoClassifyVo.getParentId());
        if ("zuitese".equals(this.serverVersion)) {
            cargoClassifyVo.setStatus(CargoClassifyStatus.\u7981\u7528.getDbData());
        } else if (!"1".equals(cargoClassifyVo.getParentId())) {
            CargoClassifyDo parent = this.cargoClassifyRepository.findDoById(Long.valueOf(cargoClassifyVo.getParentId()));
            if (parent != null && CargoClassifyStatus.\u7981\u7528.getDbData() == parent.getStatus().intValue()) {
                cargoClassifyVo.setStatus(CargoClassifyStatus.\u7981\u7528.getDbData());
            } else {
                cargoClassifyVo.setStatus(CargoClassifyStatus.\u542f\u7528.getDbData());
            }
        } else {
            cargoClassifyVo.setStatus(CargoClassifyStatus.\u542f\u7528.getDbData());
        }
        this.getDomainByVo(cargoClassifyVo).save();
        return true;
    }

    @Override
    public boolean modify(long updaterId, CargoClassifyVo cargoClassifyVo) throws Exception {
        CargoClassifyDo target = this.cargoClassifyRepository.findDoById(Long.valueOf(cargoClassifyVo.getId()));
        target.setName(cargoClassifyVo.getName() != null && !cargoClassifyVo.getName().trim().equals("") ? cargoClassifyVo.getName() : "");
        target.setParentId(cargoClassifyVo.getParentId() != null ? Long.valueOf(cargoClassifyVo.getParentId()) : 1L);
        target.setOrderIndex(cargoClassifyVo.getOrderIndex() != null ? cargoClassifyVo.getOrderIndex() : 0);
        target.setImgUrl(cargoClassifyVo.getImgUrl());
        target.setUpdateTime(new Date());
        target.setUpdateBy(updaterId);
        target.update();
        return true;
    }

    @Override
    public CargoClassifyVo findVoByIdAndStatus(Long id, Integer status) throws Exception {
        return this.getVoByDomain(this.cargoClassifyRepository.findDoByIdAndStatus(id, status));
    }

    @Override
    public List<Long> getAllIdsByIdAndStatus(Long id, Integer status) throws Exception {
        return this.cargoClassifyRepository.getAllIdsByIdAndStatus(id, status);
    }

    @Override
    public List<CargoClassifyVo> getVoListByParentId(Long parentId, Integer status) throws Exception {
        return this.getVoListByDomainList(this.cargoClassifyRepository.findDoByParentIdAndStatus(parentId, status));
    }

    @Override
    public List<CargoClassifyVo> getTypeListByParentId(Long parentId, Integer status) throws Exception {
        List<CargoClassify> list = this.cargoClassifyRepository.findDoByParentIdAndStatusForWeb(parentId, status);
        ArrayList<CargoClassifyVo> voList = new ArrayList<CargoClassifyVo>();
        CargoClassifyVo vo = null;
        for (CargoClassify cargoClassify : list) {
            vo = new CargoClassifyVo();
            vo.setId(cargoClassify.getId() + "");
            vo.setName(cargoClassify.getName());
            vo.setOrderIndex(cargoClassify.getOrderIndex());
            vo.setImgUrl(cargoClassify.getImgUrl());
            List<CargoClassify> doByParentIdAndStatusForWeb = this.cargoClassifyRepository.findDoByParentIdAndStatusForWeb(cargoClassify.getId(), status);
            vo.setChildren(this.getVoListByList(doByParentIdAndStatusForWeb));
            voList.add(vo);
        }
        return voList;
    }

    private List<CargoClassifyVo> getVoListByList(List<CargoClassify> list) {
        ArrayList<CargoClassifyVo> voList = new ArrayList<CargoClassifyVo>();
        CargoClassifyVo vo = null;
        for (CargoClassify cargoClassify : list) {
            vo = new CargoClassifyVo();
            vo.setId(cargoClassify.getId() + "");
            vo.setName(cargoClassify.getName());
            vo.setOrderIndex(cargoClassify.getOrderIndex());
            vo.setImgUrl(cargoClassify.getImgUrl());
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public Object getAppParents(String parentId) throws Exception {
        return this.listToObject(this.cargoClassifyRepository.findDoByParentIdAndStatus(parentId == null ? 1L : Long.valueOf(parentId), 1), 2, 4);
    }

    @Override
    public List<CargoClassifyAppVo> mobileFirstAndSecondList() {
        ArrayList<CargoClassifyAppVo> result = new ArrayList<CargoClassifyAppVo>();
        List<CargoClassifyDo> parents = this.cargoClassifyRepository.findDoByParentIdAndStatus(1L, 1);
        for (CargoClassifyDo cargoClassifyDo : parents) {
            CargoClassifyAppVo appVo = this.getAppVoByDomain(cargoClassifyDo);
            appVo.setChildrens(this.getAppVoListByDomainList(this.cargoClassifyRepository.findDoByParentIdAndStatus(cargoClassifyDo.getId(), 1)));
            result.add(appVo);
        }
        return result;
    }

    private List<CargoClassifyAppVo> getAppVoListByDomainList(List<CargoClassifyDo> srcs) {
        ArrayList<CargoClassifyAppVo> targets = new ArrayList<CargoClassifyAppVo>();
        if (srcs != null && srcs.size() != 0) {
            for (CargoClassifyDo src : srcs) {
                targets.add(this.getAppVoByDomain(src));
            }
        }
        return targets;
    }

    private CargoClassifyAppVo getAppVoByDomain(CargoClassifyDo src) {
        CargoClassifyAppVo traget = null;
        if (src != null) {
            traget = new CargoClassifyAppVo();
            traget.setClassify(src.getId() + "");
            traget.setText(src.getName());
            traget.setImgUrl(src.getImgUrl());
        }
        return traget;
    }

    private Object listToObject(List<CargoClassifyDo> cargoClassifyDos, int rowNum, int colNum) {
        int row = 1;
        int col = 1;
        ArrayList resultList = new ArrayList();
        HashMap resultMap = new HashMap();
        ArrayList rowMapList = new ArrayList();
        HashMap rowMap = new HashMap();
        ArrayList<CargoClassifyAppVo> rowlist = new ArrayList<CargoClassifyAppVo>();
        for (CargoClassifyDo cargoClassifyDo : cargoClassifyDos) {
            CargoClassifyAppVo appVo = new CargoClassifyAppVo();
            appVo.setClassify(cargoClassifyDo.getId() + "");
            appVo.setText(cargoClassifyDo.getName());
            appVo.setImgUrl(cargoClassifyDo.getImgUrl());
            rowlist.add(appVo);
            if (col % colNum == 0) {
                rowMap.put("row", rowlist);
                rowMapList.add(rowMap);
                rowlist = new ArrayList();
                rowMap = new HashMap();
                if (row % rowNum == 0) {
                    resultMap.put("rowList", rowMapList);
                    resultList.add(resultMap);
                    resultMap = new HashMap();
                    rowMapList = new ArrayList();
                    row = 0;
                }
                col = 0;
                ++row;
            }
            ++col;
        }
        if (ListUtils.isNotEmpty(rowlist)) {
            rowMap.put("row", rowlist);
        }
        if (!rowMap.isEmpty()) {
            rowMapList.add(rowMap);
        }
        if (ListUtils.isNotEmpty(rowMapList)) {
            resultMap.put("rowList", rowMapList);
        }
        if (!resultMap.isEmpty()) {
            resultList.add(resultMap);
        }
        return resultList;
    }

    @Override
    public Page<CargoClassifyVo> list() throws Exception {
        Page<CargoClassifyVo> page = new Page<CargoClassifyVo>(0, Integer.MAX_VALUE);
        page.setResultList(this.getVoListByDomainList(this.cargoClassifyRepository.findDoByParentId(1L)));
        return page;
    }

    @Override
    public List<CargoClassifyVo> getVoAllList(Integer status) {
        return this.getVoListByDomainList(this.cargoClassifyRepository.findAllDoByStatus(status));
    }

    private List<CargoClassifyVo> getVoListByDomainList(List<CargoClassifyDo> srcs) {
        ArrayList<CargoClassifyVo> targets = new ArrayList<CargoClassifyVo>();
        if (srcs != null && srcs.size() != 0) {
            for (CargoClassifyDo src : srcs) {
                targets.add(this.getVoByDomain(src));
            }
        }
        return targets;
    }

    private List<CargoClassifyDo> getDomainListByVoList(List<CargoClassifyVo> srcs) {
        ArrayList<CargoClassifyDo> targets = new ArrayList<CargoClassifyDo>();
        if (srcs != null && srcs.size() != 0) {
            for (CargoClassifyVo src : srcs) {
                targets.add(this.getDomainByVo(src));
            }
        }
        return targets;
    }

    private CargoClassifyVo getVoByDomain(CargoClassifyDo src) {
        CargoClassifyVo target = null;
        if (src != null) {
            target = new CargoClassifyVo();
            target.setId(src.getId() + "");
            target.setName(src.getName());
            target.setParentId(src.getParentId() == null ? null : src.getParentId() + "");
            target.setParent(this.getVoByDomain(src.getParentId() != null && !src.getParentId().equals(1L) ? src.getParent() : null));
            target.setStatus(src.getStatus());
            target.setOrderIndex(src.getOrderIndex());
            target.setCreateBy(src.getCreateBy());
            target.setCreateTime(src.getCreateTime());
            target.setUpdateBy(src.getUpdateBy());
            target.setUpdateTime(src.getUpdateTime());
            target.setImgUrl(src.getImgUrl());
        }
        return target;
    }

    private CargoClassifyDo getDomainByVo(CargoClassifyVo src) {
        CargoClassifyDo target = null;
        if (src != null) {
            target = new CargoClassifyDo();
            target.setId(Long.valueOf(src.getId()));
            target.setName(src.getName());
            target.setStatus(src.getStatus());
            target.setOrderIndex(src.getOrderIndex());
            target.setParentId(src.getParentId() == null ? null : Long.valueOf(src.getParentId()));
            target.setCreateBy(src.getCreateBy());
            target.setCreateTime(src.getCreateTime());
            target.setUpdateBy(src.getUpdateBy());
            target.setUpdateTime(src.getUpdateTime());
            target.setImgUrl(src.getImgUrl());
        }
        return target;
    }
}

