/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.service.impl;

import com.club.core.common.Page;
import com.club.web.stock.domain.CargoSupplierDo;
import com.club.web.stock.domain.repository.CargoSupplierRepository;
import com.club.web.stock.service.CargoSupplierService;
import com.club.web.stock.vo.CargoSupplierVo;
import com.club.web.util.CommonUtil;
import com.club.web.util.IdGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cargoSupplierService")
@Transactional
public class CargoSupplierServiceImpl
implements CargoSupplierService {
    private Logger logger = LoggerFactory.getLogger(CargoSupplierServiceImpl.class);
    @Autowired
    CargoSupplierRepository cargoSupplierRepository;

    @Override
    public Map<String, Object> saveOrUpdateCargoSupplier(CargoSupplierVo cargoSupplier, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (cargoSupplier != null) {
            if (null == cargoSupplier.getCode() || "".equals(cargoSupplier.getCode())) {
                result.put("success", false);
                result.put("msg", "\u8bf7\u8f93\u5165\u4f9b\u5e94\u5546\u7f16\u53f7");
                return result;
            }
            if (null == cargoSupplier.getName() || "".equals(cargoSupplier.getName())) {
                result.put("success", false);
                result.put("msg", "\u8bf7\u8f93\u5165\u4f9b\u5e94\u5546\u540d\u79f0");
                return result;
            }
            List<CargoSupplierVo> cargoSupplierByName = this.cargoSupplierRepository.queryCargoSupplierByName(cargoSupplier.getName());
            int count = cargoSupplierByName.size();
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            if (cargoSupplier.getId() == null || "".equals(cargoSupplier.getId())) {
                if (count > 0) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u4f9b\u5e94\u5546\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
                    return result;
                }
                cargoSupplier.setId(IdGenerator.getDefault().nextId() + "");
                cargoSupplier.setCreateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    cargoSupplier.setCreateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                cargoSupplier.setUpdateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    cargoSupplier.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                CargoSupplierDo cargoSupplierDo = this.cargoSupplierRepository.create(cargoSupplier);
                cargoSupplierDo.insert();
            } else {
                CargoSupplierDo cargoSupplierDo = this.cargoSupplierRepository.getCargoSupplierDoById(Long.parseLong(cargoSupplier.getId()));
                if (count > 0 && !cargoSupplierDo.getName().equalsIgnoreCase(cargoSupplier.getName())) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u4f9b\u5e94\u5546\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
                    return result;
                }
                cargoSupplierDo.setName(cargoSupplier.getName());
                cargoSupplierDo.setContacts(cargoSupplier.getContacts());
                cargoSupplierDo.setTel(cargoSupplier.getTel());
                cargoSupplierDo.setAddr(cargoSupplier.getAddr());
                cargoSupplierDo.setUpdateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    cargoSupplierDo.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                cargoSupplierDo.update();
            }
            result.put("success", true);
        } else {
            result.put("success", false);
            result.put("msg", "\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @Override
    public Page<Map<String, Object>> queryCargoSupplierPage(Page<Map<String, Object>> page) {
        Page<Map<String, Object>> result = new Page<Map<String, Object>>();
        result.setStart(page.getStart());
        result.setLimit(page.getLimit());
        List<Map<String, Object>> list = this.cargoSupplierRepository.queryCargoSupplierPage(page);
        Long count = this.cargoSupplierRepository.queryCargoSupplierCountPage(page);
        result.setResultList(CommonUtil.listObjTransToListMap(list));
        result.setTotalRecords(count.intValue());
        return result;
    }

    @Override
    public List<CargoSupplierVo> findListAll() {
        List<CargoSupplierVo> list = null;
        list = this.cargoSupplierRepository.findListAll();
        return list;
    }

    @Override
    public Map<String, Object> deleteCargoSupplier(String idStr) {
        String[] Ids = idStr.split(",");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String id : Ids) {
            this.cargoSupplierRepository.deleteByPrimaryKey(Long.parseLong(id));
        }
        result.put("success", true);
        return result;
    }

    @Override
    public CargoSupplierVo findCargoSupplierById(Long id) {
        CargoSupplierVo cargoSupplier = null;
        cargoSupplier = this.cargoSupplierRepository.getCargoSupplierVoById(id);
        return cargoSupplier;
    }
}

