/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.service.impl;

import com.club.core.common.Page;
import com.club.framework.util.StringUtils;
import com.club.web.stock.domain.CargoInboundDetailDo;
import com.club.web.stock.domain.CargoInboundOrderDo;
import com.club.web.stock.domain.CargoOutboundDetailDo;
import com.club.web.stock.domain.CargoOutboundOrderDo;
import com.club.web.stock.domain.CargoSkuStockDo;
import com.club.web.stock.domain.repository.StockManagerRepository;
import com.club.web.stock.service.CargoClassifyService;
import com.club.web.stock.service.StockManagerService;
import com.club.web.stock.vo.CargoClassifyVo;
import com.club.web.stock.vo.CargoInboundDetailVo;
import com.club.web.stock.vo.CargoInboundOrderVo;
import com.club.web.stock.vo.CargoOutboundOrderVo;
import com.club.web.stock.vo.CargoSkuItemVo;
import com.club.web.stock.vo.CargoSkuStockVo;
import com.club.web.stock.vo.SkuGoodsParam;
import com.club.web.stock.vo.StockGoodsInboundMsgVo;
import com.club.web.stock.vo.StockGoodsOutboundMsgVo;
import com.club.web.stock.vo.TreeListVo;
import com.club.web.stock.vo.U8Stock;
import com.club.web.util.CommonUtil;
import com.club.web.util.sqlexecutor.SqlExecuteRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StockManagerServiceImpl
implements StockManagerService {
    private Logger logger = LoggerFactory.getLogger(StockManagerServiceImpl.class);
    @Autowired
    StockManagerRepository repository;
    @Autowired
    private CargoClassifyService cargoClassify;
    private Map<String, Object> result;
    @Autowired
    private SqlExecuteRepository sqlExecuteRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> saveInboundStockSer(Map<String, Object> paramMap, long userId) throws Exception {
        this.result = new HashMap<String, Object>();
        boolean trag = false;
        CargoInboundOrderDo inboundObj = null;
        List<CargoInboundDetailDo> listDetail = null;
        String skuIds = StringUtils.EMPTY;
        String skuCount = StringUtils.EMPTY;
        String sourceCode = StringUtils.EMPTY;
        String remk = StringUtils.EMPTY;
        String inboundId = StringUtils.EMPTY;
        String type = StringUtils.EMPTY;
        long[] skuIdList = null;
        int[] skuCountList = null;
        if (paramMap != null) {
            int i;
            String[] arr;
            if (paramMap.containsKey("skuIds")) {
                String string = skuIds = paramMap.get("skuIds") != null ? paramMap.get("skuIds").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("skuCount")) {
                String string = skuCount = paramMap.get("skuCount") != null ? paramMap.get("skuCount").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("sourceCode")) {
                String string = sourceCode = paramMap.get("sourceCode") != null ? paramMap.get("sourceCode").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("remk")) {
                String string = remk = paramMap.get("remk") != null ? paramMap.get("remk").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("inboundId")) {
                String string = inboundId = paramMap.get("inboundId") != null ? paramMap.get("inboundId").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("type")) {
                String string = type = paramMap.get("type") != null ? paramMap.get("type").toString() : StringUtils.EMPTY;
            }
            if (StringUtils.isNotEmpty(skuIds) && (arr = skuIds.split(",")) != null && arr.length > 0) {
                skuIdList = new long[arr.length];
                for (i = 0; i < arr.length; ++i) {
                    skuIdList[i] = Long.valueOf(arr[i]);
                }
            }
            if (StringUtils.isNotEmpty(skuCount) && (arr = skuCount.split(",")) != null && arr.length > 0) {
                skuCountList = new int[arr.length];
                for (i = 0; i < arr.length; ++i) {
                    if (!CommonUtil.isDigital(arr[i])) {
                        this.result.put("code", "000001");
                        this.result.put("msg", "\u5165\u5e93\u8d27\u54c1\u5217\u8868\u6570\u91cf\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
                        return this.result;
                    }
                    skuCountList[i] = Integer.valueOf(arr[i]);
                }
            }
            if (skuIdList != null && skuIdList.length > 0 && skuCountList != null && skuCountList.length > 0) {
                Object object = skuCountList;
                i = ((int[])object).length;
                for (int j = 0; j < i; ++j) {
                    long c = object[j];
                    if (c >= 1L) continue;
                    trag = true;
                    break;
                }
                if (!trag) {
                    try {
                        this.sqlExecuteRepository.disableForeignKeyChecks();
                        if (StringUtils.isNotEmpty(inboundId)) {
                            listDetail = this.repository.createInboundDetailObj(skuIdList, skuCountList, Long.valueOf(inboundId));
                            if (listDetail != null && listDetail.stream().count() > 0L) {
                                object = listDetail.iterator();
                                while (object.hasNext()) {
                                    CargoInboundDetailDo ddo = (CargoInboundDetailDo)object.next();
                                    if (ddo.getFlag() == 0) {
                                        ddo.save();
                                        continue;
                                    }
                                    ddo.update();
                                }
                            } else {
                                this.result.put("code", "000003");
                                this.result.put("msg", "\u4fee\u6539\u4fe1\u606f\u5bf9\u8c61\u4e0d\u5b58\u5728");
                            }
                        } else {
                            inboundObj = this.repository.createInboundObj(skuIdList, skuCountList, userId, sourceCode, remk, type);
                            if (inboundObj != null) {
                                inboundObj.save();
                            } else {
                                this.result.put("code", "000003");
                                this.result.put("msg", "\u4fdd\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
                            }
                        }
                        this.result.put("code", "000000");
                        this.result.put("msg", "\u4fdd\u5b58\u6210\u529f");
                    }
                    finally {
                        this.sqlExecuteRepository.enableForeignKeyChecks();
                    }
                } else {
                    this.result.put("code", "000001");
                    this.result.put("msg", "\u5165\u5e93\u8d27\u54c1\u5217\u8868\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                }
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u5165\u5e93\u8d27\u54c1SKU\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> updateInboundStatusSer(Map<String, Object> paramMap, long userId) throws Exception {
        this.result = new HashMap<String, Object>();
        ArrayList<Long> ids = null;
        String id = StringUtils.EMPTY;
        int status = -1;
        String desc = StringUtils.EMPTY;
        List<CargoInboundOrderDo> list = null;
        List<CargoInboundDetailVo> detailList = null;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = id = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("desc")) {
                String string = desc = paramMap.get("desc") != null ? paramMap.get("desc").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("status")) {
                int n = status = paramMap.get("status") != null ? Integer.valueOf(paramMap.get("status").toString()) : -1;
            }
            if (StringUtils.isNotEmpty(id) && (arr = id.split(",")) != null && arr.length > 0) {
                ids = new ArrayList<Long>();
                for (String str : arr) {
                    ids.add(Long.valueOf(str));
                }
            }
            if (status > -1 && ids != null && ids.stream().count() > 0L) {
                list = this.repository.getInboundObjByIds(ids);
                if (list != null && list.stream().count() > 0L) {
                    for (CargoInboundOrderDo inboundDo : list) {
                        if (status == 2 && ((detailList = this.repository.queryByInboundId(inboundDo.getId())) == null || detailList.stream().count() == 0L)) {
                            this.result.put("code", "000000");
                            this.result.put("msg", "\u63d0\u4ea4\u5ba1\u6838\u8bb0\u5f55\u4e2d\u5b58\u5728\u5165\u5e93\u7684\u660e\u7ec6\u4e0d\u5b58\u5728");
                            return this.result;
                        }
                        inboundDo.update(status, desc, userId);
                    }
                    this.result.put("code", "000000");
                    this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
                } else {
                    this.result.put("code", "000003");
                    this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
                }
            } else {
                this.result.put("code", "000003");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u64cd\u4f5c\u6709\u8bef");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> updateStockRemainSer(Map<String, Object> paramMap, long userId) throws Exception {
        this.result = this.handleStock(-2, null, userId, null, 0L, paramMap);
        return this.result;
    }

    private Map<String, Object> updateRemainStock(Map<String, Object> paramMap, long userId) throws Exception {
        this.result = new HashMap<String, Object>();
        long id = 0L;
        int noShelve = 0;
        int remainCount = 0;
        int count = 0;
        String updateCount = StringUtils.EMPTY;
        int variable = 0;
        CargoSkuStockDo stockDo = null;
        if (paramMap != null) {
            if (paramMap.containsKey("id")) {
                long l = id = paramMap.get("id") != null ? Long.valueOf(paramMap.get("id").toString()) : 0L;
            }
            if (paramMap.containsKey("updateCount")) {
                String string = updateCount = paramMap.get("updateCount") != null ? paramMap.get("updateCount").toString() : StringUtils.EMPTY;
            }
            if (CommonUtil.isDigital(updateCount)) {
                count = Integer.valueOf(updateCount);
                if (remainCount < 0) {
                    this.result.put("code", "000001");
                    this.result.put("msg", "\u7559\u5b58\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
                } else {
                    stockDo = this.repository.queryStockById(id);
                    if (stockDo != null) {
                        remainCount = stockDo.getRemainCount();
                        noShelve = stockDo.getOutShelvesNo();
                        if (remainCount == count) {
                            this.result.put("code", "000000");
                            this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
                        } else if (count > noShelve + remainCount) {
                            this.result.put("code", "000001");
                            this.result.put("msg", "\u7559\u5b58\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u672a\u4e0a\u67b6\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
                        } else {
                            variable = remainCount - count;
                            stockDo.update(count, variable, userId);
                            this.result.put("code", "000000");
                            this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
                        }
                    } else {
                        this.result.put("code", "000003");
                        this.result.put("msg", "\u4fee\u6539\u5bf9\u8c61\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                    }
                }
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u7559\u5b58\u6570\u91cf\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> delInboundOrderSer(Map<String, Object> paramMap) throws Exception {
        this.result = new HashMap<String, Object>();
        ArrayList<Long> ids = null;
        String id = StringUtils.EMPTY;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = id = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (StringUtils.isNotEmpty(id) && (arr = id.split(",")) != null && arr.length > 0) {
                ids = new ArrayList<Long>();
                for (String str : arr) {
                    ids.add(Long.valueOf(str));
                }
            }
            if (ids != null && ids.stream().count() > 0L) {
                this.repository.deleteInboundOrderDetail((List<Long>)ids);
                this.repository.deleteInboundOrder(ids);
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000003");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u64cd\u4f5c\u6709\u8bef");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> delInboundOrderDetailSer(Map<String, Object> paramMap) throws Exception {
        this.result = new HashMap<String, Object>();
        ArrayList<Long> ids = null;
        String id = StringUtils.EMPTY;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = id = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (StringUtils.isNotEmpty(id) && (arr = id.split(",")) != null && arr.length > 0) {
                ids = new ArrayList<Long>();
                for (String str : arr) {
                    ids.add(Long.valueOf(str));
                }
            }
            if (ids != null && ids.stream().count() > 0L) {
                this.repository.deleteInboundOrderDetailByIds((List<Long>)ids);
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000003");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u64cd\u4f5c\u6709\u8bef");
        }
        return this.result;
    }

    @Override
    public Page<Map<String, Object>> queryInboundOrderListSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        List<CargoInboundOrderVo> list = null;
        List<Map<String, Object>> listMap = null;
        int total = 0;
        int status = 0;
        String matchParam = StringUtils.EMPTY;
        String type = StringUtils.EMPTY;
        try {
            if (page != null) {
                startIndex = page.getStart();
                pageSize = page.getLimit();
                Map<String, Object> con = page.getConditons();
                if (con != null) {
                    if (con.containsKey("status")) {
                        int n = status = con.get("status") != null ? Integer.valueOf(con.get("status").toString()) : 0;
                    }
                    if (con.containsKey("type")) {
                        String string = type = con.get("type") != null ? con.get("type").toString() : StringUtils.EMPTY;
                    }
                    if (con.containsKey("inboundName")) {
                        matchParam = con.get("inboundName") != null ? con.get("inboundName").toString() : StringUtils.EMPTY;
                    }
                }
                total = this.repository.queryInboundOrderTotal(status, matchParam, type);
                page.setTotalRecords(total);
                if (total > 0 && (listMap = CommonUtil.listObjTransToListMap(list = this.repository.queryInboundOrderList(status, matchParam, type, startIndex, pageSize))) != null && listMap.size() > 0) {
                    page.setResultList(listMap);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u5f02\u5e38<queryInboundOrderListSer>:", (Throwable)e);
        }
        return page;
    }

    @Override
    public Page<Map<String, Object>> queryInboundOrderDetailSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        List<Long> nodeList = null;
        List<StockGoodsInboundMsgVo> listGoods = null;
        List<Map<String, Object>> listMap = null;
        String matchParam = StringUtils.EMPTY;
        long classify = 0L;
        long brand = 0L;
        long inboundId = 0L;
        int total = 0;
        try {
            if (page != null) {
                startIndex = page.getStart();
                pageSize = page.getLimit();
                Map<String, Object> con = page.getConditons();
                if (con != null) {
                    if (con.containsKey("matchParam")) {
                        String string = matchParam = con.get("matchParam") != null ? con.get("matchParam").toString() : StringUtils.EMPTY;
                    }
                    if (con.containsKey("classify")) {
                        long l = classify = con.get("classify") != null ? Long.valueOf(con.get("classify").toString()) : 0L;
                    }
                    if (con.containsKey("brand")) {
                        long l = brand = con.get("brand") != null ? Long.valueOf(con.get("brand").toString()) : 0L;
                    }
                    if (con.containsKey("inboundId")) {
                        long l = inboundId = con.get("inboundId") != null ? Long.valueOf(con.get("inboundId").toString()) : 0L;
                    }
                }
                if (inboundId > 0L) {
                    nodeList = this.queryClassyByNodeId(classify);
                    total = this.repository.queryInboundDetailTotal(nodeList, brand, inboundId, matchParam);
                    page.setTotalRecords(total);
                    if (total > 0) {
                        listGoods = this.repository.queryInboundorderDetailList(nodeList, brand, inboundId, matchParam, startIndex, pageSize);
                        this.setCargoSkuSpecList(listGoods);
                        listMap = CommonUtil.listObjTransToListMap(listGoods);
                        if (listMap != null && listMap.size() > 0) {
                            page.setResultList(listMap);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u660e\u7ec6\u5f02\u5e38<queryInboundOrderDetailSer>:", (Throwable)e);
        }
        return page;
    }

    @Override
    public Page<Map<String, Object>> queryGoodsMsgSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        List<Long> nodeList = null;
        List<StockGoodsInboundMsgVo> listGoods = null;
        List<Map<String, Object>> listMap = null;
        String matchParam = StringUtils.EMPTY;
        String type = StringUtils.EMPTY;
        long classify = 0L;
        int total = 0;
        try {
            if (page != null) {
                startIndex = page.getStart();
                pageSize = page.getLimit();
                Map<String, Object> con = page.getConditons();
                if (con != null) {
                    if (con.containsKey("matchParam")) {
                        String string = matchParam = con.get("matchParam") != null ? con.get("matchParam").toString() : StringUtils.EMPTY;
                    }
                    if (con.containsKey("classify")) {
                        long l = classify = con.get("classify") != null ? Long.valueOf(con.get("classify").toString()) : 0L;
                    }
                    if (con.containsKey("type")) {
                        type = con.get("type") != null ? con.get("type").toString() : StringUtils.EMPTY;
                    }
                }
                nodeList = this.queryClassyByNodeId(classify);
                total = this.repository.queryGoodsMsgTotal(nodeList, matchParam, type);
                page.setTotalRecords(total);
                if (total > 0 && (listMap = CommonUtil.listObjTransToListMap(listGoods = this.repository.queryGoodsMsg(nodeList, matchParam, type, startIndex, pageSize))) != null && listMap.size() > 0) {
                    page.setResultList(listMap);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u5165\u5e93-\u67e5\u8be2\u8d27\u54c1\u4fe1\u606f\u5f02\u5e38<queryGoodsMsgCon>:", (Throwable)e);
        }
        return page;
    }

    @Override
    public Page<Map<String, Object>> queryGoodsSkuMsgSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        int total = 0;
        List<StockGoodsInboundMsgVo> listGoods = null;
        List<Map<String, Object>> listMap = null;
        String goodsIds = StringUtils.EMPTY;
        ArrayList<Long> goodsIdList = null;
        try {
            if (page != null) {
                String[] arr;
                pageSize = page.getLimit();
                startIndex = page.getStart();
                Map<String, Object> con = page.getConditons();
                if (con != null && con.containsKey("goodsIds")) {
                    String string = goodsIds = con.get("goodsIds") != null ? con.get("goodsIds").toString() : StringUtils.EMPTY;
                }
                if (StringUtils.isNotEmpty(goodsIds) && (arr = goodsIds.split(",")) != null && arr.length > 0) {
                    goodsIdList = new ArrayList<Long>();
                    for (String str : arr) {
                        goodsIdList.add(Long.valueOf(str));
                    }
                }
                if (goodsIdList != null && goodsIdList.stream().count() > 0L) {
                    total = this.repository.queryGoodsSkuMsgTotal((List<Long>)goodsIdList);
                    page.setTotalRecords(total);
                    if (total > 0) {
                        listGoods = this.repository.queryGoodsSkuMsg(goodsIdList, startIndex, pageSize);
                    }
                    this.setCargoSkuSpecList(listGoods);
                }
                if ((listMap = CommonUtil.listObjTransToListMap(listGoods)) != null && listMap.size() > 0) {
                    page.setResultList(listMap);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u5165\u5e93-\u67e5\u8be2\u8d27\u54c1Sku\u4fe1\u606f\u5f02\u5e38<queryGoodsSkuMsgSer>:", (Throwable)e);
        }
        return page;
    }

    @Override
    public Page<Map<String, Object>> queryOutboundStockSkuMsgSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        int total = 0;
        List<StockGoodsOutboundMsgVo> listGoods = null;
        List<Map<String, Object>> listMap = null;
        String goodsIds = StringUtils.EMPTY;
        ArrayList<Long> goodsIdList = null;
        try {
            if (page != null) {
                String[] arr;
                pageSize = page.getLimit();
                startIndex = page.getStart();
                Map<String, Object> con = page.getConditons();
                if (con != null && con.containsKey("goodsIds")) {
                    String string = goodsIds = con.get("goodsIds") != null ? con.get("goodsIds").toString() : StringUtils.EMPTY;
                }
                if (StringUtils.isNotEmpty(goodsIds) && (arr = goodsIds.split(",")) != null && arr.length > 0) {
                    goodsIdList = new ArrayList<Long>();
                    for (String str : arr) {
                        goodsIdList.add(Long.valueOf(str));
                    }
                }
                if (goodsIdList != null && goodsIdList.stream().count() > 0L) {
                    total = this.repository.queryOutboundSkuMsgTotal((List<Long>)goodsIdList);
                    page.setTotalRecords(total);
                    if (total > 0) {
                        listGoods = this.repository.queryOutboundSkuMsg(goodsIdList, startIndex, pageSize);
                    }
                    this.setCargoSkuSpecList(listGoods);
                }
                if ((listMap = CommonUtil.listObjTransToListMap(listGoods)) != null && listMap.size() > 0) {
                    page.setResultList(listMap);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u51fa\u5e93-\u67e5\u8be2\u8d27\u54c1Sku\u4fe1\u606f\u5f02\u5e38<queryOutboundStockSkuMsgSer>:", (Throwable)e);
        }
        return page;
    }

    private <T> void setCargoSkuSpecList(List<T> t) {
        List<CargoSkuItemVo> list = null;
        CargoSkuStockVo cargoSkuStockVo = null;
        StockGoodsInboundMsgVo stockGoodsMsgVo = null;
        StockGoodsOutboundMsgVo stockGoodsOutboundMsgVo = null;
        if (t != null && t.stream().count() > 0L) {
            for (T vo : t) {
                try {
                    list = null;
                    if (vo instanceof CargoSkuStockVo) {
                        cargoSkuStockVo = (CargoSkuStockVo)vo;
                        list = this.repository.queryGoodsSpecList(Long.valueOf(cargoSkuStockVo.getSkuId()));
                        if (list == null || list.size() <= 0) continue;
                        cargoSkuStockVo.setItem(list);
                        continue;
                    }
                    if (vo instanceof StockGoodsInboundMsgVo) {
                        stockGoodsMsgVo = (StockGoodsInboundMsgVo)vo;
                        list = this.repository.queryGoodsSpecList(Long.valueOf(stockGoodsMsgVo.getSkuId()));
                        if (list == null || list.size() <= 0) continue;
                        stockGoodsMsgVo.setItem(list);
                        continue;
                    }
                    if (!(vo instanceof StockGoodsOutboundMsgVo) || (list = this.repository.queryGoodsSpecList(Long.valueOf((stockGoodsOutboundMsgVo = (StockGoodsOutboundMsgVo)vo).getSkuId()))) == null || list.size() <= 0) continue;
                    stockGoodsOutboundMsgVo.setItem(list);
                }
                catch (Exception e) {
                    this.logger.error("\u8bbe\u7f6e\u5bf9\u8c61\u7684\u89c4\u683c\u503c\u5f02\u5e38<setCargoSkuSpecList>:", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Page<Map<String, Object>> queryStockMsgSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        List<Long> nodeList = null;
        List<CargoSkuStockVo> listStock = null;
        List<Map<String, Object>> listMap = null;
        String matchParam = StringUtils.EMPTY;
        String type = StringUtils.EMPTY;
        long classify = 0L;
        long brand = 0L;
        int total = 0;
        try {
            if (page != null) {
                startIndex = page.getStart();
                pageSize = page.getLimit();
                Map<String, Object> con = page.getConditons();
                if (con != null) {
                    if (con.containsKey("matchParam")) {
                        String string = matchParam = con.get("matchParam") != null ? con.get("matchParam").toString() : StringUtils.EMPTY;
                    }
                    if (con.containsKey("classify")) {
                        long l = classify = con.get("classify") != null ? Long.valueOf(con.get("classify").toString()) : 0L;
                    }
                    if (con.containsKey("brand")) {
                        long l = brand = con.get("brand") != null ? Long.valueOf(con.get("brand").toString()) : 0L;
                    }
                    if (con.containsKey("type")) {
                        type = con.get("type") != null ? con.get("type").toString() : StringUtils.EMPTY;
                    }
                }
                nodeList = this.queryClassyByNodeId(classify);
                total = this.repository.queryStockMsgTotal(nodeList, brand, matchParam, type);
                page.setTotalRecords(total);
                if (total > 0) {
                    listStock = this.repository.queryStockMsg(nodeList, brand, matchParam, type, startIndex, pageSize);
                    this.setCargoSkuSpecList(listStock);
                    listMap = CommonUtil.listObjTransToListMap(listStock);
                    if (listMap != null && listMap.size() > 0) {
                        page.setResultList(listMap);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38<queryStockMsgSer>:", (Throwable)e);
        }
        return page;
    }

    private List<Long> queryClassyByNodeId(long nodeId) {
        List<Long> nodeList = null;
        try {
            if (nodeId > 0L) {
                nodeList = this.cargoClassify.getAllIdsByIdAndStatus(nodeId, null);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u8282\u70b9\u67e5\u8be2\u5206\u7c7b\u5b50\u8282\u70b9\u4fe1\u606f\u5f02\u5e38<queryClassyByNodeId>:", (Throwable)e);
        }
        return nodeList;
    }

    @Override
    public Map<String, Object> updateNormalStockMsgSer(Map<String, Object> paramMap, long userId) throws Exception {
        this.result = this.handleStock(-1, null, userId, null, 0L, paramMap);
        return this.result;
    }

    private Map<String, Object> updateExceptionStock(Map<String, Object> paramMap, long userId) throws Exception {
        this.result = new HashMap<String, Object>();
        String ids = StringUtils.EMPTY;
        String nopays = StringUtils.EMPTY;
        String noSends = StringUtils.EMPTY;
        String[] arrId = null;
        String[] arrNoPay = null;
        String[] arrNoSend = null;
        int variable_pay = 0;
        int variable_send = 0;
        CargoSkuStockDo stockDo = null;
        if (paramMap != null) {
            if (paramMap.containsKey("ids")) {
                String string = ids = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("nopays")) {
                String string = nopays = paramMap.get("nopays") != null ? paramMap.get("nopays").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("noSends")) {
                String string = noSends = paramMap.get("noSends") != null ? paramMap.get("noSends").toString() : StringUtils.EMPTY;
            }
            if (StringUtils.isNotEmpty(ids) && StringUtils.isNotEmpty(nopays) && StringUtils.isNotEmpty(noSends)) {
                arrId = ids.split(",");
                arrNoPay = nopays.split(",");
                arrNoSend = noSends.split(",");
            }
            if (arrId != null && arrId.length > 0 && arrNoPay != null && arrNoPay.length > 0 && arrNoSend != null && arrNoSend.length > 0) {
                for (int i = 0; i < arrId.length; ++i) {
                    stockDo = this.repository.queryStockById(Long.valueOf(arrId[i]));
                    variable_pay = Integer.valueOf(arrNoPay[i]) - stockDo.getOnPayNo();
                    variable_send = Integer.valueOf(arrNoSend[i]) - stockDo.getOnSendNo();
                    if (stockDo == null) continue;
                    stockDo.update(variable_pay, variable_send, Integer.valueOf(arrNoPay[i]), Integer.valueOf(arrNoSend[i]), userId);
                }
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        return this.result;
    }

    @Override
    public Page<Map<String, Object>> queryOutboundOrderListSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        List<CargoOutboundOrderVo> listOutbound = null;
        List<Map<String, Object>> listMap = null;
        String matchParam = StringUtils.EMPTY;
        String type = StringUtils.EMPTY;
        int status = 0;
        int total = 0;
        try {
            if (page != null) {
                startIndex = page.getStart();
                pageSize = page.getLimit();
                Map<String, Object> con = page.getConditons();
                if (con != null) {
                    if (con.containsKey("matchParam")) {
                        String string = matchParam = con.get("matchParam") != null ? con.get("matchParam").toString() : StringUtils.EMPTY;
                    }
                    if (con.containsKey("type")) {
                        String string = type = con.get("type") != null ? con.get("type").toString() : StringUtils.EMPTY;
                    }
                    if (con.containsKey("status")) {
                        status = con.get("status") != null ? Integer.valueOf(con.get("status").toString()) : 0;
                    }
                }
                total = this.repository.queryOutboundOrderListTotal(status, matchParam, type);
                page.setTotalRecords(total);
                if (total > 0) {
                    listOutbound = this.repository.queryOutboundOrderList(status, matchParam, type, startIndex, pageSize);
                    this.setCargoSkuSpecList(listOutbound);
                    listMap = CommonUtil.listObjTransToListMap(listOutbound);
                    if (listMap != null && listMap.size() > 0) {
                        page.setResultList(listMap);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u4fe1\u606f\u5f02\u5e38<queryOutboundOrderListSer>:", (Throwable)e);
        }
        return page;
    }

    @Override
    public Page<Map<String, Object>> queryOutboundOrderDetailSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        List<Long> nodeList = null;
        List<StockGoodsOutboundMsgVo> listGoods = null;
        List<Map<String, Object>> listMap = null;
        String matchParam = StringUtils.EMPTY;
        long classify = 0L;
        long brand = 0L;
        long outboundId = 0L;
        int total = 0;
        try {
            if (page != null) {
                startIndex = page.getStart();
                pageSize = page.getLimit();
                Map<String, Object> con = page.getConditons();
                if (con != null) {
                    if (con.containsKey("matchParam")) {
                        String string = matchParam = con.get("matchParam") != null ? con.get("matchParam").toString() : StringUtils.EMPTY;
                    }
                    if (con.containsKey("classify")) {
                        long l = classify = con.get("classify") != null ? Long.valueOf(con.get("classify").toString()) : 0L;
                    }
                    if (con.containsKey("brand")) {
                        long l = brand = con.get("brand") != null ? Long.valueOf(con.get("brand").toString()) : 0L;
                    }
                    if (con.containsKey("outboundId")) {
                        long l = outboundId = con.get("outboundId") != null ? Long.valueOf(con.get("outboundId").toString()) : 0L;
                    }
                }
                if (outboundId > 0L) {
                    nodeList = this.queryClassyByNodeId(classify);
                    total = this.repository.queryOutboundDetailTotal(nodeList, brand, outboundId, matchParam);
                    page.setTotalRecords(total);
                    if (total > 0) {
                        listGoods = this.repository.queryOutboundDetail(nodeList, brand, outboundId, matchParam, startIndex, pageSize);
                        this.setCargoSkuSpecList(listGoods);
                        listMap = CommonUtil.listObjTransToListMap(listGoods);
                        if (listMap != null && listMap.size() > 0) {
                            page.setResultList(listMap);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u8be6\u7ec6\u4fe1\u606f\u5f02\u5e38<queryOutboundOrderDetailSer>:", (Throwable)e);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> saveOutboundMsgSer(Map<String, Object> paramMap, long userId) throws Exception {
        this.result = new HashMap<String, Object>();
        CargoOutboundOrderDo outboundDo = null;
        List<CargoOutboundDetailDo> listDetail = null;
        String skuIds = StringUtils.EMPTY;
        String skuCount = StringUtils.EMPTY;
        String sourceCode = StringUtils.EMPTY;
        String remk = StringUtils.EMPTY;
        String outboundId = StringUtils.EMPTY;
        String type = StringUtils.EMPTY;
        long[] skuIdList = null;
        int[] skuCountList = null;
        if (paramMap != null) {
            int i;
            String[] arr;
            if (paramMap.containsKey("skuIds")) {
                String string = skuIds = paramMap.get("skuIds") != null ? paramMap.get("skuIds").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("skuCount")) {
                String string = skuCount = paramMap.get("skuCount") != null ? paramMap.get("skuCount").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("sourceCode")) {
                String string = sourceCode = paramMap.get("sourceCode") != null ? paramMap.get("sourceCode").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("remk")) {
                String string = remk = paramMap.get("remk") != null ? paramMap.get("remk").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("outboundId")) {
                String string = outboundId = paramMap.get("outboundId") != null ? paramMap.get("outboundId").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("type")) {
                String string = type = paramMap.get("type") != null ? paramMap.get("type").toString() : StringUtils.EMPTY;
            }
            if (StringUtils.isNotEmpty(skuIds) && (arr = skuIds.split(",")) != null && arr.length > 0) {
                skuIdList = new long[arr.length];
                for (i = 0; i < arr.length; ++i) {
                    skuIdList[i] = Long.valueOf(arr[i]);
                }
            }
            if (StringUtils.isNotEmpty(skuCount) && (arr = skuCount.split(",")) != null && arr.length > 0) {
                skuCountList = new int[arr.length];
                for (i = 0; i < arr.length; ++i) {
                    if (!CommonUtil.isDigital(arr[i])) {
                        this.result.put("code", "000001");
                        this.result.put("msg", "\u51fa\u5e93\u8d27\u54c1\u5217\u8868\u6570\u91cf\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
                        return this.result;
                    }
                    skuCountList[i] = Integer.valueOf(arr[i]);
                }
            }
            if (skuIdList != null && skuIdList.length > 0 && skuCountList != null && skuCountList.length > 0) {
                if (this.checkSkuCount(skuIdList, skuCountList, outboundId)) {
                    try {
                        this.sqlExecuteRepository.disableForeignKeyChecks();
                        if (StringUtils.isNotEmpty(outboundId)) {
                            listDetail = this.repository.createOutboundDetailObj(skuIdList, skuCountList, Long.valueOf(outboundId));
                            if (listDetail != null && listDetail.stream().count() > 0L) {
                                for (CargoOutboundDetailDo ddo : listDetail) {
                                    if (ddo.getFlag() == 0) {
                                        ddo.save();
                                        continue;
                                    }
                                    ddo.update();
                                }
                            } else {
                                this.result.put("code", "000003");
                                this.result.put("msg", "\u4fee\u6539\u5bf9\u8c61\u4e0d\u5b58\u5728");
                            }
                        } else {
                            outboundDo = this.repository.createOutboundObj(skuIdList, skuCountList, userId, sourceCode, remk, type);
                            if (outboundDo != null) {
                                outboundDo.save();
                            } else {
                                this.result.put("code", "000003");
                                this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
                            }
                        }
                        this.result.put("code", "000000");
                        this.result.put("msg", "\u4fdd\u5b58\u6210\u529f");
                    }
                    finally {
                        this.sqlExecuteRepository.enableForeignKeyChecks();
                    }
                } else {
                    this.result.put("code", "000001");
                    this.result.put("msg", "\u8f93\u5165\u7684\u51fa\u5e93\u6570\u91cf\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u91cd\u65b0\u63d0\u4ea4\uff01");
                }
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u51fa\u5e93\u8d27\u54c1SKU\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        return this.result;
    }

    private boolean checkSkuCount(long[] skuIdList, int[] skuCountList, String outboundId) {
        boolean flag = true;
        int[] nArray = skuCountList;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long c = nArray[i];
            if (c >= 1L) continue;
            flag = false;
            break;
        }
        int count = 0;
        int exitsCount = 0;
        if (flag) {
            for (int i = 0; i < skuIdList.length; ++i) {
                if (StringUtils.isNotEmpty(outboundId)) {
                    exitsCount = this.repository.queryOutCountBySkuId(skuIdList[i], Long.valueOf(outboundId));
                }
                if (skuCountList[i] + exitsCount <= (count = this.repository.queryStockCountBySkuId(skuIdList[i]))) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    @Override
    public Map<String, Object> delOutboundOrderDetailSer(Map<String, Object> paramMap) throws Exception {
        this.result = new HashMap<String, Object>();
        ArrayList<Long> ids = null;
        String id = StringUtils.EMPTY;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = id = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (StringUtils.isNotEmpty(id) && (arr = id.split(",")) != null && arr.length > 0) {
                ids = new ArrayList<Long>();
                for (String str : arr) {
                    ids.add(Long.valueOf(str));
                }
            }
            if (ids != null && ids.stream().count() > 0L) {
                this.repository.deleteOutboundDetailByIds((List<Long>)ids);
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000003");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u64cd\u4f5c\u6709\u8bef");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> delOutboundOrderSer(Map<String, Object> paramMap) throws Exception {
        this.result = new HashMap<String, Object>();
        ArrayList<Long> ids = null;
        String id = StringUtils.EMPTY;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = id = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (StringUtils.isNotEmpty(id) && (arr = id.split(",")) != null && arr.length > 0) {
                ids = new ArrayList<Long>();
                for (String str : arr) {
                    ids.add(Long.valueOf(str));
                }
            }
            if (ids != null && ids.stream().count() > 0L) {
                this.repository.delOutboundDetailByOutIds((List<Long>)ids);
                this.repository.deleteOutboundOrder(ids);
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000003");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u64cd\u4f5c\u6709\u8bef");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> updateOutboundStatusSerHandler(Map<String, Object> paramMap, long userId) throws Exception {
        this.result = new HashMap<String, Object>();
        ArrayList<Long> ids = null;
        String id = StringUtils.EMPTY;
        int status = -1;
        String desc = StringUtils.EMPTY;
        List<CargoOutboundOrderDo> list = null;
        List<CargoOutboundDetailDo> outDetailList = null;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = id = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("desc")) {
                String string = desc = paramMap.get("desc") != null ? paramMap.get("desc").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("status")) {
                int n = status = paramMap.get("status") != null ? Integer.valueOf(paramMap.get("status").toString()) : -1;
            }
            if (StringUtils.isNotEmpty(id) && (arr = id.split(",")) != null && arr.length > 0) {
                ids = new ArrayList<Long>();
                for (String str : arr) {
                    ids.add(Long.valueOf(str));
                }
            }
            if (status > -1 && ids != null && ids.stream().count() > 0L) {
                list = this.repository.getOutboundObjByIds(ids);
                if (list != null && list.stream().count() > 0L) {
                    if (status == 3 && !this.checkSureCount(ids)) {
                        this.result.put("code", "000003");
                        this.result.put("msg", "\u5b58\u5728SKU\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3\uff0c\u4e0d\u80fd\u51fa\u5e93\u8bf7\u786e\u8ba4\uff01");
                        return this.result;
                    }
                    for (CargoOutboundOrderDo outbound : list) {
                        if (status != 1) {
                            outDetailList = this.repository.queryOutDetailByOutboundId(outbound.getId());
                        }
                        if (status == 2 || status == 3) {
                            if (outDetailList == null || outDetailList.stream().count() == 0L) {
                                this.result.put("code", "000003");
                                this.result.put("msg", "\u63d0\u4ea4\u5ba1\u6838\u8bb0\u5f55\u5305\u542b\u7a7a\u7684\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\uff01");
                                return this.result;
                            }
                            outbound.setDetail(outDetailList);
                        }
                        outbound.update(status, desc);
                        if (status != 3) continue;
                        this.handleStock(status, outDetailList, userId, null, 0L, null);
                    }
                    this.result.put("code", "000000");
                    this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
                } else {
                    this.result.put("code", "000003");
                    this.result.put("msg", "\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728");
                }
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u64cd\u4f5c\u6709\u8bef");
        }
        return this.result;
    }

    private boolean checkSureCount(List<Long> outboundIds) {
        boolean flag = true;
        List<StockGoodsOutboundMsgVo> list = this.repository.getStockCountByOutIds(outboundIds);
        if (list != null && list.stream().count() > 0L) {
            for (StockGoodsOutboundMsgVo svo : list) {
                if (svo.getGoodCount() <= svo.getSkuCount()) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    @Override
    public List<TreeListVo> queryTreeMenuSer() {
        this.result = new HashMap<String, Object>();
        List<CargoClassifyVo> list = this.cargoClassify.getVoAllList(null);
        ArrayList<TreeListVo> listTree = null;
        ArrayList<TreeListVo> listNodeTree = null;
        List<TreeListVo> node = null;
        if (list != null && list.stream().count() > 0L) {
            listTree = new ArrayList<TreeListVo>();
            listNodeTree = new ArrayList<TreeListVo>();
            TreeListVo vo = null;
            for (CargoClassifyVo t : list) {
                if (t.getParentId() != null && !"1".equals(t.getParentId()) && !"null".equals(t.getParentId())) continue;
                vo = new TreeListVo();
                node = this.packDate(t.getId(), list);
                vo.setId(t.getId());
                vo.setpId("0");
                vo.setName(t.getName());
                if (node != null && node.stream().count() > 0L) {
                    vo.setOpen(true);
                    vo.setChildren(node);
                }
                listTree.add(vo);
            }
            vo = new TreeListVo();
            vo.setId("0");
            vo.setpId("-1");
            vo.setName("\u5168\u90e8");
            vo.setOpen(true);
            if (listTree != null && listTree.stream().count() > 0L) {
                vo.setChildren(listTree);
            }
            listNodeTree.add(vo);
        }
        return listNodeTree;
    }

    private List<TreeListVo> packDate(String id, List<CargoClassifyVo> list) {
        ArrayList<TreeListVo> node = null;
        List<TreeListVo> nodeCh = null;
        if (list != null && list.stream().count() > 0L) {
            TreeListVo obj = null;
            node = new ArrayList<TreeListVo>();
            for (CargoClassifyVo dv : list) {
                if (id.equals(dv.getId()) || !id.equals(dv.getParentId())) continue;
                obj = new TreeListVo();
                obj.setId(dv.getId());
                obj.setName(dv.getName());
                obj.setpId(dv.getParentId());
                nodeCh = this.packDate(dv.getId(), list);
                if (nodeCh != null && nodeCh.stream().count() > 0L) {
                    obj.setOpen(true);
                    obj.setChildren(nodeCh);
                }
                node.add(obj);
            }
        }
        return node;
    }

    @Override
    public Map<String, Object> updateUpAndDownGoodsMsg(List<SkuGoodsParam> list, long userId, int status) throws Exception {
        this.result = new HashMap<String, Object>();
        if (list != null && list.stream().count() > 0L) {
            if (status != 0 && status != 1) {
                this.result.put("code", "000001");
                this.result.put("msg", "status\u64cd\u4f5c\u72b6\u6001\u4e0d\u5b58\u5728");
                throw new Exception("status\u64cd\u4f5c\u72b6\u6001\u4e0d\u5b58\u5728");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "list\u53c2\u6570\u4e3a\u7a7a");
            throw new Exception("list\u53c2\u6570\u4e3a\u7a7a");
        }
        this.result = this.handleStock(status, null, userId, list, 0L, null);
        return this.result;
    }

    @Override
    public void doU8StockAndSkuStock(List<U8Stock> u8list) {
        if (u8list != null && u8list.size() > 0) {
            List<U8Stock> localList = this.repository.queryCargoSkuStockList();
            boolean flag = true;
            Double localNum = 0.0;
            Double temp = 0.0;
            if (localList != null && localList.size() > 0) {
                block0: for (U8Stock u8 : u8list) {
                    for (U8Stock lo : localList) {
                        if (!u8.getCinvcode().equals(lo.getCode())) continue;
                        localNum = lo.getOut_shelves_no() + lo.getOn_sales_no() + lo.getOn_pay_no() + lo.getRemain_count();
                        if (u8.getIquantity() == localNum) continue block0;
                        if (u8.getIquantity() > localNum) {
                            temp = u8.getIquantity() - lo.getOn_sales_no() - lo.getOn_pay_no() - lo.getRemain_count();
                            if (temp > 0.0) {
                                lo.setOut_shelves_no(temp);
                                this.repository.updateLocalStock(lo);
                                continue block0;
                            }
                            lo.setOut_shelves_no(0.0);
                            temp = u8.getIquantity() - lo.getOn_sales_no() - lo.getOn_pay_no();
                            if (temp > 0.0) {
                                lo.setRemain_count(temp);
                            } else {
                                lo.setRemain_count(0.0);
                            }
                            this.repository.updateLocalStock(lo);
                            continue block0;
                        }
                        if (!(u8.getIquantity() < localNum) || !(u8.getIquantity() < localNum - lo.getOut_shelves_no() - lo.getRemain_count())) continue;
                        if (lo.getOut_shelves_no() == 0.0 && lo.getRemain_count() == 0.0) continue block0;
                        lo.setOut_shelves_no(0.0);
                        lo.setRemain_count(0.0);
                        this.repository.updateLocalStock(lo);
                    }
                }
            }
        }
    }

    private Map<String, Object> updateUpSkuGoods(List<SkuGoodsParam> list, long userId) throws Exception {
        this.result = new HashMap<String, Object>();
        CargoSkuStockDo stockObj = null;
        int count = 0;
        long skuId = 0L;
        for (SkuGoodsParam sku : list) {
            count = Integer.valueOf(sku.getNum());
            skuId = Long.valueOf(sku.getCargoSkuId());
            if (count > 0) {
                stockObj = this.repository.queryBySkuId(skuId);
                if (stockObj != null && skuId == stockObj.getCargoSkuId()) {
                    if (count > stockObj.getOutShelvesNo()) {
                        this.result.put("code", "000002");
                        this.result.put("msg", skuId + "\u4e0a\u67b6\u6570\u91cf\u5927\u4e8e\u73b0\u6709\u7684\u5e93\u5b58\u6570\u91cf");
                        throw new Exception(skuId + "\u4e0a\u67b6\u6570\u91cf\u5927\u4e8e\u73b0\u6709\u7684\u5e93\u5b58\u6570\u91cf");
                    }
                    stockObj.upate(count, userId, 0);
                    continue;
                }
                this.result.put("code", "000002");
                this.result.put("msg", skuId + "\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u5b58\u5728");
                throw new Exception(skuId + "\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
            this.result.put("code", "000001");
            this.result.put("msg", skuId + "\u4e0a\u67b6\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            throw new Exception(skuId + "\u4e0a\u67b6\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        this.result.put("code", "000000");
        this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
        return this.result;
    }

    private Map<String, Object> updateDownSkuGoods(List<SkuGoodsParam> list, long userId) throws Exception {
        this.result = new HashMap<String, Object>();
        CargoSkuStockDo stockObj = null;
        int count = 0;
        long skuId = 0L;
        for (SkuGoodsParam sku : list) {
            count = Integer.valueOf(sku.getNum());
            skuId = Long.valueOf(sku.getCargoSkuId());
            stockObj = this.repository.queryBySkuId(skuId);
            if (stockObj != null && skuId == stockObj.getCargoSkuId()) {
                if (count > stockObj.getOnSalesNo()) {
                    this.result.put("code", "000002");
                    this.result.put("msg", skuId + "\u4e0b\u67b6\u6570\u91cf\u5927\u4e8e\u5df2\u4e0a\u67b6\u672a\u552e\u6570\u91cf");
                    throw new Exception(skuId + "\u4e0b\u67b6\u6570\u91cf\u5927\u4e8e\u5df2\u4e0a\u67b6\u672a\u552e\u6570\u91cf");
                }
                if (count <= 0) continue;
                stockObj.upate(count, userId, 1);
                continue;
            }
            this.result.put("code", "000002");
            this.result.put("msg", skuId + "\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u5b58\u5728");
            throw new Exception(skuId + "\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        this.result.put("code", "000000");
        this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
        return this.result;
    }

    private synchronized Map<String, Object> handleStock(int status, List<CargoOutboundDetailDo> detail, long userId, List<SkuGoodsParam> list, long orderId, Map<String, Object> paramMap) throws Exception {
        switch (status) {
            case 3: {
                this.updateHandleStockOutbound(detail, userId);
                break;
            }
            case 0: {
                this.result = this.updateUpSkuGoods(list, userId);
                break;
            }
            case 1: {
                this.result = this.updateDownSkuGoods(list, userId);
                break;
            }
            case -1: {
                this.result = this.updateExceptionStock(paramMap, userId);
                break;
            }
            case -2: {
                this.result = this.updateRemainStock(paramMap, userId);
                break;
            }
            default: {
                this.result = this.updateHandleOrderStock(list, userId, status, orderId);
            }
        }
        return this.result;
    }

    private Map<String, Object> updateHandleOrderStock(List<SkuGoodsParam> list, long userId, int status, long orderId) throws Exception {
        this.result = new HashMap<String, Object>();
        CargoSkuStockDo stockObj = null;
        int count = 0;
        long skuId = 0L;
        CargoOutboundOrderDo outbound = null;
        block12: for (SkuGoodsParam sku : list) {
            count = Integer.valueOf(sku.getNum());
            System.out.println("================================================================");
            System.out.println("===========================count:" + count + "=====================================");
            System.out.println("================================================================");
            String cargoSkuId = sku.getCargoSkuId();
            if (sku.getIsSample() == null) {
                sku.setIsSample("0");
            }
            if (sku.getIsSample().equals("1")) continue;
            skuId = Long.valueOf(cargoSkuId);
            if (skuId == 0L) {
                skuId = Long.valueOf(sku.getGoodSkuId());
            }
            boolean flag = false;
            if (count > 0) {
                if (skuId > 100000000000L) {
                    stockObj = this.repository.queryBySkuId(skuId);
                } else {
                    stockObj = this.repository.queryPackageStockByBomId(skuId);
                    flag = true;
                }
                System.out.println("================================================================");
                System.out.println("=========skuId:" + skuId + "==================onPay:" + stockObj.getOnPayNo() + "=====================================");
                System.out.println("================================================================");
                if (stockObj != null && skuId == stockObj.getCargoSkuId()) {
                    switch (status) {
                        case 4: {
                            if (count > stockObj.getOnSalesNo()) {
                                this.result.put("code", "000002");
                                this.result.put("msg", skuId + "\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u4e0a\u67b6\u672a\u552e\u6570\u91cf");
                                throw new Exception(stockObj.getGoodsName() + "_\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u4e0a\u67b6\u672a\u552e\u6570\u91cf");
                            }
                            stockObj.setUpdateTime(new Date());
                            stockObj.setUpdateBy(userId);
                            stockObj.setOnSalesNo(stockObj.getOnSalesNo() - count);
                            if (sku.getGoodStatus() == 1) {
                                stockObj.setOnPayNo(stockObj.getOnPayNo() + count);
                            } else {
                                stockObj.setOutShelvesNo(stockObj.getOutShelvesNo() + count);
                            }
                            if (!flag) {
                                stockObj.update(4, count);
                                continue block12;
                            }
                            stockObj.updatePackage(4, count);
                            continue block12;
                        }
                        case 5: {
                            if (count > stockObj.getOnPayNo()) {
                                this.result.put("code", "000002");
                                this.result.put("msg", skuId + "\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u552e\u672a\u4ed8\u6b3e\u6570\u91cf");
                                throw new Exception(skuId + "\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u552e\u672a\u4ed8\u6b3e\u6570\u91cf");
                            }
                            stockObj.setUpdateTime(new Date());
                            stockObj.setUpdateBy(userId);
                            stockObj.setOnPayNo(stockObj.getOnPayNo() - count);
                            if (sku.getGoodStatus() == 1) {
                                stockObj.setOnSendNo(stockObj.getOnSendNo() + count);
                            } else {
                                stockObj.setOutShelvesNo(stockObj.getOutShelvesNo() + count);
                            }
                            if (!flag) {
                                stockObj.update(5, count);
                                continue block12;
                            }
                            stockObj.updatePackage(5, count);
                            continue block12;
                        }
                        case 6: {
                            if (count > stockObj.getOnSendNo()) {
                                this.result.put("code", "000002");
                                this.result.put("msg", skuId + "\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u552e\u5f85\u53d1\u8d27\u6570\u91cf");
                                throw new Exception(skuId + "\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u552e\u5f85\u53d1\u8d27\u6570\u91cf");
                            }
                            stockObj.setUpdateTime(new Date());
                            stockObj.setUpdateBy(userId);
                            stockObj.setOnSendNo(stockObj.getOnSendNo() - count);
                            if (!flag) {
                                stockObj.update(6, count);
                                continue block12;
                            }
                            stockObj.updatePackage(6, count);
                            continue block12;
                        }
                        case 7: {
                            if (count > stockObj.getOnPayNo()) {
                                this.result.put("code", "000002");
                                this.result.put("msg", skuId + "\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u552e\u5f85\u4ed8\u6b3e\u6570\u91cf");
                                throw new Exception(skuId + "\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u552e\u5f85\u4ed8\u6b3e\u6570\u91cf");
                            }
                            stockObj.setUpdateTime(new Date());
                            stockObj.setUpdateBy(userId);
                            stockObj.setOnPayNo(stockObj.getOnPayNo() - count);
                            if (sku.getGoodStatus() == 1) {
                                stockObj.setOnSalesNo(stockObj.getOnSalesNo() + count);
                            } else {
                                stockObj.setOutShelvesNo(stockObj.getOutShelvesNo() + count);
                            }
                            if (!flag) {
                                stockObj.update(4, count);
                                continue block12;
                            }
                            stockObj.updatePackage(4, count);
                            continue block12;
                        }
                        case 8: {
                            if (count > stockObj.getOnSendNo()) {
                                this.result.put("code", "000002");
                                this.result.put("msg", skuId + "\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u552e\u5f85\u53d1\u8d27\u6570\u91cf");
                                throw new Exception(skuId + "\u64cd\u4f5c\u6570\u91cf\u5927\u4e8e\u5df2\u552e\u5f85\u53d1\u8d27\u6570\u91cf");
                            }
                            stockObj.setUpdateTime(new Date());
                            stockObj.setUpdateBy(userId);
                            stockObj.setOnSendNo(stockObj.getOnSendNo() - count);
                            if (sku.getGoodStatus() == 1) {
                                stockObj.setOnSalesNo(stockObj.getOnSalesNo() + count);
                            } else {
                                stockObj.setOutShelvesNo(stockObj.getOutShelvesNo() + count);
                            }
                            if (!flag) {
                                stockObj.update(5, count);
                                continue block12;
                            }
                            stockObj.updatePackage(5, count);
                            continue block12;
                        }
                    }
                    throw new Exception("\u64cd\u4f5c\u72b6\u6001\u4e0d\u5b58\u5728");
                }
                this.result.put("code", "000002");
                this.result.put("msg", skuId + "\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u5b58\u5728");
                throw new Exception(skuId + "\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
            this.result.put("code", "000001");
            this.result.put("msg", skuId + "\u64cd\u4f5c\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            throw new Exception(skuId + "\u64cd\u4f5c\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        switch (status) {
            case 5: {
                outbound = this.repository.createOutboundObj(list, userId, String.valueOf(orderId), "\u9500\u552e\u51fa\u5e93");
                outbound.save();
                break;
            }
            case 6: {
                outbound = this.repository.queryOutboundBySourceNo(String.valueOf(orderId));
                if (outbound == null) {
                    throw new Exception("\u8ba2\u5355\u5f02\u5e38");
                }
                outbound.update(3, "\u9500\u552e\u51fa\u5e93");
                break;
            }
            case 8: {
                outbound = this.repository.queryOutboundBySourceNo(String.valueOf(orderId));
                outbound.update(4, "\u9500\u552e\u51fa\u5e93");
                break;
            }
        }
        this.result.put("code", "000000");
        this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
        return this.result;
    }

    private void updateHandleStockOutbound(List<CargoOutboundDetailDo> detail, long userId) throws Exception {
        if (detail != null && detail.stream().count() > 0L) {
            CargoSkuStockDo stockDo = null;
            for (CargoOutboundDetailDo outDo : detail) {
                stockDo = this.repository.queryBySkuId(outDo.getSkuId());
                if (stockDo != null) {
                    if (outDo.getCount() > stockDo.getOutShelvesNo()) {
                        throw new Exception("\u51fa\u5e93\u6570\u91cf\u5927\u4e8e\u5e93\u5b58\u6570\u91cf");
                    }
                    stockDo.setUpdateBy(userId);
                    stockDo.setUpdateTime(new Date());
                    stockDo.setOutShelvesNo(stockDo.getOutShelvesNo() - outDo.getCount());
                    stockDo.update(6, outDo.getCount());
                    continue;
                }
                throw new Exception("stockDo\u4e3a\u7a7a");
            }
        } else {
            throw new Exception("detail\u4e3a\u7a7a");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> updateStockByOrder(List<SkuGoodsParam> list, long userId, int status, long orderId) throws Exception {
        block4: {
            this.result = new HashMap<String, Object>();
            try {
                this.sqlExecuteRepository.disableForeignKeyChecks();
                if (list != null && list.stream().count() > 0L) {
                    this.result = this.handleStock(status, null, userId, list, orderId, null);
                    break block4;
                }
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570list\u4e3a\u7a7a");
                throw new Exception("\u53c2\u6570list\u4e3a\u7a7a");
            }
            finally {
                this.sqlExecuteRepository.enableForeignKeyChecks();
            }
        }
        return this.result;
    }
}

