/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.store.domain.emu.BankCardEMU;
import com.club.web.store.service.BankCardService;
import com.club.web.store.vo.BankCardVo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BankCard"})
public class BankCardController {
    @Autowired
    private BankCardService bankCardService;

    @RequestMapping(value={"/saveOrUpdateBankCard"})
    @ResponseBody
    public Map<String, Object> saveOrUpdateBankCard(@RequestParam(value="modelJson", required=true) String modelJson, HttpServletRequest request) {
        BankCardVo bankCardVo = JsonUtil.toBean(modelJson, BankCardVo.class);
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        if (loginMap != null && loginMap.get("staffId") != null) {
            long staffId = Long.parseLong(loginMap.get("staffId").toString());
            if (bankCardVo.getConnectId() == null) {
                bankCardVo.setConnectId(staffId);
            }
        } else {
            return null;
        }
        if (bankCardVo != null && bankCardVo.getBankCardIdString() != "" && bankCardVo.getBankCardIdString() != null) {
            bankCardVo.setBankCardId(Long.parseLong(bankCardVo.getBankCardIdString()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("result", this.bankCardService.saveOrUpdateBankCard(bankCardVo));
            result.put("msg", "\u7f16\u8f91\u6210\u529f");
            result.put("success", true);
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/getBankCardList"})
    @ResponseBody
    public Page getBankCardList(@RequestParam(value="start", required=true) int start, @RequestParam(value="limit", required=true) int limit, @RequestParam(value="conditionStr", required=false) String conditionStr, @RequestParam(value="name", required=false) String name) {
        HashMap result = new HashMap();
        Page page = new Page();
        if (conditionStr != null) {
            Map<String, Object> conditionMap = JsonUtil.toMap(conditionStr);
            page.setConditons(conditionMap);
        }
        if (limit >= start) {
            page.setLimit(limit);
            page.setStart(start);
        } else {
            page.setLimit(start);
            page.setStart(limit);
        }
        page = this.bankCardService.getBankCardList(page);
        return page;
    }

    @RequestMapping(value={"/updateBankCardState"})
    @ResponseBody
    public Map<String, Object> updateBankCardState(@RequestParam(value="bankCardIds", required=true) String bankCardIds, @RequestParam(value="action", required=true) String action, HttpServletRequest request) {
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (loginMap == null || loginMap.get("staffId") == null) {
            return null;
        }
        long l = Long.parseLong(loginMap.get("staffId").toString());
        try {
            String[] bankCardId = bankCardIds.split(",");
            this.bankCardService.updateBankCardState(bankCardId, action);
            result.put("msg", "\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/getBankCardTypeList"})
    @ResponseBody
    public BankCardEMU[] getBankCardTypeList() {
        BankCardEMU[] bankCardType2 = this.bankCardService.getBankCardTypeList();
        return bankCardType2;
    }
}

