/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.web.store.service.DeliveryAddressService;
import com.club.web.store.vo.DeliveryAddressVo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"DeliveryAddress"})
public class DeliveryAddressControl {
    @Autowired
    DeliveryAddressService deliveryAddressService;

    @RequestMapping(value={"saveOrUpdateDeliveryAddress"})
    @ResponseBody
    public Map<String, Object> saveTradeExpressage(@RequestParam(value="modelJson", required=true) String modelJson, String provinceName, String cityName, String countyName) {
        Map<String, Object> result = new HashMap<String, Object>();
        if (!StringUtils.isEmpty(modelJson)) {
            DeliveryAddressVo deliveryAddressVo = JsonUtil.toBean(modelJson, DeliveryAddressVo.class);
            deliveryAddressVo.setProvinceName(provinceName);
            deliveryAddressVo.setCityName(cityName);
            deliveryAddressVo.setCountyName(countyName);
            try {
                result = this.deliveryAddressService.saveOrUpdateDeliveryAddress(deliveryAddressVo);
            }
            catch (Exception e) {
                result.put("success", false);
                result.put("msg", e.getMessage());
            }
        } else {
            result.put("success", false);
            result.put("msg", "\u6570\u636e\u4e3a\u7a7a");
        }
        return result;
    }

    @RequestMapping(value={"getDeliveryAddress"})
    @ResponseBody
    public Object saveTradeExpressage(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> result = new HashMap<String, Object>();
        DeliveryAddressVo deliveryAddressVo = null;
        try {
            deliveryAddressVo = this.deliveryAddressService.getDeliveryAddress();
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            return result;
        }
        return deliveryAddressVo;
    }

    @RequestMapping(value={"mobile/getDeliveryAddress"})
    @ResponseBody
    public Object getMobileTradeExpressAddress(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> result = new HashMap<String, Object>();
        DeliveryAddressVo deliveryAddressVo = null;
        try {
            deliveryAddressVo = this.deliveryAddressService.getDeliveryAddress();
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            return result;
        }
        return deliveryAddressVo;
    }

    @RequestMapping(value={"weixin/getDeliveryAddress"})
    @ResponseBody
    public Object getWeixinDeliveryAddress(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> result = new HashMap<String, Object>();
        DeliveryAddressVo deliveryAddressVo = null;
        try {
            deliveryAddressVo = this.deliveryAddressService.getDeliveryAddress();
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            return result;
        }
        return deliveryAddressVo;
    }
}

