/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.stock.vo.SkuGoodsParam;
import com.club.web.store.service.GoodEvaluationService;
import com.club.web.store.service.GoodLabelsService;
import com.club.web.store.service.GoodService;
import com.club.web.store.vo.GoodDetailsVo;
import com.club.web.store.vo.GoodEvaluationVo;
import com.club.web.store.vo.GoodListVo;
import com.club.web.store.vo.GoodVo;
import com.club.web.store.vo.GoodsBaseLabelVo;
import com.club.web.store.vo.GoodsColumnVo;
import com.club.web.store.vo.TradeGoodSkuVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/good"})
public class GoodController {
    private Logger logger = LoggerFactory.getLogger(GoodController.class);
    @Autowired
    private GoodService goodServiceImpl;
    @Autowired
    private GoodEvaluationService evaluationService;
    @Autowired
    private GoodLabelsService goodLabelsService;

    @RequestMapping(value={"/addGood"})
    @ResponseBody
    public Map<String, Object> addGood(String modelJson, String labelIds, String cargoSkuIdList, String cargoSkuNameList, String marketPriceList, String salePriceList, String allPriceList, String count, HttpServletRequest request) {
        HashMap<String, Object> result;
        block13: {
            result = new HashMap<String, Object>();
            List<String> labelsList = null;
            List<String> skuIdList = null;
            List<String> skuNameList = null;
            List<String> mList = null;
            List<String> sList = null;
            List<String> supplyList = null;
            List<String> countList = null;
            ArrayList<String> levelIdList = null;
            GoodVo goodVo = new GoodVo();
            Map<Object, Object> map = new HashMap();
            long i = -1L;
            try {
                if (modelJson.isEmpty()) break block13;
                map = JsonUtil.toMap(modelJson);
                long creator = this.getUserId(request);
                goodVo = JsonUtil.toBean(modelJson, GoodVo.class);
                if (map != null && map.get("levelId") != null) {
                    try {
                        levelIdList = (ArrayList<String>)map.get("levelId");
                    }
                    catch (Exception e) {
                        levelIdList = new ArrayList<String>();
                        levelIdList.add(String.valueOf(map.get("levelId")));
                    }
                }
                if (labelIds != null && !labelIds.isEmpty() && !labelIds.equals("")) {
                    labelsList = JsonUtil.toList(labelIds, String.class);
                }
                if (cargoSkuIdList != null && !cargoSkuIdList.isEmpty() && !cargoSkuIdList.equals("")) {
                    skuIdList = JsonUtil.toList(cargoSkuIdList, String.class);
                    skuNameList = JsonUtil.toList(cargoSkuNameList, String.class);
                    if (skuIdList == null || skuIdList.size() == 0) {
                        result.put("success", false);
                        result.put("msg", "\u5546\u54c1\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5546\u54c1sku");
                        return result;
                    }
                } else {
                    result.put("success", false);
                    result.put("msg", "\u5546\u54c1\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5546\u54c1sku");
                    return result;
                }
                if (marketPriceList != null && !marketPriceList.isEmpty() && !marketPriceList.equals("")) {
                    mList = JsonUtil.toList(marketPriceList, String.class);
                }
                if (salePriceList != null && !salePriceList.isEmpty() && !salePriceList.equals("")) {
                    sList = JsonUtil.toList(salePriceList, String.class);
                }
                if (allPriceList != null && !allPriceList.isEmpty() && !allPriceList.equals("")) {
                    supplyList = JsonUtil.toList(allPriceList, String.class);
                }
                if (count != null && !count.isEmpty() && !count.equals("") && (countList = JsonUtil.toList(count, String.class)).size() > 0) {
                    i = Long.parseLong(countList.get(0));
                }
                this.goodServiceImpl.addGood(goodVo, labelsList, skuIdList, skuNameList, mList, sList, supplyList, i, levelIdList, request);
                result.put("success", true);
                result.put("msg", "\u6dfb\u52a0\u5546\u54c1\u6210\u529f");
            }
            catch (Exception e) {
                System.out.println("\u6dfb\u52a0\u5546\u54c1\u629b\u51fa\u5f02\u5e38:" + e.getMessage());
                result.put("success", false);
                result.put("msg", "\u6dfb\u52a0\u5546\u54c1\u5931\u8d25");
            }
        }
        return result;
    }

    @RequestMapping(value={"/editGood"})
    @ResponseBody
    public Map<String, Object> editGood(String modelJson, String labelIds, String cargoSkuIdList, String cargoSkuNameList, String marketPriceList, String salePriceList, String allPriceList, String count, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> labelsList = new ArrayList();
        List<Object> skuIdList = new ArrayList();
        ArrayList<String> skuNameList = new ArrayList();
        ArrayList<String> mList = new ArrayList();
        ArrayList<String> sList = new ArrayList();
        ArrayList<String> supplyList = new ArrayList();
        List<Object> countList = new ArrayList();
        GoodVo goodVo = new GoodVo();
        Map<Object, Object> map = new HashMap();
        List<String> levelIdList = new ArrayList();
        long i = -1L;
        try {
            map = JsonUtil.toMap(modelJson);
            long creator = this.getUserId(request);
            goodVo = JsonUtil.toBean(modelJson, GoodVo.class);
            goodVo.setCreator(creator);
            if (map != null && map.get("levelId") != null) {
                try {
                    levelIdList = (List)map.get("levelId");
                }
                catch (Exception e) {
                    levelIdList = new ArrayList();
                    levelIdList.add(String.valueOf(map.get("levelId")));
                }
            }
            if (labelIds != null && !labelIds.isEmpty() && !labelIds.equals("")) {
                labelsList = JsonUtil.toList(labelIds, String.class);
            }
            if (cargoSkuIdList != null && !cargoSkuIdList.isEmpty() && !cargoSkuIdList.equals("")) {
                skuIdList = JsonUtil.toList(cargoSkuIdList, String.class);
                skuNameList = JsonUtil.toList(cargoSkuNameList, String.class);
                if (skuIdList == null || skuIdList.size() == 0) {
                    result.put("success", false);
                    result.put("msg", "\u5546\u54c1\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5546\u54c1sku");
                    return result;
                }
            } else {
                result.put("success", false);
                result.put("msg", "\u5546\u54c1\u7de8\u8f2f\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5546\u54c1sku");
                return result;
            }
            if (marketPriceList != null && !marketPriceList.isEmpty() && !marketPriceList.equals("")) {
                mList = JsonUtil.toList(marketPriceList, String.class);
            }
            if (salePriceList != null && !salePriceList.isEmpty() && !salePriceList.equals("")) {
                sList = JsonUtil.toList(salePriceList, String.class);
            }
            if (allPriceList != null && !allPriceList.isEmpty() && !allPriceList.equals("")) {
                supplyList = JsonUtil.toList(allPriceList, String.class);
            }
            if (count != null && !count.isEmpty() && !count.equals("") && (countList = JsonUtil.toList(count, String.class)).size() > 0) {
                i = Long.parseLong((String)countList.get(0));
            }
            this.goodServiceImpl.editGood(goodVo, labelsList, skuIdList, skuNameList, mList, sList, supplyList, i, levelIdList, request);
            result.put("success", true);
            result.put("msg", "\u7f16\u8f91\u5546\u54c1\u6210\u529f");
        }
        catch (Exception e) {
            System.out.println("\u7f16\u8f91\u5546\u54c1\u629b\u51fa\u5f02\u5e38:" + e.getMessage());
            result.put("success", false);
            result.put("msg", "\u7f16\u8f91\u5546\u54c1\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/goodPage"})
    @ResponseBody
    public Page<Map<String, Object>> goodPage(Page<Map<String, Object>> page, String conditionStr, HttpServletResponse response) {
        if (conditionStr != null) {
            page.setConditons(JsonUtil.toMap(conditionStr));
        }
        page = this.goodServiceImpl.queryGoodPage(page);
        return page;
    }

    @RequestMapping(value={"/goodAllList"})
    @ResponseBody
    public List<GoodVo> goodAllList(Page<Map<String, Object>> page, String conditionStr, HttpServletResponse response) {
        if (conditionStr != null) {
            page.setConditons(JsonUtil.toMap(conditionStr));
        }
        return this.goodServiceImpl.queryGoodLittleList(page);
    }

    @RequestMapping(value={"/getGoodColumnList"})
    @ResponseBody
    public List<GoodsColumnVo> getGoodColumnList() {
        List<GoodsColumnVo> list = this.goodServiceImpl.getColumnList();
        return list;
    }

    @RequestMapping(value={"/getGoodLabels"})
    @ResponseBody
    public List<GoodsBaseLabelVo> getGoodLabels(String goodId) {
        List<GoodsBaseLabelVo> list = null;
        if (goodId != null && !goodId.equals("")) {
            list = this.goodLabelsService.selectGoodLabels(Long.parseLong(goodId));
        }
        return list;
    }

    @RequestMapping(value={"/deletegood"})
    @ResponseBody
    public Map<String, Object> deleteGood(@RequestParam(value="IdStr", required=true) String IdStr) {
        this.logger.debug("deleteGood");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.putAll(this.goodServiceImpl.deleteGoods(IdStr));
            result.put("success", true);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u5546\u54c1\u5f02\u5e38<deleteGoods>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/selectGoodSku"})
    @ResponseBody
    public Map<String, Object> selectGoodSku(@RequestParam(value="tradeGoodId", required=true) String tradeGoodId) {
        this.logger.debug("selectGoodSku");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List<Object> voList = new ArrayList();
            voList = this.goodServiceImpl.selectTradeGoodSkuVo(tradeGoodId);
            result.put("list", voList);
            result.put("success", true);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5546\u54c1SKU\u540d\u79f0\u5f02\u5e38<deleteGoods>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/upGoodSku"})
    @ResponseBody
    public Map<String, Object> upGoodSku(HttpServletRequest request, @RequestParam(value="goodupList", required=true) String goodupList, String tradeGoodId) {
        this.logger.debug("upGoodSku");
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object paramMap = null;
        Map loginMap = null;
        long userId = 0L;
        try {
            loginMap = (Map)request.getSession().getAttribute("staff");
            userId = loginMap.get("staffId") != null ? Long.valueOf(loginMap.get("staffId").toString()) : 0L;
            List<SkuGoodsParam> list = JsonUtil.toList(goodupList, SkuGoodsParam.class);
            Boolean b = this.goodServiceImpl.updateUpGoodStatus(tradeGoodId, list, userId);
            if (b.booleanValue()) {
                result.put("success", true);
            } else {
                result.put("success", false);
                result.put("msg", "\u5546\u54c1\u4e0a\u67b6\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u4e0a\u67b6\u5f02\u5e38<deleteGoods>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u5546\u54c1\u4e0a\u67b6\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/downGoodSku"})
    @ResponseBody
    public Map<String, Object> downGoodSku(HttpServletRequest request, @RequestParam(value="ids", required=true) String ids) {
        this.logger.debug("upGoodSku");
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object paramMap = null;
        Map loginMap = null;
        long userId = 0L;
        try {
            loginMap = (Map)request.getSession().getAttribute("staff");
            userId = loginMap.get("staffId") != null ? Long.valueOf(loginMap.get("staffId").toString()) : 0L;
            List<String> list = JsonUtil.toList(ids, String.class);
            Boolean b = this.goodServiceImpl.updateDownGoodStatus(list, userId);
            if (b.booleanValue()) {
                result.put("success", true);
            } else {
                result.put("success", false);
                result.put("msg", "\u5546\u54c1\u4e0b\u67b6\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u4e0b\u67b6\u5f02\u5e38<deleteGoods>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u5546\u54c1\u4e0b\u67b6\u5931\u8d25\uff01");
        }
        return result;
    }

    private long getUserId(HttpServletRequest request) {
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        long userId = loginMap.get("staffId") != null ? Long.valueOf(loginMap.get("staffId").toString()) : 0L;
        return userId;
    }

    @RequestMapping(value={"/addEvaluation"})
    @ResponseBody
    private Map<String, Object> addEvaluation(String modelJson, HttpServletRequest request, String logo1) {
        this.logger.debug("addEvaluation");
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodEvaluationVo v = new GoodEvaluationVo();
        ArrayList imageList = new ArrayList();
        String[] array = JsonUtil.toArray(logo1, String.class);
        v = JsonUtil.toBean(modelJson, GoodEvaluationVo.class);
        try {
            this.evaluationService.saveEvaluation(v, array, 1L);
            result.put("success", true);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u8bc4\u4ef7\u5f02\u5e38:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            return result;
        }
    }

    @RequestMapping(value={"/getEvaluation"})
    @ResponseBody
    private Map<String, Object> getEvaluation(@RequestParam(value="tradeGoodId", required=true) String tradeGoodId, HttpServletRequest request) {
        this.logger.debug("getEvaluation");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List<GoodEvaluationVo> list = this.evaluationService.selectEvaluationByGoodId(Long.parseLong(tradeGoodId));
            result.put("evaluationList", list);
            result.put("success", true);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5546\u54c1\u8bc4\u4ef7\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            return result;
        }
    }

    @RequestMapping(value={"/mobile/queryGoodList"})
    @ResponseBody
    public List<GoodListVo> queryGoodList(@RequestParam(value="start", defaultValue="0") int start, @RequestParam(value="limit", defaultValue="6") int limit, @RequestParam(value="columnId", defaultValue="") String columnId, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (columnId != null && !columnId.isEmpty()) {
            param.put("columnId", columnId);
        }
        param.put("start", start * limit);
        param.put("limit", limit);
        List<GoodListVo> goodList = this.goodServiceImpl.queryGoodList(param);
        return goodList;
    }

    @RequestMapping(value={"/mobile/getGoodDetails"})
    @ResponseBody
    public GoodDetailsVo getGoodDetails(long goodId, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        return this.goodServiceImpl.getGoodDetails(goodId);
    }

    @RequestMapping(value={"/queryGoodSkuList"})
    @ResponseBody
    public Map<String, Object> queryGoodSkuList(@RequestParam(value="tradeGoodId", required=true) String tradeGoodId) {
        this.logger.debug("queryGoodSkuList");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List<TradeGoodSkuVo> list = this.goodServiceImpl.queryGoodSkuList(Long.parseLong(tradeGoodId));
            result.put("goodSkuList", list);
            result.put("success", true);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u83b7\u53d6\u5546\u54c1sku\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            return result;
        }
    }

    @RequestMapping(value={"/deleteEvaluation"})
    @ResponseBody
    public Map<String, Object> deleteEvaluationCon(String id) {
        HashMap<String, Object> result = new HashMap();
        try {
            result = this.evaluationService.deleteEvaluationSer(id);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636eId\u5220\u9664\u5546\u54c1\u8bc4\u4ef7\u5f02\u5e38<deleteEvaluationCon>:", (Throwable)e);
            result.put("code", "-1");
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return result;
    }
}

