/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.store.service.GoodsBaseLabelService;
import com.club.web.store.vo.GoodsBaseLabelVo;
import com.club.web.util.IdGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/goodsBaseLabelController"})
public class GoodsBaseLabelController {
    @Autowired
    private GoodsBaseLabelService goodsBaseLabelService;

    @RequestMapping(value={"/addOrUpdGoodsBaseLabel"})
    @ResponseBody
    public Map<String, Object> addGoodsBaseLabel(String modelJson, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodsBaseLabelVo goodsBaseLabelVo = JsonUtil.toBean(modelJson, GoodsBaseLabelVo.class);
        if (goodsBaseLabelVo != null) {
            if (goodsBaseLabelVo.getId() != null && !goodsBaseLabelVo.getId().isEmpty()) {
                try {
                    result.putAll(this.goodsBaseLabelService.editGoodsBaseLabel(goodsBaseLabelVo));
                }
                catch (Exception e) {
                    result.put("success", false);
                    result.put("msg", e.getMessage());
                }
            } else {
                try {
                    result.put("success", true);
                    result.put("msg", "\u65b0\u589e\u5546\u54c1\u6807\u7b7e\u6210\u529f");
                    goodsBaseLabelVo.setId(IdGenerator.getDefault().nextId() + "");
                    goodsBaseLabelVo.setStatus(1);
                    this.goodsBaseLabelService.addGoodsBaseLabel(goodsBaseLabelVo, request);
                }
                catch (Exception e) {
                    result.put("success", false);
                    result.put("msg", e.getMessage());
                }
            }
        } else {
            result.put("success", false);
            result.put("msg", "\u65b0\u589e\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/selectGoodsBaseLabel"})
    @ResponseBody
    public Page<Map<String, Object>> selectGoodsBaseLabelByLabelName(Page<Map<String, Object>> page, String labelName, String shopFlag, HttpServletRequest request) {
        page = this.goodsBaseLabelService.selectGoodsBaseLabelByLabelName(page, labelName, shopFlag, request);
        return page;
    }

    @RequestMapping(value={"/deleteGoodsBaseLabel"})
    @ResponseBody
    public Map<String, Object> deleteGoodsBaseLabel(String idStr, String shopFlag) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (idStr != null) {
            try {
                result.put("success", true);
                result.putAll(this.goodsBaseLabelService.deleteGoodsBaseLabel(idStr, shopFlag));
            }
            catch (DataIntegrityViolationException e) {
                result.put("success", false);
                result.put("msg", "\u6807\u7b7e\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            catch (Exception e) {
                result.put("success", false);
                result.put("msg", e.getMessage());
            }
        } else {
            result.put("success", false);
            result.put("msg", "\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @RequestMapping(value={"/changeStatus"})
    @ResponseBody
    public Map<String, Object> changeStatus(String idStr, String status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (idStr != null) {
            try {
                result.put("success", true);
                result.put("msg", "\u4fee\u6539\u72b6\u6001\u6210\u529f");
                this.goodsBaseLabelService.changeStatus(idStr, status);
            }
            catch (Exception e) {
                result.put("success", false);
                result.put("msg", e.getMessage());
            }
        } else {
            result.put("success", false);
            result.put("msg", "\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @RequestMapping(value={"/selectGoodsBaseLabelListByLabelName"})
    @ResponseBody
    public List<GoodsBaseLabelVo> selectGoodsBaseLabelListByLabelName(Map<String, Object> page, String labelName, String shopFlag, HttpServletRequest request) {
        return this.goodsBaseLabelService.selectGoodsBaseLabelListByLabelName(page, labelName, shopFlag, request);
    }
}

