/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.stock.service.CargoService;
import com.club.web.stock.vo.CargoSkuSimpleVo;
import com.club.web.store.service.GoodsBaseLabelService;
import com.club.web.store.service.GoodsColumnService;
import com.club.web.store.vo.GoodsBaseLabelVo;
import com.club.web.store.vo.GoodsColumnVo;
import com.club.web.store.vo.RuleSourceVo;
import com.club.web.util.IdGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/goodsColumnController"})
public class GoodsColumnController {
    @Autowired
    private GoodsColumnService goodsColumnService;
    @Autowired
    private GoodsBaseLabelService goodsBaseLabelServiceImpl;
    @Autowired
    private CargoService cargoService;

    @RequestMapping(value={"/addOrUpdGoodsColumn"})
    @ResponseBody
    public Map<String, Object> addGoodsColumn(String modelJson, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodsColumnVo goodsColumnVo = JsonUtil.toBean(modelJson, GoodsColumnVo.class);
        if (goodsColumnVo != null) {
            if (goodsColumnVo.getId() != null && !goodsColumnVo.getId().isEmpty()) {
                result.put("success", true);
                result.put("msg", "\u7f16\u8f91\u6210\u529f");
                this.goodsColumnService.editGoodsColumn(goodsColumnVo);
            } else {
                result.put("success", true);
                result.put("msg", "\u65b0\u589e\u6210\u529f");
                goodsColumnVo.setId(IdGenerator.getDefault().nextId() + "");
                this.goodsColumnService.addGoodsColumn(goodsColumnVo, request);
            }
        } else {
            result.put("success", false);
            result.put("msg", "\u65b0\u589e\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/selectGoodsColumn"})
    @ResponseBody
    public Page<Map<String, Object>> selectGoodsColumnByColumnName(Page<Map<String, Object>> page, String columnName, String shopFlag, HttpServletRequest request) {
        page = this.goodsColumnService.selectGoodsColumnByColumnName(page, columnName, shopFlag, request);
        return page;
    }

    @RequestMapping(value={"/deleteGoodsColumn"})
    @ResponseBody
    public Map<String, Object> deleteGoodsColumn(String idStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (idStr != null) {
            try {
                result.put("success", true);
                result.putAll(this.goodsColumnService.deleteGoodsColumn(idStr));
            }
            catch (DataIntegrityViolationException e) {
                result.put("success", false);
                result.put("msg", "\u680f\u76ee\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            catch (Exception e) {
                result.put("success", false);
                result.put("msg", e.getMessage());
            }
        } else {
            result.put("success", false);
            result.put("msg", "\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @RequestMapping(value={"/updateStatusForGoodsColumnById"})
    @ResponseBody
    public Map<String, Object> changeStatus(String idStr, String status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (idStr != null) {
            result.put("success", true);
            result.putAll(this.goodsColumnService.updateStatusForGoodsColumnById(idStr, status));
        } else {
            result.put("success", false);
            result.put("msg", "\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @RequestMapping(value={"/selectGoodsColumnAndLabelListByShopId"})
    @ResponseBody
    public Map<String, Object> selectGoodsColumnListByShopId(HttpServletRequest request, String cargoId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<GoodsColumnVo> columnList = this.goodsColumnService.selectGoodsColumnListByShopId(request);
        List<GoodsBaseLabelVo> labelList = this.goodsBaseLabelServiceImpl.selectGoodsBaseLabelListByLabelName(null, "", null, request);
        List<CargoSkuSimpleVo> cargoSkuList = this.cargoService.getSkuList(Long.parseLong(cargoId));
        map.put("columns", columnList);
        map.put("labels", labelList);
        map.put("cargoSkuList", cargoSkuList);
        return map;
    }

    @RequestMapping(value={"/selectRuleSourceList"})
    @ResponseBody
    public List<RuleSourceVo> selectRuleSourceList(int ruleType, HttpServletRequest request) {
        return this.goodsColumnService.selectRuleSourceList(ruleType);
    }

    @RequestMapping(value={"/mobile/getGoodsAndCloumn"})
    @ResponseBody
    public List<Map<String, Object>> getGoodsAndCloumn(Long shopId, HttpServletResponse response) throws IOException {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        ArrayList<Map<String, Object>> result = new ArrayList();
        try {
            result = this.goodsColumnService.getGoodsAndCloumn(shopId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/mobile/selectGoodsByColumnId"})
    @ResponseBody
    public Map<String, Object> selectGoodsByColumnId(Long columnId, int start, @RequestParam(name="limit", defaultValue="6") int limit, HttpServletResponse response) throws IOException {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            result = this.goodsColumnService.selectGoodsByColumnId(columnId, start, limit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/mobile/selectColumnsGood"})
    @ResponseBody
    public List<Map<String, Object>> selectColumnsGood(HttpServletResponse response) throws IOException {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        ArrayList<Map<String, Object>> result = new ArrayList();
        try {
            result = this.goodsColumnService.selectColumnsGood();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

