/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.store.service.GoodsThemeService;
import com.club.web.store.vo.GoodsThemeVo;
import com.club.web.util.IdGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/goodsThemeController"})
public class GoodsThemeController {
    @Autowired
    private GoodsThemeService goodsThemeService;

    @RequestMapping(value={"/addOrUpdGoodsTheme"})
    @ResponseBody
    public Map<String, Object> addGoodsTheme(String modelJson, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodsThemeVo goodsThemeVo = JsonUtil.toBean(modelJson, GoodsThemeVo.class);
        if (goodsThemeVo != null) {
            if (goodsThemeVo.getId() != null && !goodsThemeVo.getId().isEmpty()) {
                result.put("success", true);
                result.put("msg", "\u7f16\u8f91\u6210\u529f");
                goodsThemeVo.setUpdateTime(new Date());
                this.goodsThemeService.editGoodsTheme(goodsThemeVo);
            } else {
                result.put("success", true);
                result.put("msg", "\u65b0\u589e\u6210\u529f");
                goodsThemeVo.setCreateTime(new Date());
                goodsThemeVo.setId(IdGenerator.getDefault().nextId() + "");
                this.goodsThemeService.addGoodsTheme(goodsThemeVo, request);
            }
        } else {
            result.put("success", false);
            result.put("msg", "\u65b0\u589e\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/selectGoodsTheme"})
    @ResponseBody
    public Page<Map<String, Object>> selectGoodsThemeByThemeName(Page<Map<String, Object>> page, String ThemeName, String status, HttpServletRequest request) {
        page = this.goodsThemeService.selectGoodsThemeByThemeName(page, ThemeName, status, request);
        return page;
    }

    @RequestMapping(value={"/deleteGoodsTheme"})
    @ResponseBody
    public Map<String, Object> deleteGoodsTheme(String idStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (idStr != null) {
            try {
                result.put("success", true);
                result.putAll(this.goodsThemeService.deleteGoodsTheme(idStr));
            }
            catch (DataIntegrityViolationException e) {
                result.put("success", false);
                result.put("msg", "\u680f\u76ee\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            catch (Exception e) {
                result.put("success", false);
                result.put("msg", e.getMessage());
            }
        } else {
            result.put("success", false);
            result.put("msg", "\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @RequestMapping(value={"/updateStatusForGoodsThemeById"})
    @ResponseBody
    public Map<String, Object> changeStatus(String idStr, String status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (idStr != null) {
            result.put("success", true);
            result.putAll(this.goodsThemeService.updateStatusForGoodsThemeById(idStr, status));
        } else {
            result.put("success", false);
            result.put("msg", "\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @RequestMapping(value={"/selectAll"})
    @ResponseBody
    public Map<String, Object> selectAll(Integer limit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.putAll(this.goodsThemeService.selectGoodsThemeForMobileIndex(limit));
        return result;
    }
}

