/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.web.store.service.SalesReturnReasonService;
import com.club.web.store.vo.SalesReturnReasonVo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"SalesReturnReason"})
public class SalesReturnReasonControl {
    @Autowired
    SalesReturnReasonService salesReturnReasonService;

    @RequestMapping(value={"saveOrUpdateSalesReturnReason"})
    @ResponseBody
    public Map<String, Object> saveOrUpdateSalesReturnReason(@RequestParam(value="modelJson", required=true) String modelJson) {
        SalesReturnReasonVo salesReturnReasonVo = JsonUtil.toBean(modelJson, SalesReturnReasonVo.class);
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            if (salesReturnReasonVo != null) {
                result = this.salesReturnReasonService.saveOrUpdateSalesReturnReason(salesReturnReasonVo);
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"getSalesReturnReason"})
    @ResponseBody
    public Page getSalesReturnReason(@RequestParam(value="limit", required=true) int limit, @RequestParam(value="start", required=true) int start, HttpServletRequest request) {
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        Page page = new Page();
        if (loginMap == null || loginMap.get("staffId") == null) {
            return null;
        }
        long l = Long.parseLong(loginMap.get("staffId").toString());
        page.setLimit(limit);
        page.setStart(start);
        try {
            page = this.salesReturnReasonService.getSalesReturnReason(page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return page;
    }

    @RequestMapping(value={"deletSalesReturnReason"})
    @ResponseBody
    public Map<String, Object> deletSalesReturnReason(@RequestParam(value="ids", required=true) String ids) {
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            if (!StringUtils.isEmpty(ids)) {
                result = this.salesReturnReasonService.deletSalesReturnReason(ids);
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }
}

