/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.web.store.service.ShoppingCartService;
import com.club.web.store.vo.ShoppingCartVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/mobile"})
@Controller
public class ShoppingCartController {
    private Logger logger = LoggerFactory.getLogger(ShoppingCartController.class);
    @Autowired
    ShoppingCartService cart;
    private Map<String, Object> result;

    @RequestMapping(value={"/cart/queryCart"})
    @ResponseBody
    public List<ShoppingCartVo> queryCartCon(HttpServletResponse response, String userId) {
        List<ShoppingCartVo> list = null;
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("text/json;charset=utf-8");
            long user = Long.valueOf(userId);
            list = this.cart.queryShoppingCartByUserId(user, 0);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u5f02\u5e38<queryCartCon>:", (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/store/queryStore"})
    @ResponseBody
    public List<ShoppingCartVo> queryStoreCon(HttpServletResponse response, String userId) {
        List<ShoppingCartVo> list = null;
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("text/json;charset=utf-8");
            long user = Long.valueOf(userId);
            list = this.cart.queryShoppingCartByUserId(user, 1);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6536\u85cf\u5546\u54c1\u5f02\u5e38<queryStoreCon>:", (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/cart/addCart"})
    @ResponseBody
    public Map<String, Object> addCartCon(String userId, String goodsId, @RequestParam(defaultValue="0") String shopId, int count, HttpServletResponse response) {
        this.result = new HashMap<String, Object>();
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("text/json;charset=utf-8");
            long user = Long.valueOf(userId);
            this.result = this.cart.addShoppingCartByUserId(user, goodsId, shopId, count, 0.0, 0, 0);
        }
        catch (Exception e) {
            this.logger.error("\u52a0\u5165\u8d2d\u7269\u8f66\u5f02\u5e38<addCartCon>:", (Throwable)e);
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        return this.result;
    }

    @RequestMapping(value={"/store/addStore"})
    @ResponseBody
    public Map<String, Object> addStoreCon(HttpServletResponse response, String userId, String goodsId, @RequestParam(defaultValue="") String shopId, @RequestParam(defaultValue="0") int count) {
        this.result = new HashMap<String, Object>();
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("text/json;charset=utf-8");
            long user = Long.valueOf(userId);
            this.result = this.cart.addShoppingCartByUserId(user, goodsId, shopId, count, 0.0, 1, 0);
        }
        catch (Exception e) {
            this.logger.error("\u52a0\u5165\u5546\u54c1\u5230\u6536\u85cf\u5f02\u5e38<addStoreCon>:", (Throwable)e);
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        return this.result;
    }

    @RequestMapping(value={"/cart/updateCart"})
    @ResponseBody
    public Map<String, Object> updateCartCon(String userId, String goodsId, int count, int status, HttpServletResponse response) {
        this.result = new HashMap<String, Object>();
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("text/json;charset=utf-8");
            long user = Long.valueOf(userId);
            this.result = this.cart.updateShoppingCartGoodsCount(user, goodsId, "0", count, status, 0, 0);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\u5f02\u5e38<updateCartCon>:", (Throwable)e);
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        return this.result;
    }

    @RequestMapping(value={"/cart/delCart"})
    @ResponseBody
    public Map<String, Object> delCartCon(String userId, String goodsIds, HttpServletResponse response) {
        this.result = new HashMap<String, Object>();
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("text/json;charset=utf-8");
            long user = Long.valueOf(userId);
            this.result = this.cart.deleteShoppingCartGoods(user, goodsIds, "0", 0, 0);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\u5f02\u5e38<updateCartCon>:", (Throwable)e);
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        return this.result;
    }

    @RequestMapping(value={"/store/delStore"})
    @ResponseBody
    public Map<String, Object> delStoreCon(String userId, String goodsIds, HttpServletResponse response) {
        this.result = new HashMap<String, Object>();
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("text/json;charset=utf-8");
            long user = Long.valueOf(userId);
            this.result = this.cart.deleteShoppingCartGoods(user, goodsIds, "0", 1, 0);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\u5f02\u5e38<updateCartCon>:", (Throwable)e);
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        return this.result;
    }
}

