/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.web.store.service.StoreService;
import com.club.web.store.vo.ClassifyVO;
import com.club.web.store.vo.DiscountGoodsVO;
import com.club.web.store.vo.GoodsCommentVO;
import com.club.web.store.vo.GoodsDetailVO;
import com.club.web.store.vo.GoodsSimpleVO;
import com.club.web.store.vo.OrderSimpleVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/store"})
public class StoreController {
    @Autowired
    private StoreService storeService;

    @RequestMapping(value={"index"})
    public String index(Model model) {
        return "/store/index";
    }

    @RequestMapping(value={"order"})
    public String order(Model model) {
        return "/store/order";
    }

    @RequestMapping(value={"product"})
    public String product(Model model) {
        return "/store/product";
    }

    @RequestMapping(value={"sureOrder"})
    public String sureOrder(Model model) {
        return "/store/sure_order";
    }

    @RequestMapping(value={"/getClassify"})
    @ResponseBody
    public List<ClassifyVO> getClassify() {
        return this.storeService.getClassifyList();
    }

    @RequestMapping(value={"/getDiscountGoods"})
    @ResponseBody
    public DiscountGoodsVO getDiscountGoods() {
        return this.storeService.getDiscountGoods();
    }

    @RequestMapping(value={"/getRecommendGoods"})
    @ResponseBody
    public List<GoodsSimpleVO> getRecommendGoods(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        return this.storeService.getRecommendGoods();
    }

    @RequestMapping(value={"/getProvateCustomLeather"})
    @ResponseBody
    public List<GoodsSimpleVO> getProvateCustomLeather(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        return this.storeService.getGoodsList(0x1000000AL, 1);
    }

    @RequestMapping(value={"/getHotGoods"})
    @ResponseBody
    public List<GoodsSimpleVO> getHotGoods(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        return this.storeService.getHotGoods();
    }

    @RequestMapping(value={"/getGoodsList"})
    @ResponseBody
    public List<GoodsSimpleVO> getGoodsList(HttpServletResponse response, @RequestParam(value="classifyId", defaultValue="0") long classifyId, @RequestParam(value="page") int page) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        return this.storeService.getGoodsList(classifyId, page);
    }

    @RequestMapping(value={"/getGoodsInfo"})
    @ResponseBody
    public GoodsDetailVO getGoodsInfo(@RequestParam(value="goodsId") long goodsId, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        return this.storeService.getGoodsInfo(goodsId);
    }

    @RequestMapping(value={"/getComment"})
    @ResponseBody
    public GoodsCommentVO getComment(@RequestParam(value="goodsId") long goodsId, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        return this.storeService.getComment(goodsId);
    }

    @RequestMapping(value={"/getOrders"})
    @ResponseBody
    public List<OrderSimpleVO> getOrders(@RequestParam(value="orderStatus", defaultValue="0") int orderStatus, @RequestParam(value="page") int page, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        return this.storeService.getOrders(orderStatus, page);
    }

    @RequestMapping(value={"/getQrCode"})
    @ResponseBody
    public Map<String, Object> getQrCode(@RequestParam(value="userId") String userId, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("qrcode", this.storeService.getQrCode(userId));
        return map;
    }
}

