/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.store.service.StoreLevelService;
import com.club.web.store.vo.StoreLevelVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/store/level"})
public class StoreLevelController {
    private Logger logger = LoggerFactory.getLogger(StoreLevelController.class);
    @Autowired
    private StoreLevelService storeLevelService;

    @RequestMapping(value={"/saveOrUpdateStoreLevel"})
    @ResponseBody
    public Map<String, Object> saveOrUpdateStoreLevel(@RequestParam(value="modelJson", required=true) String modelJson, HttpServletRequest request) {
        this.logger.debug("saveOrUpdateStoreLevel ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (modelJson != null && !"".equals(modelJson)) {
                StoreLevelVo storeLevelVo = JsonUtil.toBean(modelJson, StoreLevelVo.class);
                if (storeLevelVo == null) {
                    result.put("success", false);
                    result.put("msg", "\u5e97\u94fa\u7b49\u7ea7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    result.putAll(this.storeLevelService.saveOrUpdateStoreLevel(storeLevelVo, request));
                }
            } else {
                result.put("success", false);
                result.put("msg", "\u5e97\u94fa\u7b49\u7ea7\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4modelJson\u53c2\u6570\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u4e3ajson\u683c\u5f0f");
            }
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91\u5e97\u94fa\u7b49\u7ea7\u5f02\u5e38<saveOrUpdateStoreLevel>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/storeLevelPage"})
    @ResponseBody
    public Page<Map<String, Object>> storeLevelPage(Page<Map<String, Object>> page, HttpServletRequest request) {
        page = this.storeLevelService.queryStoreLevelPage(page, request);
        return page;
    }

    @RequestMapping(value={"/deleteStoreLevel"})
    @ResponseBody
    public Map<String, Object> deleteStoreLevel(@RequestParam(value="IdStr", required=true) String IdStr) {
        HashMap<String, Object> result;
        block2: {
            this.logger.debug("deleteStoreLevel ");
            result = new HashMap<String, Object>();
            try {
                result.putAll(this.storeLevelService.deleteStoreLevel(IdStr));
            }
            catch (Exception e) {
                this.logger.error("\u5220\u9664\u5e97\u94fa\u7b49\u7ea7\u5f02\u5e38<deleteStoreLevelCon>:", (Throwable)e);
                result.put("success", false);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
                if (!(e instanceof DataIntegrityViolationException)) break block2;
                result.put("msg", "\u5220\u9664\u9009\u9879\u5b58\u5728\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            }
        }
        return result;
    }

    @RequestMapping(value={"/updateStoreLevelStatue"})
    @ResponseBody
    public Map<String, Object> updateStoreLevelStatue(@RequestParam(value="IdStr", required=true) String IdStr, @RequestParam(value="statue", required=true) Long statue, HttpServletRequest request) {
        this.logger.debug("updateStoreLevelStatue ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.putAll(this.storeLevelService.updateStoreLevelStatue(IdStr, statue, request));
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5e97\u94fa\u7b49\u7ea7\u72b6\u6001\u5f02\u5e38<updateStoreLevelStatue>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/findAllStoreLevel"})
    @ResponseBody
    public List<StoreLevelVo> findAllStoreLevel(HttpServletRequest request) {
        List<StoreLevelVo> levelVoList = null;
        try {
            levelVoList = this.storeLevelService.findAllStoreLevel(request);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u603b\u5e97\u6709\u6548\u7684\u5e97\u94fa\u7b49\u7ea7<findAllStoreLevel>:", (Throwable)e);
        }
        return levelVoList;
    }
}

