/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.framework.util.JsonUtil;
import com.club.web.store.constant.TimeCycleType;
import com.club.web.store.service.TimeCycleService;
import com.club.web.store.vo.TimeCycleVo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/timecycle"})
public class TimeCycleControl {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TimeCycleService timeCycleService;

    @RequestMapping(value={"/saveOrUpdate/{action}"})
    @ResponseBody
    public Map<String, Object> saveOrUpdate(@PathVariable String action, @RequestParam(value="modelJson", required=true) String modelJson) {
        this.logger.info("timecycle saveOrUpdate");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            TimeCycleVo timeCycle = JsonUtil.toBean(modelJson, TimeCycleVo.class);
            timeCycle.setType(TimeCycleType.getDbDataByName(action));
            result = this.timeCycleService.saveOrUpdate(timeCycle);
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", "\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01");
            this.logger.error("timecycle saveOrUpdate error:", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/detail/{action}"})
    @ResponseBody
    public TimeCycleVo detail(@PathVariable String action) {
        this.logger.info("timecycle detail");
        try {
            return this.timeCycleService.detail(TimeCycleType.getDbDataByName(action));
        }
        catch (Exception e) {
            this.logger.error("timecycle detail error:", (Throwable)e);
            return null;
        }
    }
}

