/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.store.service.TradeEexpressageService;
import com.club.web.store.vo.TradeEexpressageVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"Expressage"})
public class TradeExpressageControl {
    @Autowired
    TradeEexpressageService tradeEexpressageService;

    @RequestMapping(value={"saveOrUpdateExpressage"})
    @ResponseBody
    public Map<String, Object> saveTradeExpressage(@RequestParam(value="modelJson", required=true) String modelJson) {
        TradeEexpressageVo tradeEexpressageVo = JsonUtil.toBean(modelJson, TradeEexpressageVo.class);
        HashMap<String, Object> result = new HashMap<String, Boolean>();
        try {
            result = this.tradeEexpressageService.saveOrUpdateExpressage(tradeEexpressageVo);
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/getExpressageList"})
    @ResponseBody
    public Page getExpressageList(@RequestParam(value="start", required=true) int start, @RequestParam(value="limit", required=true) int limit, @RequestParam(value="conditionStr", required=false) String conditionStr) {
        HashMap result = new HashMap();
        Page page = new Page();
        if (conditionStr != null) {
            Map<String, Object> conditionMap = JsonUtil.toMap(conditionStr);
            page.setConditons(conditionMap);
        }
        if (limit >= start) {
            page.setLimit(limit);
            page.setStart(start);
        } else {
            page.setLimit(start);
            page.setStart(limit);
        }
        page = this.tradeEexpressageService.getExpressageList(page);
        return page;
    }

    @RequestMapping(value={"/getExpressageUseList"})
    @ResponseBody
    public List<TradeEexpressageVo> getExpressageUseList(@RequestParam(value="start", required=true) int start, @RequestParam(value="limit", required=true) int limit) {
        HashMap result = new HashMap();
        Page page = new Page();
        if (limit >= start) {
            page.setLimit(limit);
            page.setStart(start);
        } else {
            page.setLimit(start);
            page.setStart(limit);
        }
        List<TradeEexpressageVo> tradeEexpressageVo = this.tradeEexpressageService.getExpressageUseList(page);
        return tradeEexpressageVo;
    }

    @RequestMapping(value={"deleteExpressage"})
    @ResponseBody
    public Map<String, Object> deleteExpressage(@RequestParam(value="expressageIds", required=true) String expressageIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] expressageId = expressageIds.split(",");
            this.tradeEexpressageService.deleteExpressage(expressageId);
            result.put("msg", "\u5220\u9664\u6210\u529f");
            result.put("success", true);
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/updateExpressageState"})
    @ResponseBody
    public Map<String, Object> updateExpressageState(@RequestParam(value="expressageIds", required=true) String expressageIds, @RequestParam(value="action", required=true) String action, HttpServletRequest request) {
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (loginMap == null || loginMap.get("staffId") == null) {
            return null;
        }
        long l = Long.parseLong(loginMap.get("staffId").toString());
        try {
            String[] expressageId = expressageIds.split(",");
            this.tradeEexpressageService.updateExpressageState(expressageId, action);
            result.put("success", true);
            result.put("msg", "\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }
}

