/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.controller;

import com.club.core.common.Page;
import com.club.framework.exception.BaseAppException;
import com.club.framework.util.JsonUtil;
import com.club.web.common.Constants;
import com.club.web.common.service.IBaseService;
import com.club.web.store.service.TradeHeadStoreService;
import com.club.web.store.vo.TradeHeadStoreVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/trade/headStore"})
public class TradeHeadStoreController {
    private Logger logger = LoggerFactory.getLogger(TradeHeadStoreController.class);
    @Autowired
    private TradeHeadStoreService tradeHeadStoreService;
    @Autowired
    private IBaseService baseService;

    @RequestMapping(value={"/saveOrUpdateTradeHeadStore"})
    @ResponseBody
    public Map<String, Object> saveOrUpdateTradeHeadStore(@RequestParam(value="modelJson", required=true) String modelJson, HttpServletRequest request) {
        this.logger.debug("saveOrUpdateTradeHeadStore ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (modelJson != null && !"".equals(modelJson)) {
                TradeHeadStoreVo tradeHeadStoreVo = JsonUtil.toBean(modelJson, TradeHeadStoreVo.class);
                if (tradeHeadStoreVo == null) {
                    result.put("success", false);
                    result.put("msg", "\u603b\u5e97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    result.putAll(this.tradeHeadStoreService.saveOrUpdateTradeHeadStore(tradeHeadStoreVo, request));
                }
            } else {
                result.put("success", false);
                result.put("msg", "\u603b\u5e97\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4modelJson\u53c2\u6570\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u4e3ajson\u683c\u5f0f");
            }
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91\u603b\u5e97\u5f02\u5e38<saveOrUpdateTradeHeadStoreCon>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/deleteTradeHeadStore"})
    @ResponseBody
    public Map<String, Object> deleteTradeHeadStore(@RequestParam(value="IdStr", required=true) String IdStr) {
        HashMap<String, Object> result;
        block2: {
            this.logger.debug("deleteTradeHeadStore ");
            result = new HashMap<String, Object>();
            try {
                result.putAll(this.tradeHeadStoreService.deleteTradeHeadStore(IdStr));
            }
            catch (Exception e) {
                this.logger.error("\u5220\u9664\u603b\u5e97\u4fe1\u606f\u5f02\u5e38<deleteTradeHeadStoreCon>:", (Throwable)e);
                result.put("success", false);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
                if (!(e instanceof DataIntegrityViolationException)) break block2;
                result.put("msg", "\u5220\u9664\u9009\u9879\u5b58\u5728\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            }
        }
        return result;
    }

    @RequestMapping(value={"/tradeHeadStorePage"})
    @ResponseBody
    public Page<Map<String, Object>> tradeHeadStorePage(Page<Map<String, Object>> page, String conditionStr, HttpServletRequest request) {
        if (conditionStr != null) {
            page.setConditons(JsonUtil.toMap(conditionStr));
        }
        page = this.tradeHeadStoreService.queryTradeHeadStorePage(page, request);
        return page;
    }

    @RequestMapping(value={"/updateTradeHeadStoreStatue"})
    @ResponseBody
    public Map<String, Object> updateTradeHeadStoreStatue(@RequestParam(value="IdStr", required=true) String IdStr, @RequestParam(value="statue", required=true) Long statue, HttpServletRequest request) {
        this.logger.debug("updateTradeHeadStoreStatue ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.putAll(this.tradeHeadStoreService.updateTradeHeadStoreStatue(IdStr, statue, request));
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u603b\u5e97\u72b6\u6001\u5f02\u5e38<updateTradeHeadStoreStatue>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/getClient"})
    @ResponseBody
    public Map<String, Object> getClient() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            HashMap clientMap = new HashMap();
            HashMap<String, Object> conditions = new HashMap<String, Object>(2);
            conditions.put("staffState", Constants.Status.PUBLISH.toString());
            List<Map<String, Object>> list = this.baseService.selectList("staff_t", conditions);
            result.put("success", true);
            result.put("list", list);
        }
        catch (BaseAppException e) {
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return result;
    }
}

