/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.dao.repository;

import com.club.web.store.dao.base.po.CarouselImg;
import com.club.web.store.dao.extend.CarouselImgExtendMapper;
import com.club.web.store.domain.CarouselImgDo;
import com.club.web.store.domain.repository.CarouselImgRepository;
import com.club.web.store.vo.CarouselImgPrevVo;
import com.club.web.store.vo.CarouselImgVo;
import com.club.web.util.IdGenerator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CarouselImgRepositoryImpl
implements CarouselImgRepository {
    @Autowired
    CarouselImgExtendMapper caouselDao;

    @Override
    public List<CarouselImgVo> queryCarouselImgList(int status, String matchParam, int startIndex, int pageSize) {
        List<CarouselImgVo> list = this.caouselDao.queryCarouselImgList(status, matchParam, startIndex, pageSize);
        return list;
    }

    @Override
    public List<Map<String, Object>> queryBannerImgList(int status, String matchParam, int startIndex, int pageSize) {
        List<Map<String, Object>> list = this.caouselDao.queryBannerImgList(status, matchParam, startIndex, pageSize);
        return list;
    }

    @Override
    public int queryCarouselImgListTotal(int status, String matchParam) {
        int total = this.caouselDao.queryCarouselImgListTotal(status, matchParam);
        return total;
    }

    @Override
    public int queryBannerImgListTotal(int status, String matchParam) {
        int total = this.caouselDao.queryBannerImgListTotal(status, matchParam);
        return total;
    }

    @Override
    public <T> void save(T t) throws Exception {
        if (t != null) {
            if (t instanceof CarouselImgDo) {
                CarouselImgDo carouse = (CarouselImgDo)t;
                CarouselImg carousePo = new CarouselImg();
                BeanUtils.copyProperties((Object)carousePo, (Object)carouse);
                this.caouselDao.insert(carousePo);
            }
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public <T> void update(T t) throws Exception {
        if (t != null) {
            if (t instanceof CarouselImgDo) {
                CarouselImgDo carouse = (CarouselImgDo)t;
                CarouselImg carousePo = new CarouselImg();
                BeanUtils.copyProperties((Object)carousePo, (Object)carouse);
                this.caouselDao.updateByPrimaryKeyWithBLOBs(carousePo);
            }
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public CarouselImgDo createCarouseObj(Map<String, Object> paramMap) {
        CarouselImgDo carousel = null;
        long id = -1L;
        if (paramMap.containsKey("carouse_id")) {
            id = paramMap.get("carouse_id") != null && !"".equals(paramMap.get("carouse_id").toString()) ? Long.valueOf(paramMap.get("carouse_id").toString()) : -1L;
        }
        int lineStatus = Integer.valueOf(paramMap.get("lineStatus").toString());
        carousel = this.queryCarouselById(id);
        String picUrl = paramMap.get("picUrl").toString();
        int lastIndex = picUrl.indexOf("-img");
        if (lastIndex > 0) {
            picUrl = picUrl.substring(0, lastIndex);
        }
        if (carousel != null) {
            carousel.setFlag(0);
            carousel.setId(id);
            carousel.setExtendId(carousel.getPicUrl());
            carousel.setRemk(paramMap.get("remk").toString());
            carousel.setStatus(Integer.valueOf(paramMap.get("status").toString()));
            carousel.setCategory(Long.valueOf(paramMap.get("category").toString()));
            carousel.setSort(Integer.valueOf(paramMap.get("sort").toString()));
            carousel.setLineStatus(lineStatus);
            carousel.setUpdateTime(new Date());
            carousel.setPicUrl(picUrl);
            if (lineStatus == 0) {
                carousel.setRichText(paramMap.get("richTextVal") != null ? paramMap.get("richTextVal").toString() : "");
            } else {
                carousel.setRichText(paramMap.get("richTextUrl") != null ? paramMap.get("richTextUrl").toString() : "");
            }
        } else {
            carousel = new CarouselImgDo();
            carousel.setFlag(1);
            carousel.setId(IdGenerator.getDefault().nextId());
            carousel.setRemk(paramMap.get("remk").toString());
            carousel.setStatus(Integer.valueOf(paramMap.get("status").toString()));
            carousel.setCategory(Long.valueOf(paramMap.get("category").toString()));
            carousel.setSort(Integer.valueOf(paramMap.get("sort").toString()));
            carousel.setLineStatus(lineStatus);
            carousel.setCreateTime(new Date());
            carousel.setUpdateTime(new Date());
            carousel.setPicUrl(picUrl);
            if (lineStatus == 0) {
                carousel.setRichText(paramMap.get("richTextVal") != null ? paramMap.get("richTextVal").toString() : "");
            } else {
                carousel.setRichText(paramMap.get("richTextUrl") != null ? paramMap.get("richTextUrl").toString() : "");
            }
        }
        return carousel;
    }

    @Override
    public void delCarouselImg(List<Long> ids) {
        this.caouselDao.delCarouselImg(ids);
    }

    @Override
    public CarouselImgDo queryCarouselById(long id) {
        CarouselImgDo carousel = this.caouselDao.queryCarouselById(id);
        return carousel;
    }

    @Override
    public List<CarouselImgPrevVo> getCarouselByCatory(long categoryId) {
        List<CarouselImgPrevVo> list = this.caouselDao.getCarouselByCatory(categoryId);
        return list;
    }

    @Override
    public Map<String, Object> getRichTextById(long id) {
        Map<String, Object> result = this.caouselDao.getRichTextById(id);
        return result;
    }
}

