/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.dao.repository;

import com.club.core.common.Page;
import com.club.framework.util.BeanUtils;
import com.club.web.stock.constant.CargoClassifyStatus;
import com.club.web.stock.domain.repository.CargoClassifyRepository;
import com.club.web.store.constant.GoodStatus;
import com.club.web.store.dao.base.po.TradeGood;
import com.club.web.store.dao.extend.TradeGoodExtendMapper;
import com.club.web.store.domain.GoodUpDo;
import com.club.web.store.domain.TradeGoodDo;
import com.club.web.store.domain.repository.GoodRepository;
import com.club.web.store.domain.repository.GoodSKURepository;
import com.club.web.store.domain.repository.GoodsBaseLabelRepository;
import com.club.web.store.domain.repository.GoodsColumnRepository;
import com.club.web.store.domain.repository.StoreLevelRepository;
import com.club.web.store.vo.GoodListVo;
import com.club.web.store.vo.GoodVo;
import com.club.web.store.vo.TradeGoodVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GoodReposityImpl
implements GoodRepository {
    @Autowired
    TradeGoodExtendMapper tradeGoodMapper;
    @Autowired
    GoodsColumnRepository goodsColumnRepository;
    @Autowired
    GoodsBaseLabelRepository goodsBaseLabelRepository;
    @Autowired
    GoodSKURepository goodSkuRepository;
    @Autowired
    private StoreLevelRepository storeLevelRepository;
    @Autowired
    private CargoClassifyRepository cargoClassifyRepository;

    @Override
    public void addGood(TradeGoodDo tradeGoodDo) {
        TradeGood tradeGood = new TradeGood();
        BeanUtils.copyProperties(tradeGoodDo, tradeGood);
        this.tradeGoodMapper.insert(tradeGood);
    }

    @Override
    public void updateTradeGood(TradeGoodDo tradeGoodDo) {
        TradeGood tradeGood = new TradeGood();
        BeanUtils.copyProperties(tradeGoodDo, tradeGood);
        this.tradeGoodMapper.updateByPrimaryKey(tradeGood);
    }

    @Override
    public void deleteTradeGood(long id) {
        this.tradeGoodMapper.deleteByPrimaryKey(id);
    }

    @Override
    public List<GoodVo> queryGoodPage(Page<Map<String, Object>> page) {
        List<Long> classifyIds;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditions", page.getConditons().get("conditions").toString());
        map.put("conditions1", page.getConditons().get("conditions1").toString());
        if (page.getConditons().get("statusConditions") != null && Long.parseLong(page.getConditons().get("statusConditions").toString()) > -1L) {
            map.put("statusConditions", page.getConditons().get("statusConditions").toString());
        }
        if (page.getConditons().get("goodColumnId") != null && !page.getConditons().get("goodColumnId").equals("")) {
            map.put("goodColumnId", page.getConditons().get("goodColumnId").toString());
        }
        if (page.getConditons().get("cargoBrandId") != null && !page.getConditons().get("cargoBrandId").equals("")) {
            map.put("cargoBrandId", page.getConditons().get("cargoBrandId").toString());
        }
        if (page.getConditons().get("cargoClassifyId") != null && !page.getConditons().get("cargoClassifyId").equals("") && (classifyIds = this.cargoClassifyRepository.getAllIdsByIdAndStatus(Long.valueOf(page.getConditons().get("cargoClassifyId").toString()), CargoClassifyStatus.\u542f\u7528.getDbData())) != null && classifyIds.size() > 0) {
            map.put("classifyIds", classifyIds);
        }
        map.put("start", page.getStart());
        if (page.getLimit() == 99999) {
            page.setLimit(20);
        }
        map.put("limit", page.getLimit());
        List<GoodVo> list = this.tradeGoodMapper.queryGoodPage(map);
        for (GoodVo goodVo : list) {
            goodVo.setStatusName(GoodStatus.getTextByDbData(goodVo.getStatus()));
        }
        return list;
    }

    @Override
    public Long queryGoodCountPage(Page<Map<String, Object>> page) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditions", page.getConditons().get("conditions").toString());
        map.put("conditions1", page.getConditons().get("conditions1").toString());
        if (page.getConditons().get("statusConditions") != null && Long.parseLong(page.getConditons().get("statusConditions").toString()) > -1L) {
            map.put("statusConditions", page.getConditons().get("statusConditions").toString());
        }
        if (page.getConditons().get("goodColumnId") != null && !page.getConditons().get("goodColumnId").equals("")) {
            map.put("goodColumnId", page.getConditons().get("goodColumnId").toString());
        }
        if (page.getConditons().get("cargoBrandId") != null && !page.getConditons().get("cargoBrandId").equals("")) {
            map.put("cargoBrandId", page.getConditons().get("cargoBrandId").toString());
        }
        if (page.getConditons().get("cargoClassifyId") != null && !page.getConditons().get("cargoClassifyId").equals("")) {
            List<Long> classifyIds = this.cargoClassifyRepository.getAllIdsByIdAndStatus(Long.valueOf(page.getConditons().get("cargoClassifyId").toString()), CargoClassifyStatus.\u542f\u7528.getDbData());
            map.put("classifyIds", classifyIds);
        }
        return this.tradeGoodMapper.queryGoodCountPage(map);
    }

    @Override
    public void updateStatus(Map<String, Object> map) {
        this.tradeGoodMapper.updateStatus(map);
    }

    @Override
    public Long ifGoodExgist(long cargoId) {
        return this.tradeGoodMapper.selectGoodNumsByCargoId(cargoId);
    }

    @Override
    public List<GoodListVo> queryGoodList(Map<String, Object> map) {
        return this.tradeGoodMapper.queryGoodList(map);
    }

    @Override
    public List<GoodListVo> queryGoodLittleList() {
        return this.tradeGoodMapper.queryGoodLittleList();
    }

    @Override
    public TradeGoodVo queryTradeGoodInfo(long goodId) {
        TradeGoodVo tradeGoodVo = new TradeGoodVo();
        TradeGood tradeGood = this.tradeGoodMapper.selectByPrimaryKey(goodId);
        if (tradeGood != null) {
            BeanUtils.copyProperties(tradeGood, tradeGoodVo);
        }
        return tradeGoodVo;
    }

    @Override
    public List<GoodVo> selectGoodIdByCategory(Long category) {
        return this.tradeGoodMapper.selectGoodByCategory(category);
    }

    @Override
    public void updateSaleNumById(List<GoodUpDo> list) {
        for (GoodUpDo goodUpDo : list) {
            this.tradeGoodMapper.updateSaleNumById(goodUpDo);
        }
    }
}

