/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.dao.repository;

import com.club.framework.util.BeanUtils;
import com.club.web.store.dao.base.po.TradeGoodSku;
import com.club.web.store.dao.extend.TradeGoodSkuExtendMapper;
import com.club.web.store.domain.GoodUpDo;
import com.club.web.store.domain.TradeGoodSkuDo;
import com.club.web.store.domain.repository.GoodSKURepository;
import com.club.web.store.vo.TradeGoodSkuVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GoodSKUReposityImpl
implements GoodSKURepository {
    @Autowired
    TradeGoodSkuExtendMapper tradeGoodSkuMapper;

    @Override
    public void addGoodSKU(TradeGoodSkuDo tradeGoodSkuDo) {
        TradeGoodSku tradeGoodSku = new TradeGoodSku();
        BeanUtils.copyProperties(tradeGoodSkuDo, tradeGoodSku);
        this.tradeGoodSkuMapper.insert(tradeGoodSku);
    }

    @Override
    public void updateTradeGoodSKU(TradeGoodSkuDo tradeGoodSkuDo) {
        TradeGoodSku tradeGoodSku = new TradeGoodSku();
        BeanUtils.copyProperties(tradeGoodSkuDo, tradeGoodSku);
        this.tradeGoodSkuMapper.updateByPrimaryKey(tradeGoodSku);
    }

    @Override
    public void deleteTradeGoodSKU(long id) {
        this.tradeGoodSkuMapper.deleteByPrimaryKey(id);
    }

    @Override
    public void deleteSkuByGoodId(Long goodId) {
        this.tradeGoodSkuMapper.deleteSkuByGoodId(goodId);
    }

    @Override
    public void updateSkuByGoodId(TradeGoodSkuDo tradeGoodSkuDo) {
        this.tradeGoodSkuMapper.updateSkuByGoodId(tradeGoodSkuDo);
    }

    @Override
    public List<TradeGoodSkuVo> selectGoodSkuByGoodId(long goodId) {
        return this.tradeGoodSkuMapper.selectSkuByGoodId(goodId);
    }

    @Override
    public void updateNumById(List<GoodUpDo> list) {
        for (GoodUpDo goodUpDo : list) {
            this.tradeGoodSkuMapper.updateNumById(goodUpDo);
        }
    }

    @Override
    public void updateSaleNumById(List<GoodUpDo> list) {
        for (GoodUpDo goodUpDo : list) {
            this.tradeGoodSkuMapper.updateSaleNumById(goodUpDo);
        }
    }

    @Override
    public TradeGoodSkuVo selectSkuById(Long id) {
        return this.tradeGoodSkuMapper.selectById(id);
    }

    @Override
    public List<TradeGoodSkuDo> ifGoodSkuExgist(long cargoSkuId) {
        return this.tradeGoodSkuMapper.selectGoodSkuNumsByCargoSkuId(cargoSkuId);
    }

    @Override
    public List<TradeGoodSkuVo> selectSkuList(long goodId) {
        return this.tradeGoodSkuMapper.selectSkuList(goodId);
    }

    @Override
    public TradeGoodSkuVo selectPackageById(Long skuId) {
        return this.tradeGoodSkuMapper.selectPackageById(skuId);
    }

    @Override
    public void updatePackage(Long newNum, Integer newSaleNum, String id) {
        this.tradeGoodSkuMapper.updatePackage(newNum, newSaleNum, id);
    }
}

