/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.dao.repository;

import com.club.web.store.dao.base.po.GoodReceiptAddr;
import com.club.web.store.dao.extend.GoodReceiptAddrExtendMapper;
import com.club.web.store.domain.GoodReceiptAddrDo;
import com.club.web.store.domain.repository.ReceiptAddrRepository;
import com.club.web.store.vo.GoodReceiptAddrVo;
import com.club.web.util.IdGenerator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ReceiptAddrRepositoryImpl
implements ReceiptAddrRepository {
    @Autowired
    GoodReceiptAddrExtendMapper receiptDao;

    @Override
    public <T> void save(T t) throws Exception {
        if (t != null) {
            if (t instanceof GoodReceiptAddrDo) {
                GoodReceiptAddrDo receipt = (GoodReceiptAddrDo)t;
                GoodReceiptAddr receiptPo = new GoodReceiptAddr();
                BeanUtils.copyProperties((Object)receiptPo, (Object)receipt);
                this.receiptDao.insert(receiptPo);
            }
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public <T> void update(T t) throws Exception {
        if (t != null) {
            if (t instanceof GoodReceiptAddrDo) {
                GoodReceiptAddrDo receipt = (GoodReceiptAddrDo)t;
                GoodReceiptAddr receiptPo = new GoodReceiptAddr();
                BeanUtils.copyProperties((Object)receiptPo, (Object)receipt);
                this.receiptDao.updateByPrimaryKey(receiptPo);
            }
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public void updateNoExists(long id) {
        this.receiptDao.updateNoExists(id);
    }

    @Override
    public GoodReceiptAddrDo createReceiptAddtObj(Map<String, Object> paramMap) {
        GoodReceiptAddrDo receipt = null;
        int status = 0;
        if (paramMap != null) {
            long userId = paramMap.get("userId") != null ? Long.valueOf(paramMap.get("userId").toString()) : 0L;
            receipt = new GoodReceiptAddrDo();
            if (paramMap.containsKey("status")) {
                status = paramMap.get("status") != null ? Integer.valueOf(paramMap.get("status").toString()) : 0;
            }
            receipt.setStatus(status);
            receipt.setId(IdGenerator.getDefault().nextId());
            receipt.setUserId(userId);
            receipt.setReceiptName(paramMap.get("receiptName") != null ? paramMap.get("receiptName").toString() : "");
            receipt.setMobile(paramMap.get("mobile") != null ? paramMap.get("mobile").toString() : "");
            receipt.setFiexdPhone(paramMap.get("fiexdPhone") != null ? paramMap.get("fiexdPhone").toString() : "");
            receipt.setReceiptEmail(paramMap.get("receiptEmail") != null ? paramMap.get("receiptEmail").toString() : "");
            receipt.setProvinceName(paramMap.get("provinceName") != null ? paramMap.get("provinceName").toString() : "");
            receipt.setProvinceCode(paramMap.get("provinceCode") != null ? paramMap.get("provinceCode").toString() : "");
            receipt.setCityCode(paramMap.get("cityCode") != null ? paramMap.get("cityCode").toString() : "");
            receipt.setCityName(paramMap.get("cityName") != null ? paramMap.get("cityName").toString() : "");
            receipt.setAreaName(paramMap.get("areaName") != null ? paramMap.get("areaName").toString() : "");
            receipt.setAreaCode(paramMap.get("areaCode") != null ? paramMap.get("areaCode").toString() : "");
            receipt.setMailbox(paramMap.get("mailbox") != null ? paramMap.get("mailbox").toString() : "");
            receipt.setDetailAddr(paramMap.get("detailAddr") != null ? paramMap.get("detailAddr").toString() : "");
            receipt.setUpdateTime(new Date());
            receipt.setCreateTime(new Date());
        }
        return receipt;
    }

    @Override
    public List<GoodReceiptAddrVo> queryReceiptAddrList(long userId) {
        List<GoodReceiptAddrVo> list = this.receiptDao.queryReceiptAddrList(userId);
        return list;
    }

    @Override
    public GoodReceiptAddrVo getAddrById(long id) {
        GoodReceiptAddrVo obj = this.receiptDao.getAddrById(id);
        return obj;
    }

    @Override
    public void deleteReceiptAddr(long userId, List<Long> ids) {
        this.receiptDao.deleteReceiptAddr(userId, ids);
    }

    @Override
    public GoodReceiptAddrDo queryByCondition(long userId, long id) {
        GoodReceiptAddrDo receiptDo = this.receiptDao.queryByCondition(userId, id);
        return receiptDo;
    }
}

