/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.dao.repository;

import com.club.web.store.dao.base.po.ShoppingCart;
import com.club.web.store.dao.extend.ShoppingCartExtendMapper;
import com.club.web.store.domain.ShoppingCartDo;
import com.club.web.store.domain.repository.ShoppingCartRepository;
import com.club.web.store.vo.ShoppingCartVo;
import com.club.web.util.IdGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ShoppingCartRepositoryImpl
implements ShoppingCartRepository {
    @Autowired
    ShoppingCartExtendMapper cartDao;

    @Override
    public List<ShoppingCartVo> queryShoppingCartByUserId(long userId, int optionType) {
        List<ShoppingCartVo> list = null;
        list = optionType == 0 ? this.cartDao.queryShoppingCartByUserId(userId, 0L, optionType, 0) : this.cartDao.queryShoppingStoreByUserId(userId, 0L, optionType, 0);
        return list;
    }

    @Override
    public List<ShoppingCartVo> queryShoppingCartByUserId(long userId, long shopId, int optionType) {
        List<ShoppingCartVo> list = null;
        list = optionType == 0 ? this.cartDao.queryShoppingCartByUserId(userId, shopId, optionType, 1) : this.cartDao.queryShoppingStoreByUserId(userId, shopId, optionType, 1);
        return list;
    }

    @Override
    public List<ShoppingCartVo> queryQurShoppingCartByUserId(long userId, long shopId, int optionType) {
        List<ShoppingCartVo> list = null;
        list = optionType == 0 ? this.cartDao.queryQurShoppingCartByUserId(userId, shopId, optionType, 0) : this.cartDao.queryQurShoppingCartByUserId(userId, shopId, optionType, 0);
        return list;
    }

    @Override
    public <T> void save(T t) throws Exception {
        if (t != null) {
            if (!(t instanceof ShoppingCartDo)) {
                throw new Exception("\u4e0d\u5b58\u5728\u64cd\u4f5c\u7684\u5bf9\u8c61\u5b9e\u4f8b");
            }
        } else {
            throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a");
        }
        ShoppingCartDo cart = (ShoppingCartDo)t;
        ShoppingCart po = new ShoppingCart();
        BeanUtils.copyProperties((Object)po, (Object)cart);
        this.cartDao.insert(po);
    }

    @Override
    public <T> void update(T t) throws Exception {
        if (t != null) {
            if (!(t instanceof ShoppingCartDo)) {
                throw new Exception("\u4e0d\u5b58\u5728\u64cd\u4f5c\u7684\u5bf9\u8c61\u5b9e\u4f8b");
            }
        } else {
            throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a");
        }
        ShoppingCartDo cart = (ShoppingCartDo)t;
        ShoppingCart po = new ShoppingCart();
        BeanUtils.copyProperties((Object)po, (Object)cart);
        this.cartDao.updateByPrimaryKey(po);
    }

    @Override
    public ShoppingCartDo createShoppingCartObj(long userId, long goodId, long storeId, int count, double prize, int optionType, int status) {
        ShoppingCartDo cart = this.queryCartObjByCondition(userId, goodId, storeId, optionType, status);
        if (cart == null) {
            cart = new ShoppingCartDo();
            cart.setId(IdGenerator.getDefault().nextId());
            cart.setUserId(userId);
            cart.setGoodsId(goodId);
            cart.setShopId(storeId);
            cart.setGoodsCount(count);
            cart.setGoodsPrize(new BigDecimal(prize));
            cart.setUpdateDate(new Date());
            cart.setCreateDate(new Date());
            cart.setFlag(1);
            cart.setOpertionType(optionType);
        } else {
            cart.setFlag(0);
        }
        return cart;
    }

    @Override
    public ShoppingCartDo queryCartObjByCondition(long userId, long goodId, long storeId, int optionType, int status) {
        ShoppingCartDo cart = this.cartDao.queryCartObjByCondition(userId, goodId, storeId, optionType, status);
        return cart;
    }

    @Override
    public void deleteShoppingCartGoods(long userId, List<Long> goodsIds, long shopId, int optionType, int status) {
        this.cartDao.deleteShoppingCartGoods(userId, goodsIds, shopId, optionType, status);
    }

    @Override
    public int getCartCount(long userId, long shopId, int optionType) {
        int count = this.cartDao.getCartCount(userId, shopId, optionType);
        return count;
    }
}

