/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.dao.repository;

import com.club.core.common.Page;
import com.club.framework.util.BeanUtils;
import com.club.web.store.dao.base.po.StoreLevel;
import com.club.web.store.dao.extend.StoreLevelExtendMapper;
import com.club.web.store.domain.StoreLevel2Do;
import com.club.web.store.domain.StoreLevelDo;
import com.club.web.store.domain.repository.StoreLevelRepository;
import com.club.web.store.vo.StoreLevelVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class StoreLevelRepositoryImpl
implements StoreLevelRepository {
    @Autowired
    private StoreLevelExtendMapper storeLevelExtendMapper;

    @Override
    public StoreLevelDo create(StoreLevelVo storeLevelVo) {
        if (storeLevelVo == null) {
            return null;
        }
        StoreLevel2Do storeLevelDo = new StoreLevel2Do();
        BeanUtils.copyProperties(storeLevelVo, storeLevelDo);
        storeLevelDo.setLevelId(Long.parseLong(storeLevelVo.getLevelId()));
        return storeLevelDo;
    }

    private StoreLevel getPoByDomian(StoreLevelDo storeLevelDo) {
        if (storeLevelDo == null) {
            return null;
        }
        StoreLevel storeLevel = new StoreLevel();
        BeanUtils.copyProperties(storeLevelDo, storeLevel);
        return storeLevel;
    }

    private StoreLevelDo getDomainByPo(StoreLevel storeLevel) {
        if (storeLevel == null) {
            return null;
        }
        StoreLevel2Do storeLevelDo = new StoreLevel2Do();
        BeanUtils.copyProperties(storeLevel, storeLevelDo);
        return storeLevelDo;
    }

    @Override
    public void insert(StoreLevelDo storeLevelDo) {
        this.storeLevelExtendMapper.insert(this.getPoByDomian(storeLevelDo));
    }

    @Override
    public void update(StoreLevelDo storeLevelDo) {
        this.storeLevelExtendMapper.updateByPrimaryKeySelective(this.getPoByDomian(storeLevelDo));
    }

    @Override
    public StoreLevelDo getStoreLevelDoByLevelId(long levelId) {
        return this.getDomainByPo(this.storeLevelExtendMapper.selectByPrimaryKey(levelId));
    }

    @Override
    public List<StoreLevelVo> queryStoreLevelByName(String name) {
        return this.storeLevelExtendMapper.queryStoreLevelByName(name);
    }

    @Override
    public List<Map<String, Object>> queryStoreLevelPage(Page<Map<String, Object>> page, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("start", page.getStart());
        map.put("limit", page.getLimit());
        return this.storeLevelExtendMapper.querystoreLevelPage(map);
    }

    @Override
    public Long queryStoreLevelCountPage(Page<Map<String, Object>> page, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return this.storeLevelExtendMapper.querystoreLevelCountPage(map);
    }

    @Override
    public void deleteByPrimaryKey(long levelId) {
        this.storeLevelExtendMapper.deleteByPrimaryKey(levelId);
    }

    @Override
    public StoreLevelDo getStoreLevelDoById(long levelId) {
        return this.getDomainByPo(this.storeLevelExtendMapper.selectByPrimaryKey(levelId));
    }

    @Override
    public List<StoreLevelVo> findAllStoreLevel(HttpServletRequest request) {
        return this.storeLevelExtendMapper.findAllStoreLevel();
    }
}

