/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.dao.repository;

import com.club.framework.util.StringUtils;
import com.club.web.store.dao.base.po.ShopThemeManager;
import com.club.web.store.dao.extend.ShopThemeManagerExtendMapper;
import com.club.web.store.domain.ShopThemeManagerDo;
import com.club.web.store.domain.repository.ThemeManagerRepository;
import com.club.web.store.vo.ShopThemeExtendVo;
import com.club.web.store.vo.ShopThemeManagerVo;
import com.club.web.util.IdGenerator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ThemeManagerRepositoryImpl
implements ThemeManagerRepository {
    @Autowired
    ShopThemeManagerExtendMapper themeDao;

    @Override
    public List<ShopThemeManagerVo> queryThemeList(int status, String matchParam, int startIndex, int pageSize) {
        List<ShopThemeManagerVo> list = this.themeDao.queryThemeList(status, matchParam, startIndex, pageSize);
        return list;
    }

    @Override
    public int queryThemeListTotal(int status, String matchParam) {
        int total = this.themeDao.queryThemeListTotal(status, matchParam);
        return total;
    }

    @Override
    public ShopThemeManagerDo createThemeObj(Map<String, Object> param) {
        ShopThemeManagerDo theme = null;
        long id = -1L;
        if (param != null) {
            String classify;
            if (param.containsKey("theme_id")) {
                id = param.get("theme_id") != null && StringUtils.isNotEmpty(param.get("theme_id").toString()) ? Long.valueOf(param.get("theme_id").toString()) : -1L;
            }
            theme = this.themeDao.queryThemeObjById(id);
            String picUrl = param.get("picUrl") != null ? param.get("picUrl").toString() : "";
            int lastIndex = picUrl.indexOf("-img");
            if (lastIndex > 0) {
                picUrl = picUrl.substring(0, lastIndex);
            }
            String string = classify = param.get("theme_multiselect") != null ? param.get("theme_multiselect").toString() : "";
            if (StringUtils.isNotEmpty(classify) && classify.contains("[")) {
                classify = classify.substring(1, classify.length() - 1);
                classify = classify.replaceAll(" ", "");
            }
            if (theme != null) {
                theme.setFlag(1);
                if (StringUtils.isNotEmpty(picUrl)) {
                    theme.setExtendId(theme.getTitlePicUrl());
                    theme.setTitlePicUrl(picUrl);
                }
                theme.setTitle(param.get("title") != null ? param.get("title").toString() : theme.getTitle());
                theme.setClassifyId(StringUtils.isNotEmpty(classify) ? classify : theme.getClassifyId());
                theme.setCreateTime(new Date());
                theme.setSort(param.get("sort") != null ? Integer.valueOf(param.get("sort").toString()) : theme.getSort());
            } else {
                theme = new ShopThemeManagerDo();
                theme.setId(IdGenerator.getDefault().nextId());
                theme.setFlag(0);
                theme.setSort(param.get("sort") != null ? Integer.valueOf(param.get("sort").toString()) : 0);
                theme.setTitle(param.get("title") != null ? param.get("title").toString() : "");
                theme.setStatus(param.get("status") != null ? Integer.valueOf(param.get("status").toString()) : 1);
                theme.setTitlePicUrl(picUrl);
                theme.setCreateTime(new Date());
                theme.setClassifyId(StringUtils.isNotEmpty(classify) ? classify : "");
            }
        }
        return theme;
    }

    @Override
    public <T> void save(T t) throws Exception {
        if (t != null) {
            if (t instanceof ShopThemeManagerDo) {
                ShopThemeManagerDo theme = (ShopThemeManagerDo)t;
                ShopThemeManager themePo = new ShopThemeManager();
                BeanUtils.copyProperties((Object)themePo, (Object)theme);
                this.themeDao.insert(themePo);
            }
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public <T> void update(T t) throws Exception {
        if (t != null) {
            if (t instanceof ShopThemeManagerDo) {
                ShopThemeManagerDo theme = (ShopThemeManagerDo)t;
                ShopThemeManager themePo = new ShopThemeManager();
                BeanUtils.copyProperties((Object)themePo, (Object)theme);
                this.themeDao.updateByPrimaryKey(themePo);
            }
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public void delTheme(List<Long> ids) {
        this.themeDao.delTheme(ids);
    }

    @Override
    public ShopThemeManagerDo queryThemeById(long id) {
        ShopThemeManagerDo theme = this.themeDao.queryThemeObjById(id);
        return theme;
    }

    @Override
    public List<ShopThemeManagerVo> queryStartTheme(int status) {
        List<ShopThemeManagerVo> list = this.themeDao.queryStartTheme(status);
        return list;
    }

    @Override
    public List<ShopThemeExtendVo> queryPrevTheme() {
        List<ShopThemeExtendVo> list = this.themeDao.queryPrevTheme();
        return list;
    }
}

