/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.domain;

import com.club.framework.util.BankCardUtil;
import com.club.framework.util.IdcardUtils;
import com.club.web.store.dao.extend.BankCardExtendMapper;
import com.club.web.store.domain.repository.BankCardRepository;
import com.club.web.util.CommonUtil;
import com.club.web.util.IdGenerator;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.util.Assert;

@Configurable
public class BankCardDo {
    @Autowired
    BankCardExtendMapper bankCardExtendMapper;
    @Autowired
    BankCardRepository bankCardRepository;
    private Long bankCardId;
    private Integer state;
    private String name;
    private String idCard;
    private String bankName;
    private String bankCard;
    private String mobile;
    private Date updateTime;
    private Date createTime;
    private Integer delet;
    private Long connectId;
    private Integer connectType;
    private String bankAddress;

    public Long getBankCardId() {
        return this.bankCardId;
    }

    public void setBankCardId(Long bankCardId) {
        this.bankCardId = bankCardId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getIdCard() {
        return this.idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard == null ? null : idCard.trim();
        Assert.isTrue((boolean)IdcardUtils.validateCard(this.idCard), (String)"\u8eab\u4efd\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e");
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName == null ? null : bankName.trim();
    }

    public String getBankCard() {
        return this.bankCard;
    }

    public void setBankCard(String bankCard) {
        Assert.isTrue((boolean)BankCardUtil.checkBankCard(bankCard), (String)"\u94f6\u884c\u5361\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u586b\u771f\u5b9e\u7684\u94f6\u884c\u5361\u53f7");
        this.bankCard = bankCard == null ? null : bankCard.trim();
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        Assert.isTrue((boolean)CommonUtil.isMobile(mobile), (String)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        this.mobile = mobile;
    }

    public int insert() {
        this.delet = 0;
        this.state = 0;
        Assert.isTrue((this.bankCardExtendMapper.selectByBanCard(this.bankCard) == 0 ? 1 : 0) != 0, (String)"\u94f6\u884c\u5361\u5df2\u5b58\u5728");
        this.bankCardId = IdGenerator.getDefault().nextId();
        this.setCreateTime(new Date());
        int result = this.bankCardRepository.saveBankCard(this);
        return result;
    }

    public int update() {
        this.setUpdateTime(new Date());
        int result = this.bankCardRepository.updateBankCard(this);
        return result;
    }

    public int updateBankCardState() {
        int result = this.bankCardRepository.updateBankCardState(this);
        return result;
    }

    public int deletBySubranchID() {
        int result = this.bankCardRepository.deletBankCard(this);
        return result;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getDelet() {
        return this.delet;
    }

    public void setDelet(Integer delet) {
        this.delet = delet;
    }

    public Long getConnectId() {
        return this.connectId;
    }

    public void setConnectId(Long connectId) {
        this.connectId = connectId;
    }

    public Integer getConnectType() {
        return this.connectType;
    }

    public void setConnectType(Integer connectType) {
        this.connectType = connectType;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getBankAddress() {
        return this.bankAddress;
    }

    public void setBankAddress(String bankAddress) {
        this.bankAddress = bankAddress;
    }
}

