/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.core.common.Page;
import com.club.framework.util.BeanUtils;
import com.club.framework.util.StringUtils;
import com.club.web.store.dao.extend.BankCardExtendMapper;
import com.club.web.store.domain.BankCardDo;
import com.club.web.store.domain.emu.BankCardEMU;
import com.club.web.store.service.BankCardService;
import com.club.web.store.vo.BankCardExtendVo;
import com.club.web.store.vo.BankCardVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bankCardService")
public class BankCardServiceImpl
implements BankCardService {
    @Autowired
    BankCardExtendMapper bankCardExtendMapper;
    Map<String, Object> result = null;

    @Override
    public int saveOrUpdateBankCard(BankCardVo bankCardVo) {
        int result;
        BankCardDo bankCardDo = new BankCardDo();
        BeanUtils.copyProperties(bankCardVo, bankCardDo);
        if (bankCardDo.getBankCardId() != null) {
            result = bankCardDo.update();
        } else {
            result = bankCardDo.insert();
            bankCardVo.setBankCardId(bankCardDo.getBankCardId());
        }
        return result;
    }

    @Override
    public Page getBankCardList(Page page) {
        String name = "";
        String connectId = "";
        if (page.getConditons() != null) {
            if (page.getConditons().get("name") != null) {
                name = page.getConditons().get("name").toString();
            }
            if (page.getConditons().get("connectId") != null) {
                connectId = page.getConditons().get("connectId").toString();
            }
        }
        int total = this.bankCardExtendMapper.selectByPageCount(name, connectId);
        List<Object> bankCardVoList = new ArrayList();
        bankCardVoList = total > page.getLimit() ? this.bankCardExtendMapper.selectByPage(name, connectId, page.getStart(), page.getLimit()) : this.bankCardExtendMapper.selectByPage(name, connectId, page.getStart(), total);
        page.setTotalRecords(total);
        page.setResultList(bankCardVoList);
        return page;
    }

    @Override
    public int updateBankCardState(String[] bankCardIds, String action) {
        BankCardDo bankCardDo = new BankCardDo();
        try {
            if (action != null) {
                for (String bankCardId : bankCardIds) {
                    if (bankCardId == null || bankCardId == "") continue;
                    bankCardDo.setState(Integer.parseInt(action));
                    bankCardDo.setBankCardId(Long.parseLong(bankCardId));
                    bankCardDo.updateBankCardState();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public BankCardEMU[] getBankCardTypeList() {
        return BankCardEMU.values();
    }

    @Override
    public List<BankCardExtendVo> getBankCardListSer(String shopId, int pageSize, int pageNum) {
        List<BankCardExtendVo> list = null;
        long shop = 0L;
        if (pageSize < 1) {
            pageSize = 6;
        }
        if (pageNum < 0) {
            pageNum = 1;
        }
        if (StringUtils.isNotEmpty(shopId)) {
            shop = Long.valueOf(shopId);
            list = this.bankCardExtendMapper.getBankCardList(shop, (pageNum - 1) * pageSize, pageSize);
        }
        return list;
    }

    @Override
    public BankCardExtendVo getBankCardSer(String id) {
        BankCardExtendVo obj = null;
        long bankId = 0L;
        if (StringUtils.isNotEmpty(id)) {
            bankId = Long.valueOf(id);
            obj = this.bankCardExtendMapper.getBankCardObj(bankId);
        }
        return obj;
    }

    @Override
    public Long getBankCardCountByShopId(Long id) {
        return this.bankCardExtendMapper.getBankCardCountByShopId(id);
    }
}

