/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.core.common.Page;
import com.club.framework.util.StringUtils;
import com.club.web.image.service.ImageService;
import com.club.web.image.service.vo.ImageVo;
import com.club.web.store.domain.CarouselImgDo;
import com.club.web.store.domain.repository.CarouselImgRepository;
import com.club.web.store.service.CarouselImgService;
import com.club.web.store.vo.CarouselImgPrevVo;
import com.club.web.store.vo.CarouselImgVo;
import com.club.web.util.CommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CarouselImgServiceImpl
implements CarouselImgService {
    private Logger logger = LoggerFactory.getLogger(CarouselImgServiceImpl.class);
    @Autowired
    CarouselImgRepository repository;
    @Autowired
    ImageService image;
    private Map<String, Object> result;

    @Override
    public Page<Map<String, Object>> queryCarouselImgSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        List<CarouselImgVo> listMap = null;
        ArrayList mapList = null;
        int total = 0;
        int status = -1;
        String matchParam = StringUtils.EMPTY;
        try {
            if (page != null) {
                startIndex = page.getStart();
                pageSize = page.getLimit();
                Map<String, Object> con = page.getConditons();
                if (con != null) {
                    if (con.containsKey("status")) {
                        int n = status = con.get("status") != null ? Integer.valueOf(con.get("status").toString()) : 0;
                    }
                    if (con.containsKey("matchParam")) {
                        matchParam = con.get("matchParam") != null ? con.get("matchParam").toString() : StringUtils.EMPTY;
                    }
                }
                total = this.repository.queryCarouselImgListTotal(status, matchParam);
                page.setTotalRecords(total);
                if (total > 0 && (listMap = this.repository.queryCarouselImgList(status, matchParam, startIndex, pageSize)) != null && listMap.stream().count() > 0L) {
                    mapList = new ArrayList();
                    HashMap<String, Object> mp = null;
                    for (CarouselImgVo vo : listMap) {
                        mp = new HashMap<String, Object>();
                        mp.put("id", vo.getId());
                        mp.put("status", vo.getStatus());
                        mp.put("lineStatus", vo.getLineStatus());
                        mp.put("category", vo.getCategory().toString());
                        mp.put("categoryName", vo.getCategoryName());
                        mp.put("sort", vo.getSort());
                        mp.put("remk", vo.getRemk());
                        mp.put("createTime", vo.getCreateTime());
                        mp.put("richText", vo.getRichText());
                        mp.put("picUrl", vo.getPicUrl());
                        mapList.add(mp);
                    }
                    page.setResultList(mapList);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u53c2\u6570\u67e5\u8be2\u8f6e\u64ad\u56fe\u4fe1\u606f\u5f02\u5e38<queryCarouselImgSer>:", (Throwable)e);
        }
        return page;
    }

    @Override
    public Page<Map<String, Object>> queryBannerImgSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        List<Map<String, Object>> listMap = null;
        int total = 0;
        int status = -1;
        String matchParam = StringUtils.EMPTY;
        try {
            if (page != null) {
                startIndex = page.getStart();
                pageSize = page.getLimit();
                Map<String, Object> con = page.getConditons();
                if (con != null) {
                    if (con.containsKey("status")) {
                        int n = status = con.get("status") != null ? Integer.valueOf(con.get("status").toString()) : 0;
                    }
                    if (con.containsKey("matchParam")) {
                        matchParam = con.get("matchParam") != null ? con.get("matchParam").toString() : StringUtils.EMPTY;
                    }
                }
                total = this.repository.queryBannerImgListTotal(status, matchParam);
                page.setTotalRecords(total);
                if (total > 0 && (listMap = this.repository.queryBannerImgList(status, matchParam, startIndex, pageSize)) != null && listMap.stream().count() > 0L) {
                    page.setResultList(listMap);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u53c2\u6570\u67e5\u8be2\u8f6e\u64ad\u56fe\u4fe1\u606f\u5f02\u5e38<queryCarouselImgSer>:", (Throwable)e);
        }
        return page;
    }

    @Override
    public Map<String, Object> saveCarouselImgSer(Map<String, Object> paramMap) throws Exception {
        this.result = new HashMap<String, Object>();
        CarouselImgDo carousel = null;
        ImageVo imgObj = null;
        if (paramMap != null) {
            carousel = this.repository.createCarouseObj(paramMap);
            if (carousel != null) {
                if (carousel.getFlag() == 0) {
                    imgObj = new ImageVo();
                    imgObj.setId(StringUtils.isNotEmpty(carousel.getExtendId()) ? Long.valueOf(carousel.getExtendId()) : 0L);
                    imgObj.setPicUrl(carousel.getPicUrl());
                    this.image.updateImage(imgObj);
                    carousel.setPicUrl(String.valueOf(imgObj.getId()));
                    carousel.update();
                } else {
                    imgObj = this.image.saveImage(carousel.getPicUrl());
                    carousel.setPicUrl(String.valueOf(imgObj.getId()));
                    carousel.save();
                }
                this.result.put("code", "000000");
                this.result.put("msg", "\u4fdd\u5b58\u6210\u529f");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> delCarouselImgSer(Map<String, Object> paramMap) {
        this.result = new HashMap<String, Object>();
        ArrayList<Long> ids = null;
        String id = StringUtils.EMPTY;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = id = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (StringUtils.isNotEmpty(id) && (arr = id.split(",")) != null && arr.length > 0) {
                ids = new ArrayList<Long>();
                for (String str : arr) {
                    ids.add(Long.valueOf(str));
                }
            }
            if (ids != null && ids.stream().count() > 0L) {
                this.repository.delCarouselImg((List<Long>)ids);
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000003");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> updateCarouselImgSer(Map<String, Object> paramMap) throws Exception {
        this.result = new HashMap<String, Object>();
        long id = 0L;
        int count = 0;
        CarouselImgDo carousel = null;
        String updateCount = StringUtils.EMPTY;
        if (paramMap != null) {
            if (paramMap.containsKey("id")) {
                long l = id = paramMap.get("id") != null ? Long.valueOf(paramMap.get("id").toString()) : 0L;
            }
            if (paramMap.containsKey("updateCount")) {
                String string = updateCount = paramMap.get("updateCount") != null ? paramMap.get("updateCount").toString() : StringUtils.EMPTY;
            }
            if (CommonUtil.isDigital(updateCount)) {
                count = Integer.valueOf(updateCount);
                carousel = this.repository.queryCarouselById(id);
                if (carousel != null) {
                    carousel.setUpdateTime(new Date());
                    carousel.setSort(count);
                    carousel.update();
                    this.result.put("code", "000000");
                    this.result.put("msg", "\u4fee\u6539\u6210\u529f\uff01");
                } else {
                    this.result.put("code", "000003");
                    this.result.put("msg", "\u4fee\u6539\u5bf9\u8c61\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                }
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u6392\u5e8f\u6570\u5b57\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> updateCarouselImgStatusSer(Map<String, Object> paramMap) throws Exception {
        this.result = new HashMap<String, Object>();
        int status = -1;
        CarouselImgDo carousel = null;
        String ids = StringUtils.EMPTY;
        ArrayList<Long> listId = null;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = ids = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("status")) {
                int n = status = paramMap.get("status") != null ? Integer.valueOf(paramMap.get("status").toString()) : -1;
            }
            if (StringUtils.isNotEmpty(ids) && (arr = ids.split(",")) != null && arr.length > 0) {
                listId = new ArrayList<Long>();
                for (String str : arr) {
                    listId.add(Long.valueOf(str));
                }
            }
            if (listId != null && listId.stream().count() > 0L) {
                Iterator iterator = listId.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    carousel = this.repository.queryCarouselById(id);
                    carousel.setStatus(status);
                    carousel.setUpdateTime(new Date());
                    carousel.update();
                }
                this.result.put("code", "000000");
                this.result.put("msg", "\u4fee\u6539\u6210\u529f\uff01");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public List<CarouselImgPrevVo> getCarouselByCatory(String category) {
        List<CarouselImgPrevVo> list;
        long categoryId = 0L;
        if (StringUtils.isNotEmpty(category) && CommonUtil.isDigital(category)) {
            categoryId = Long.valueOf(category);
        }
        if ((list = this.repository.getCarouselByCatory(categoryId)) != null && list.stream().count() > 0L) {
            for (CarouselImgPrevVo ig : list) {
                if (ig.getLineStatus() != 0) continue;
                ig.setLineUrl("");
            }
        }
        return list;
    }

    @Override
    public Map<String, Object> getRichTextById(String id) {
        long caourseId = 0L;
        if (StringUtils.isNotEmpty(id) && CommonUtil.isDigital(id)) {
            caourseId = Long.valueOf(id);
        }
        Map<String, Object> result = this.repository.getRichTextById(caourseId);
        return result;
    }
}

