/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.framework.util.BeanUtils;
import com.club.web.image.service.ImageService;
import com.club.web.image.service.vo.ImageVo;
import com.club.web.store.dao.repository.GoodSKUReposityImpl;
import com.club.web.store.domain.GoodEvaluationDo;
import com.club.web.store.domain.repository.GoodEvaluationRepository;
import com.club.web.store.service.GoodEvaluationService;
import com.club.web.store.vo.EvaluationImageVo;
import com.club.web.store.vo.GoodEvaluationVo;
import com.club.web.util.CommonUtil;
import com.club.web.util.IdGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="goodEvaluationServiceImlp")
public class GoodEvaluationServiceImlp
implements GoodEvaluationService {
    @Autowired
    private GoodEvaluationRepository goodEvaluationRepository;
    @Autowired
    private GoodSKUReposityImpl goodSkuReposityImpl;
    @Autowired
    private ImageService iamgeService;

    @Override
    public void saveEvaluation(GoodEvaluationVo goodEvaluationVo, String[] urlArray, long userId) {
        long groupId = -1L;
        if (urlArray != null && !urlArray.equals("") && urlArray.length != 0) {
            groupId = IdGenerator.getDefault().nextId();
            this.iamgeService.saveOrUpdateByGroupId(groupId, userId, urlArray);
        }
        GoodEvaluationDo evaluationDo = new GoodEvaluationDo();
        BeanUtils.copyProperties(goodEvaluationVo, evaluationDo);
        evaluationDo.setId(IdGenerator.getDefault().nextId());
        evaluationDo.setGoodSkuid(Long.parseLong(goodEvaluationVo.getGoodSkuid()));
        evaluationDo.setEvaluateTime(new Date());
        if (urlArray != null && !urlArray.equals("") && urlArray.length != 0 && groupId != -1L) {
            evaluationDo.setImage(Long.toString(groupId));
        }
        this.goodEvaluationRepository.saveEvaluation(evaluationDo);
    }

    @Override
    public List<GoodEvaluationVo> selectEvaluationByGoodId(long goodId) {
        List<GoodEvaluationVo> evaluationVoList = this.goodEvaluationRepository.selectEvaluationByGoodId(goodId);
        Long goodsId = 0L;
        for (GoodEvaluationVo goodEvaluationVo : evaluationVoList) {
            String groupId;
            goodsId = Long.parseLong(goodEvaluationVo.getGoodSkuid());
            if (goodsId > 100000000000L) {
                goodEvaluationVo.setSkuName(this.goodSkuReposityImpl.selectSkuById(goodsId).getCargoSkuName());
            } else {
                goodEvaluationVo.setSkuName(this.goodSkuReposityImpl.selectPackageById(goodsId).getCargoSkuName());
            }
            if ((groupId = goodEvaluationVo.getImage()) == null || groupId == "") continue;
            List<ImageVo> imageVoList = this.iamgeService.selectImagesByGroupId(Long.parseLong(goodEvaluationVo.getImage()));
            ArrayList<EvaluationImageVo> eimageVoList = new ArrayList<EvaluationImageVo>();
            for (ImageVo imageVo : imageVoList) {
                EvaluationImageVo evaluationImageVo = new EvaluationImageVo();
                evaluationImageVo.setId(imageVo.getId());
                evaluationImageVo.setUrl(imageVo.getPicUrl());
                eimageVoList.add(evaluationImageVo);
            }
            goodEvaluationVo.setImageVoList(eimageVoList);
        }
        return this.goodEvaluationRepository.selectEvaluationByGoodId(goodId);
    }

    @Override
    public Map<String, Object> deleteEvaluationSer(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (CommonUtil.isDigital(id)) {
            this.goodEvaluationRepository.deleteById(Long.valueOf(id));
            result.put("code", "0");
            result.put("msg", "\u5220\u9664\u6210\u529f\uff01");
        } else {
            result.put("code", "-2");
            result.put("msg", "\u53c2\u6570\u6709\u8bef\uff01");
        }
        return result;
    }
}

