/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.framework.util.StringUtils;
import com.club.web.store.domain.GoodReceiptAddrDo;
import com.club.web.store.domain.repository.ReceiptAddrRepository;
import com.club.web.store.service.GoodReceiptAddrService;
import com.club.web.store.vo.GoodReceiptAddrVo;
import com.club.web.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GoodReceiptAddrServiceImpl
implements GoodReceiptAddrService {
    private Logger logger = LoggerFactory.getLogger(GoodReceiptAddrServiceImpl.class);
    private Map<String, Object> result;
    @Autowired
    ReceiptAddrRepository repository;

    @Override
    public Map<String, Object> saveReceiptAddrSer(Map<String, Object> paramMap) throws Exception {
        this.result = this.checkReceiptAddrParam(paramMap);
        GoodReceiptAddrDo receipt = null;
        if (this.result != null && "000000".equals(this.result.get("code").toString())) {
            receipt = this.repository.createReceiptAddtObj(paramMap);
            if (receipt != null) {
                receipt.save();
                this.result.put("code", "000000");
                this.result.put("msg", "\u4fdd\u5b58\u6210\u529f");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        return this.result;
    }

    private Map<String, Object> checkReceiptAddrParam(Map<String, Object> paramMap) {
        this.result = new HashMap<String, Object>();
        try {
            String mobile = StringUtils.EMPTY;
            String fiedxPhone = StringUtils.EMPTY;
            String receiptEmail = StringUtils.EMPTY;
            String detailAddr = StringUtils.EMPTY;
            String mailbox = StringUtils.EMPTY;
            if (paramMap != null) {
                if (paramMap.containsKey("userId")) {
                    Long.valueOf(paramMap.get("userId").toString());
                }
                if (paramMap.containsKey("mobile")) {
                    String string = mobile = paramMap.get("mobile") != null ? paramMap.get("mobile").toString() : "";
                }
                if (paramMap.containsKey("fiexdPhone")) {
                    String string = fiedxPhone = paramMap.get("fiexdPhone") != null ? paramMap.get("fiexdPhone").toString() : "";
                }
                if (paramMap.containsKey("receiptEmail")) {
                    String string = receiptEmail = paramMap.get("receiptEmail") != null ? paramMap.get("receiptEmail").toString() : "";
                }
                if (paramMap.containsKey("detailAddr")) {
                    String string = detailAddr = paramMap.get("detailAddr") != null ? paramMap.get("detailAddr").toString() : "";
                }
                if (paramMap.containsKey("mailbox")) {
                    String string = mailbox = paramMap.get("mailbox") != null ? paramMap.get("mailbox").toString() : "";
                }
                if (!CommonUtil.isMobile(mobile)) {
                    this.result.put("code", "000001");
                    this.result.put("msg", "\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef");
                    return this.result;
                }
                if (StringUtils.isNotEmpty(fiedxPhone) && !CommonUtil.isPhone(fiedxPhone)) {
                    this.result.put("code", "000001");
                    this.result.put("msg", "\u56fa\u8bdd\u53f7\u7801\u683c\u5f0f\u6709\u8bef");
                    return this.result;
                }
                if (StringUtils.isNotEmpty(receiptEmail) && !CommonUtil.checkEmail(receiptEmail)) {
                    this.result.put("code", "000001");
                    this.result.put("msg", "\u90ae\u7bb1\u683c\u5f0f\u6709\u8bef");
                    return this.result;
                }
                if (StringUtils.isEmpty(detailAddr)) {
                    this.result.put("code", "000001");
                    this.result.put("msg", "\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                    return this.result;
                }
                if (StringUtils.isNotEmpty(mailbox) && !CommonUtil.isDigital(mailbox)) {
                    this.result.put("code", "000001");
                    this.result.put("msg", "\u90ae\u7f16\u683c\u5f0f\u9519\u8bef");
                    return this.result;
                }
                this.result.put("code", "000000");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u6536\u8d27\u5730\u5740\u4fe1\u606f\u53c2\u6570\u6821\u9a8c\u5f02\u5e38<checkReceiptAddrParam>:", (Throwable)e);
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u6709\u8bef");
        }
        return this.result;
    }

    @Override
    public List<GoodReceiptAddrVo> queryReceiptAddrSer(String userId) {
        List<GoodReceiptAddrVo> list = null;
        long user = 0L;
        if (StringUtils.isNotEmpty(userId)) {
            user = Long.valueOf(userId);
            list = this.repository.queryReceiptAddrList(user);
        }
        return list;
    }

    @Override
    public GoodReceiptAddrVo getAddrByIdSer(String id) {
        GoodReceiptAddrVo obj = null;
        long addId = 0L;
        if (StringUtils.isNotEmpty(id)) {
            addId = Long.valueOf(id);
            obj = this.repository.getAddrById(addId);
        }
        return obj;
    }

    @Override
    public Map<String, Object> deleteReceiptAddrSer(String userId, String ids) {
        this.result = new HashMap<String, Object>();
        long user = 0L;
        String[] idsArr = null;
        ArrayList<Long> list = null;
        if (StringUtils.isNotEmpty(userId) && StringUtils.isNotEmpty(ids)) {
            user = Long.valueOf(userId);
            idsArr = ids.split(",");
            if (idsArr != null && idsArr.length > 0) {
                list = new ArrayList<Long>();
                for (String str : idsArr) {
                    list.add(Long.valueOf(str));
                }
            }
        }
        if (list != null && list.stream().count() > 0L) {
            this.repository.deleteReceiptAddr(user, (List<Long>)list);
            this.result.put("code", "000000");
            this.result.put("msg", "\u5220\u9664\u6210\u529f");
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> updateReceiptAddrStatusSer(String userId, String id) throws Exception {
        this.result = new HashMap<String, Object>();
        long user = 0L;
        long receiptId = 0L;
        GoodReceiptAddrDo receiptDo = null;
        if (StringUtils.isNotEmpty(userId) && StringUtils.isNotEmpty(id)) {
            user = Long.valueOf(userId);
            receiptDo = this.repository.queryByCondition(user, receiptId = Long.valueOf(id).longValue());
            if (receiptDo != null) {
                receiptDo.setStatus(1);
                receiptDo.update();
                this.result.put("code", "000000");
                this.result.put("msg", "\u4fee\u6539\u6210\u529f");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u6709\u8bef");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> updateReceiptAddrSer(Map<String, Object> paramMap) throws Exception {
        this.result = new HashMap<String, Object>();
        long userId = 0L;
        long id = 0L;
        GoodReceiptAddrDo receiptDo = null;
        if (paramMap != null) {
            userId = Long.valueOf(paramMap.get("userId") != null ? paramMap.get("userId").toString() : "-1");
            receiptDo = this.repository.queryByCondition(userId, id = Long.valueOf(paramMap.get("id") != null ? paramMap.get("id").toString() : "-1").longValue());
            if (receiptDo != null) {
                if (paramMap.containsKey("receiptName")) {
                    receiptDo.setReceiptName(paramMap.get("receiptName") != null ? paramMap.get("receiptName").toString() : receiptDo.getReceiptName());
                }
                if (paramMap.containsKey("mobile")) {
                    String mobile = paramMap.get("mobile").toString();
                    if (!CommonUtil.isMobile(mobile)) {
                        this.result.put("code", "000001");
                        this.result.put("msg", "\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef");
                        return this.result;
                    }
                    receiptDo.setMobile(mobile);
                }
                if (paramMap.containsKey("fiexdPhone")) {
                    String fiexdPhone = paramMap.get("fiexdPhone").toString();
                    if (StringUtils.isNotEmpty(fiexdPhone) && !CommonUtil.isPhone(fiexdPhone)) {
                        this.result.put("code", "000001");
                        this.result.put("msg", "\u56fa\u8bdd\u53f7\u7801\u683c\u5f0f\u6709\u8bef");
                        return this.result;
                    }
                    receiptDo.setFiexdPhone(fiexdPhone);
                }
                if (paramMap.containsKey("receiptEmail")) {
                    String receiptEmail = paramMap.get("receiptEmail").toString();
                    if (StringUtils.isNotEmpty(receiptEmail) && !CommonUtil.checkEmail(receiptEmail)) {
                        this.result.put("code", "000001");
                        this.result.put("msg", "\u90ae\u7bb1\u5730\u5740\u683c\u5f0f\u6709\u8bef");
                        return this.result;
                    }
                    receiptDo.setReceiptEmail(receiptEmail);
                }
                if (paramMap.containsKey("detailAddr")) {
                    receiptDo.setDetailAddr(paramMap.get("detailAddr") != null ? paramMap.get("detailAddr").toString() : receiptDo.getDetailAddr());
                }
                if (paramMap.containsKey("mailbox")) {
                    receiptDo.setMailbox(paramMap.get("mailbox") != null ? paramMap.get("mailbox").toString() : receiptDo.getMailbox());
                }
                if (paramMap.containsKey("provinceCode")) {
                    receiptDo.setProvinceCode(paramMap.get("provinceCode") != null ? paramMap.get("provinceCode").toString() : receiptDo.getProvinceCode());
                }
                if (paramMap.containsKey("provinceName")) {
                    receiptDo.setProvinceName(paramMap.get("provinceName") != null ? paramMap.get("provinceName").toString() : receiptDo.getProvinceName());
                }
                if (paramMap.containsKey("cityCode")) {
                    receiptDo.setCityCode(paramMap.get("cityCode") != null ? paramMap.get("cityCode").toString() : receiptDo.getCityCode());
                }
                if (paramMap.containsKey("areaCode")) {
                    receiptDo.setAreaCode(paramMap.get("areaCode") != null ? paramMap.get("areaCode").toString() : receiptDo.getAreaCode());
                }
                if (paramMap.containsKey("areaName")) {
                    receiptDo.setAreaName(paramMap.get("areaName") != null ? paramMap.get("areaName").toString() : receiptDo.getAreaName());
                }
                if (paramMap.containsKey("cityName")) {
                    receiptDo.setCityName(paramMap.get("cityName") != null ? paramMap.get("cityName").toString() : receiptDo.getCityName());
                }
                if (paramMap.containsKey("status")) {
                    Integer status = paramMap.get("status") != null ? Integer.valueOf(paramMap.get("status").toString()) : 0;
                    receiptDo.setStatus(status);
                }
                receiptDo.update();
                this.result.put("code", "000000");
                this.result.put("msg", "\u4fee\u6539\u6210\u529f");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u4fee\u6539\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }
}

