/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.core.common.Page;
import com.club.framework.util.BeanUtils;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.web.image.service.ImageService;
import com.club.web.image.service.vo.ImageVo;
import com.club.web.stock.domain.CargoSkuTypeDo;
import com.club.web.stock.domain.repository.CargoSkuTypeRepository;
import com.club.web.stock.domain.repository.StockManagerRepository;
import com.club.web.stock.service.CargoClassifyService;
import com.club.web.stock.service.CargoService;
import com.club.web.stock.service.StockManagerService;
import com.club.web.stock.vo.CargoInfoVo;
import com.club.web.stock.vo.SkuGoodsParam;
import com.club.web.store.dao.base.po.TradeGood;
import com.club.web.store.dao.extend.GoodsColumnExtendMapper;
import com.club.web.store.dao.extend.TradeGoodExtendMapper;
import com.club.web.store.dao.repository.StoreSupplyPriceRepositoryImpl;
import com.club.web.store.domain.GoodUpDo;
import com.club.web.store.domain.StoreSupplyPriceDo;
import com.club.web.store.domain.TradeGoodDo;
import com.club.web.store.domain.TradeGoodSkuDo;
import com.club.web.store.domain.repository.GoodEvaluationRepository;
import com.club.web.store.domain.repository.GoodLabelsRepository;
import com.club.web.store.domain.repository.GoodRepository;
import com.club.web.store.domain.repository.GoodSKURepository;
import com.club.web.store.service.GoodEvaluationService;
import com.club.web.store.service.GoodLabelsService;
import com.club.web.store.service.GoodService;
import com.club.web.store.service.GoodSkuService;
import com.club.web.store.service.MessagePushCommon;
import com.club.web.store.service.TradeHeadStoreService;
import com.club.web.store.vo.GoodDetailsVo;
import com.club.web.store.vo.GoodEvaluationVo;
import com.club.web.store.vo.GoodLabelsVo;
import com.club.web.store.vo.GoodListVo;
import com.club.web.store.vo.GoodVo;
import com.club.web.store.vo.GoodsColumnVo;
import com.club.web.store.vo.PushMsgVo;
import com.club.web.store.vo.ShanguoGoodMsg;
import com.club.web.store.vo.TradeGoodSkuVo;
import com.club.web.store.vo.TradeGoodVo;
import com.club.web.util.AJpushUtils;
import com.club.web.util.CommonUtil;
import com.club.web.util.IdGenerator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Transactional
@Service(value="goodServiceImpl")
public class GoodServiceImpl
implements GoodService {
    private Logger logger = LoggerFactory.getLogger(GoodServiceImpl.class);
    @Autowired
    private GoodRepository goodRepository;
    @Autowired
    private GoodSKURepository goodSkuRepository;
    @Autowired
    private StockManagerService stockManagerService;
    @Autowired
    private GoodSkuService goodSkuServiceImpl;
    @Autowired
    private GoodLabelsService goodLabelsServiceImpl;
    @Autowired
    private GoodLabelsRepository goodLabelsRepository;
    @Autowired
    private StockManagerRepository stockRepository;
    @Autowired
    private StoreSupplyPriceRepositoryImpl supplyPriceRepository;
    @Autowired
    private GoodEvaluationRepository evaluationRepository;
    @Autowired
    private CargoService cargoService;
    @Autowired
    private GoodEvaluationService goodEvaluationService;
    @Autowired
    private CargoSkuTypeRepository cargoSkuTypeRepository;
    @Autowired
    private MessagePushCommon msgPush;
    @Autowired
    private ImageService imageService;
    @Autowired
    private TradeGoodExtendMapper goodMapper;
    @Autowired
    private TradeHeadStoreService tradeHeadStoreService;
    @Autowired
    private CargoClassifyService cargoClassify;
    @Autowired
    GoodsColumnExtendMapper goodsColumnExtendMapper;
    @Autowired
    AJpushUtils aJpushUtils;

    @Override
    public void addGood(GoodVo goodVo, List<String> labels, List<String> cargoSkuIds, List<String> cargoSkuNames, List<String> marketPriceList, List<String> salePriceList, List<String> supplyPriceList, long j, List<String> levelIds, HttpServletRequest request) throws Exception {
        int i;
        ImageVo imageVo;
        TradeGoodVo tradevo = new TradeGoodVo();
        GoodLabelsVo goodLabelsVo = new GoodLabelsVo();
        TradeGoodDo tradeGoodDo = new TradeGoodDo();
        StoreSupplyPriceDo storeSupplyPricedo = new StoreSupplyPriceDo();
        Date date = new Date();
        goodVo.setCreateTime(date);
        goodVo.setTradeGoodId(Long.toString(IdGenerator.getDefault().nextId()));
        BeanUtils.copyProperties(goodVo, tradevo);
        tradevo.setCargoId(Long.parseLong(goodVo.getCargoId()));
        tradevo.setId(Long.parseLong(goodVo.getTradeGoodId()));
        BeanUtils.copyProperties(tradevo, tradeGoodDo);
        if (goodVo.getImgRectangle() != null && !"".equals(goodVo.getImgRectangle())) {
            imageVo = this.imageService.saveImage(goodVo.getImgRectangle());
            tradeGoodDo.setImgRectangle(imageVo.getId());
        }
        if (goodVo.getImgSquare() != null && !"".equals(goodVo.getImgSquare())) {
            imageVo = this.imageService.saveImage(goodVo.getImgSquare());
            tradeGoodDo.setImgSquare(imageVo.getId());
        }
        if (goodVo.getImgLarge() != null && !"".equals(goodVo.getImgLarge())) {
            imageVo = this.imageService.saveImage(goodVo.getImgLarge());
            tradeGoodDo.setImgLarge(imageVo.getId());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (goodVo.getBeginTimeStr() != null && !goodVo.getBeginTimeStr().equals("")) {
            tradeGoodDo.setBeginTime(sdf.parse(goodVo.getBeginTimeStr()));
        }
        if (goodVo.getEndTimeStr() != null && !goodVo.getEndTimeStr().equals("")) {
            tradeGoodDo.setEndTime(sdf.parse(goodVo.getEndTimeStr()));
        }
        if (this.tradeHeadStoreService.getStaffHeadStoreId(request) != null) {
            tradeGoodDo.setHeadstoreId(this.tradeHeadStoreService.getStaffHeadStoreId(request));
        }
        tradeGoodDo.setStatus(2);
        if (goodVo.getPostid() != null) {
            tradeGoodDo.setPostid(Long.parseLong(goodVo.getPostid()));
        }
        this.goodRepository.addGood(tradeGoodDo);
        for (i = 0; i < cargoSkuIds.size(); ++i) {
            TradeGoodSkuVo tradeSkuVo = new TradeGoodSkuVo();
            BeanUtils.copyProperties(goodVo, tradeSkuVo);
            tradeSkuVo.setId(Long.toString(IdGenerator.getDefault().nextId()));
            tradeSkuVo.setGoodId(tradevo.getId().toString());
            tradeSkuVo.setCargoSkuId(cargoSkuIds.get(i).toString());
            tradeSkuVo.setCargoSkuName(cargoSkuNames.get(i).toString());
            tradeSkuVo.setStartTime(date);
            tradeSkuVo.setMarketPrice(Double.valueOf(marketPriceList.get(i).toString()));
            tradeSkuVo.setSalePrice(Double.valueOf(salePriceList.get(i).toString()));
            tradeSkuVo.setNums(0L);
            this.goodSkuServiceImpl.addGoodSku(tradeSkuVo);
            int k = 0;
            while (j != -1L && supplyPriceList != null && supplyPriceList.size() != 0 && levelIds != null && levelIds.size() != 0 && !levelIds.equals("")) {
                storeSupplyPricedo.setId(IdGenerator.getDefault().nextId());
                storeSupplyPricedo.setGoodSkuId(Long.parseLong(tradeSkuVo.getId()));
                storeSupplyPricedo.setGoodId(Long.parseLong(tradeSkuVo.getGoodId()));
                if (!supplyPriceList.get(0).equals("")) {
                    storeSupplyPricedo.setSupplyPrice(Double.parseDouble(supplyPriceList.get(0)));
                } else {
                    storeSupplyPricedo.setSupplyPrice(0.0);
                }
                storeSupplyPricedo.setStoreLevelId(Long.parseLong(levelIds.get(0)));
                this.supplyPriceRepository.saveSupplyPrice(storeSupplyPricedo);
                supplyPriceList.remove(0);
                levelIds.remove(0);
                if ((long)(++k) != j) continue;
            }
        }
        if (labels != null && labels.size() > 0) {
            for (i = 0; i < labels.size(); ++i) {
                goodLabelsVo.setId(IdGenerator.getDefault().nextId());
                goodLabelsVo.setGoodId(tradevo.getId());
                goodLabelsVo.setGoodBaseLabelId(Long.parseLong(labels.get(i)));
                this.goodLabelsServiceImpl.addGoodLabels(goodLabelsVo);
            }
        }
    }

    @Override
    public void editGood(GoodVo goodVo, List<String> labels, List<String> cargoSkuIds, List<String> cargoSkuNames, List<String> marketPriceList, List<String> salePriceList, List<String> supplyPriceList, long j, List<String> levelIds, HttpServletRequest request) throws Exception {
        int i;
        ImageVo imageVo;
        TradeGood oldGood;
        TradeGoodVo tradevo = new TradeGoodVo();
        GoodLabelsVo goodLabelsVo = new GoodLabelsVo();
        TradeGoodDo tradeGoodDo = new TradeGoodDo();
        StoreSupplyPriceDo storeSupplyPricedo = new StoreSupplyPriceDo();
        Date date = new Date();
        goodVo.setCreateTime(date);
        BeanUtils.copyProperties(goodVo, tradevo);
        tradevo.setId(Long.parseLong(goodVo.getTradeGoodId()));
        tradevo.setCargoId(Long.parseLong(goodVo.getCargoId()));
        BeanUtils.copyProperties(tradevo, tradeGoodDo);
        tradeGoodDo.setId(tradevo.getId());
        tradeGoodDo.setCargoId(tradevo.getCargoId());
        if (goodVo.getSaleNum() != null && !goodVo.getSaleNum().equals("")) {
            tradeGoodDo.setSaleNum(Integer.parseInt(goodVo.getSaleNum()));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (goodVo.getBeginTimeStr() != null && !goodVo.getBeginTimeStr().equals("")) {
            tradeGoodDo.setBeginTime(sdf.parse(goodVo.getBeginTimeStr()));
        }
        if (goodVo.getEndTimeStr() != null && !goodVo.getEndTimeStr().equals("")) {
            tradeGoodDo.setEndTime(sdf.parse(goodVo.getEndTimeStr()));
        }
        if (this.tradeHeadStoreService.getStaffHeadStoreId(request) != null) {
            tradeGoodDo.setHeadstoreId(this.tradeHeadStoreService.getStaffHeadStoreId(request));
        }
        if (goodVo.getPostid() != null) {
            tradeGoodDo.setPostid(Long.parseLong(goodVo.getPostid()));
        }
        if ((oldGood = this.goodMapper.selectByPrimaryKey(tradevo.getId())).getImgSquare() == null || "".equals(oldGood.getImgSquare())) {
            if (goodVo.getImgSquare() != null && !"".equals(goodVo.getImgSquare())) {
                imageVo = this.imageService.saveImage(goodVo.getImgSquare());
                tradeGoodDo.setImgSquare(imageVo.getId());
            }
        } else if (goodVo.getImgSquare() != null && !"".equals(goodVo.getImgSquare())) {
            imageVo = this.imageService.selectImageById(oldGood.getImgSquare());
            imageVo.setPicUrl(goodVo.getImgSquare());
            this.imageService.updateImage(imageVo);
            tradeGoodDo.setImgSquare(oldGood.getImgSquare());
        } else {
            this.imageService.deleteById(oldGood.getImgSquare());
            tradeGoodDo.setImgSquare(null);
        }
        if (oldGood.getImgRectangle() == null || "".equals(oldGood.getImgRectangle())) {
            if (goodVo.getImgRectangle() != null && !"".equals(goodVo.getImgRectangle())) {
                imageVo = this.imageService.saveImage(goodVo.getImgRectangle());
                tradeGoodDo.setImgRectangle(imageVo.getId());
            }
        } else if (goodVo.getImgRectangle() != null && !"".equals(goodVo.getImgRectangle())) {
            imageVo = this.imageService.selectImageById(oldGood.getImgRectangle());
            imageVo.setPicUrl(goodVo.getImgRectangle());
            this.imageService.updateImage(imageVo);
            tradeGoodDo.setImgRectangle(oldGood.getImgRectangle());
        } else {
            this.imageService.deleteById(oldGood.getImgRectangle());
            tradeGoodDo.setImgRectangle(null);
        }
        if (oldGood.getImgLarge() == null || "".equals(oldGood.getImgLarge())) {
            if (goodVo.getImgLarge() != null && !"".equals(goodVo.getImgLarge())) {
                imageVo = this.imageService.saveImage(goodVo.getImgLarge());
                tradeGoodDo.setImgLarge(imageVo.getId());
            }
        } else if (goodVo.getImgLarge() != null && !"".equals(goodVo.getImgLarge())) {
            imageVo = this.imageService.selectImageById(oldGood.getImgLarge());
            imageVo.setPicUrl(goodVo.getImgLarge());
            this.imageService.updateImage(imageVo);
            tradeGoodDo.setImgLarge(oldGood.getImgLarge());
        } else {
            this.imageService.deleteById(oldGood.getImgLarge());
            tradeGoodDo.setImgLarge(null);
        }
        this.goodRepository.updateTradeGood(tradeGoodDo);
        List<TradeGoodSkuVo> exgistSkuList = this.goodSkuRepository.selectGoodSkuByGoodId(tradevo.getId());
        if (j != -1L && supplyPriceList != null && supplyPriceList.size() != 0 && levelIds != null && levelIds.size() != 0) {
            this.supplyPriceRepository.deleteByGoodId(Long.parseLong(goodVo.getTradeGoodId()));
        }
        block0: for (TradeGoodSkuVo oldGoodSkuVo : exgistSkuList) {
            int flag = -1;
            for (int i2 = 0; i2 < cargoSkuIds.size(); ++i2) {
                if (!oldGoodSkuVo.getCargoSkuId().equals(cargoSkuIds.get(i2).toString())) continue;
                flag = i2;
                break;
            }
            if (flag == -1) {
                this.goodSkuRepository.deleteTradeGoodSKU(Long.parseLong(oldGoodSkuVo.getId()));
                continue;
            }
            TradeGoodSkuVo tradeSkuVo = new TradeGoodSkuVo();
            BeanUtils.copyProperties(goodVo, tradeSkuVo);
            tradeSkuVo.setId(oldGoodSkuVo.getId());
            tradeSkuVo.setGoodId(goodVo.getTradeGoodId());
            TradeGoodSkuDo tradeGoodSkuDo = new TradeGoodSkuDo();
            tradeGoodSkuDo.setId(Long.parseLong(oldGoodSkuVo.getId()));
            tradeGoodSkuDo.setCargoSkuId(Long.parseLong(cargoSkuIds.get(flag)));
            tradeGoodSkuDo.setGoodId(tradevo.getId());
            tradeGoodSkuDo.setCargoSkuName(cargoSkuNames.get(flag));
            tradeGoodSkuDo.setStartTime(date);
            tradeGoodSkuDo.setMarketPrice(Double.valueOf(marketPriceList.get(flag)));
            tradeGoodSkuDo.setSalePrice(Double.valueOf(salePriceList.get(flag)));
            tradeGoodSkuDo.setNums(oldGoodSkuVo.getNums());
            this.goodSkuRepository.updateTradeGoodSKU(tradeGoodSkuDo);
            int k = 0;
            while (j != -1L && supplyPriceList != null && supplyPriceList.size() != 0 && levelIds != null && levelIds.size() != 0) {
                storeSupplyPricedo.setId(IdGenerator.getDefault().nextId());
                storeSupplyPricedo.setGoodSkuId(Long.parseLong(tradeSkuVo.getId()));
                storeSupplyPricedo.setGoodId(Long.parseLong(tradeSkuVo.getGoodId()));
                if (!supplyPriceList.get(0).equals("")) {
                    storeSupplyPricedo.setSupplyPrice(Double.parseDouble(supplyPriceList.get(0)));
                } else {
                    storeSupplyPricedo.setSupplyPrice(0.0);
                }
                storeSupplyPricedo.setStoreLevelId(Long.parseLong(levelIds.get(0)));
                this.supplyPriceRepository.saveSupplyPrice(storeSupplyPricedo);
                supplyPriceList.remove(0);
                levelIds.remove(0);
                if ((long)(++k) != j) continue;
                continue block0;
            }
        }
        for (i = 0; i < cargoSkuIds.size(); ++i) {
            int flag = -1;
            for (TradeGoodSkuVo tempGoodSkuVo : exgistSkuList) {
                if (!tempGoodSkuVo.getCargoSkuId().equals(cargoSkuIds.get(i).toString())) continue;
                flag = i;
                break;
            }
            if (flag != -1) continue;
            TradeGoodSkuVo tradeSkuVo = new TradeGoodSkuVo();
            BeanUtils.copyProperties(goodVo, tradeSkuVo);
            tradeSkuVo.setId(Long.toString(IdGenerator.getDefault().nextId()));
            tradeSkuVo.setGoodId(tradevo.getId().toString());
            tradeSkuVo.setCargoSkuId(cargoSkuIds.get(i).toString());
            tradeSkuVo.setCargoSkuName(cargoSkuNames.get(i).toString());
            tradeSkuVo.setStartTime(date);
            tradeSkuVo.setMarketPrice(Double.valueOf(marketPriceList.get(i).toString()));
            tradeSkuVo.setSalePrice(Double.valueOf(salePriceList.get(i).toString()));
            tradeSkuVo.setNums(0L);
            this.goodSkuServiceImpl.addGoodSku(tradeSkuVo);
            int k = 0;
            while (j != -1L && supplyPriceList != null && supplyPriceList.size() != 0 && levelIds != null && levelIds.size() != 0) {
                storeSupplyPricedo.setId(IdGenerator.getDefault().nextId());
                storeSupplyPricedo.setGoodSkuId(Long.parseLong(tradeSkuVo.getId()));
                storeSupplyPricedo.setGoodId(Long.parseLong(tradeSkuVo.getGoodId()));
                if (!supplyPriceList.get(0).equals("")) {
                    storeSupplyPricedo.setSupplyPrice(Double.parseDouble(supplyPriceList.get(0)));
                } else {
                    storeSupplyPricedo.setSupplyPrice(0.0);
                }
                storeSupplyPricedo.setStoreLevelId(Long.parseLong(levelIds.get(0)));
                this.supplyPriceRepository.saveSupplyPrice(storeSupplyPricedo);
                supplyPriceList.remove(0);
                levelIds.remove(0);
                if ((long)(++k) != j) continue;
            }
        }
        this.goodLabelsRepository.deleteByGoodId(tradevo.getId());
        for (i = 0; i < labels.size(); ++i) {
            goodLabelsVo.setId(IdGenerator.getDefault().nextId());
            goodLabelsVo.setGoodId(tradevo.getId());
            goodLabelsVo.setGoodBaseLabelId(Long.parseLong(labels.get(i)));
            this.goodLabelsServiceImpl.addGoodLabels(goodLabelsVo);
        }
    }

    @Override
    public void updateGood(TradeGoodVo vo) {
        TradeGoodDo tradeGoodDo = new TradeGoodDo();
        BeanUtils.copyProperties(vo, tradeGoodDo);
        this.goodRepository.updateTradeGood(tradeGoodDo);
    }

    @Override
    public void deleteById(long id) {
        try {
            this.goodRepository.deleteTradeGood(id);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
    }

    @Override
    public Page<Map<String, Object>> queryGoodPage(Page<Map<String, Object>> page) {
        Page<Map<String, Object>> result = new Page<Map<String, Object>>();
        try {
            result.setStart(page.getStart());
            result.setLimit(page.getLimit());
            List<GoodVo> list = null;
            list = this.goodRepository.queryGoodPage(page);
            Long count = this.goodRepository.queryGoodCountPage(page);
            result.setResultList(CommonUtil.listObjTransToListMap(list));
            result.setTotalRecords(count.intValue());
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u5546\u54c1\u540d\u79f0\u67e5\u8be2\u5f02\u5e38<queryCargoBrandPageBrandSer>:", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<GoodVo> queryGoodLittleList(Page<Map<String, Object>> page) {
        List<GoodVo> list = null;
        try {
            page.setStart(0);
            page.setLimit(9999);
            list = this.goodRepository.queryGoodPage(page);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5217\u8868\u5f02\u5e38<queryGoodLittleList>:", (Throwable)e);
        }
        return list;
    }

    @Override
    public Map<String, Object> deleteGoods(String idStr) {
        String[] Ids = idStr.split(",");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String id : Ids) {
            this.evaluationRepository.deleteByGoodId(Long.parseLong(id));
            this.supplyPriceRepository.deleteByGoodId(Long.parseLong(id));
            this.goodLabelsRepository.deleteByGoodId(Long.parseLong(id));
            this.goodSkuRepository.deleteSkuByGoodId(Long.parseLong(id));
            this.goodRepository.deleteTradeGood(Long.parseLong(id));
        }
        return result;
    }

    @Override
    public List<TradeGoodSkuVo> selectTradeGoodSkuVo(String goodId) {
        List<TradeGoodSkuVo> list = this.goodSkuRepository.selectGoodSkuByGoodId(Long.parseLong(goodId));
        for (TradeGoodSkuVo tradeGoodSkuVo : list) {
            tradeGoodSkuVo.setLeftNums(this.getLeftNums(Long.parseLong(tradeGoodSkuVo.getCargoSkuId())));
        }
        return list;
    }

    @Override
    public Boolean updateUpGoodStatus(String goodId, List<SkuGoodsParam> list, long userId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<GoodUpDo> listDo = new ArrayList<GoodUpDo>();
        map.put("id", Long.parseLong(goodId));
        map.put("status", 1);
        for (SkuGoodsParam skuGoodsParam : list) {
            GoodUpDo upDo = new GoodUpDo();
            upDo.setGoodSkuId(Long.parseLong(skuGoodsParam.getGoodSkuId()));
            upDo.setCargoSkuId(Long.parseLong(skuGoodsParam.getCargoSkuId()));
            upDo.setNum(Long.parseLong(skuGoodsParam.getNum()));
            listDo.add(upDo);
        }
        Map<String, Object> upMap = this.stockManagerService.updateUpAndDownGoodsMsg(list, userId, 0);
        if (upMap != null && "000000".equals(upMap.get("code").toString())) {
            this.goodRepository.updateStatus(map);
            this.goodSkuRepository.updateNumById(listDo);
            TradeGoodVo good = this.goodRepository.queryTradeGoodInfo(Long.parseLong(goodId));
            this.aJpushUtils.sendAll("\u3010" + good.getName() + "\u3011\u9500\u552e\u5546\u54c1\u5df2\u4e0a\u67b6\u5566\uff01");
            return true;
        }
        return false;
    }

    private void goodMsgPush(long goodId) {
        TradeGoodVo good = null;
        try {
            good = this.goodRepository.queryTradeGoodInfo(goodId);
            PushMsgVo pushObj = new PushMsgVo();
            pushObj.setMsgType("0");
            pushObj.setPushType("3");
            pushObj.setOffline(true);
            pushObj.setChannel("3");
            pushObj.setTitle("\u65b0\u54c1\u4e0a\u7ebf");
            pushObj.setContent("[\u4e0a\u65b0]" + good.getName());
            pushObj.setOffline(true);
            pushObj.setOfflineExpireTime(86400000L);
            this.msgPush.pushMsgUtil(pushObj);
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u4e0a\u67b6\u63a8\u9001\u5f02\u5e38<goodMsgPush>:", (Throwable)e);
        }
    }

    @Override
    public Boolean updateDownGoodStatus(List<String> ids, long userId) throws Exception {
        ArrayList list = new ArrayList();
        ArrayList<TradeGoodSkuVo> goodSkuVoList = new ArrayList<TradeGoodSkuVo>();
        ArrayList<SkuGoodsParam> paramList = new ArrayList<SkuGoodsParam>();
        ArrayList<GoodUpDo> doList = new ArrayList<GoodUpDo>();
        for (String id : ids) {
            List<TradeGoodSkuVo> list2 = this.goodSkuRepository.selectGoodSkuByGoodId(Long.parseLong(id));
            goodSkuVoList.addAll(list2);
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("id", Long.parseLong(id));
            map.put("status", 0);
            list.add(map);
        }
        for (TradeGoodSkuVo tradeGoodSkuVo : goodSkuVoList) {
            SkuGoodsParam skuGoodsParam = new SkuGoodsParam();
            skuGoodsParam.setCargoSkuId(tradeGoodSkuVo.getCargoSkuId());
            skuGoodsParam.setGoodSkuId(tradeGoodSkuVo.getId());
            if (tradeGoodSkuVo.getNums() == null) {
                skuGoodsParam.setNum("0");
            } else {
                skuGoodsParam.setNum(tradeGoodSkuVo.getNums().toString());
            }
            paramList.add(skuGoodsParam);
            GoodUpDo upDo = new GoodUpDo();
            upDo.setGoodSkuId(Long.parseLong(tradeGoodSkuVo.getId()));
            upDo.setCargoSkuId(Long.parseLong(tradeGoodSkuVo.getCargoSkuId()));
            upDo.setNum(0L);
            doList.add(upDo);
        }
        Map<String, Object> map = this.stockManagerService.updateUpAndDownGoodsMsg(paramList, userId, 1);
        if (map != null && "000000".equals(map.get("code").toString())) {
            for (Map map2 : list) {
                this.goodRepository.updateStatus(map2);
            }
            this.goodSkuRepository.updateNumById(doList);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, String> updateGoodSkuNums(List<SkuGoodsParam> list, int status) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<GoodUpDo> goodUpList = new ArrayList<GoodUpDo>();
        ArrayList<GoodUpDo> goodUpSaleNumList = new ArrayList<GoodUpDo>();
        ArrayList<GoodUpDo> allSaleNumList = new ArrayList<GoodUpDo>();
        if (list == null || list.size() == 0) throw new RuntimeException("\u4f20\u5165\u7684list\u53c2\u6570\u4e3a\u7a7a");
        for (SkuGoodsParam param : list) {
            Integer newSaleNum;
            Long newNum;
            Integer nowSaleNum;
            Long nowNum;
            TradeGoodSkuVo tradeGoodSkuVo;
            GoodUpDo goodUpDo = new GoodUpDo();
            GoodUpDo goodUpDoSaleNum = new GoodUpDo();
            GoodUpDo goodUpDoAllSaleNum = new GoodUpDo();
            goodUpDo.setGoodSkuId(Long.parseLong(param.getGoodSkuId()));
            goodUpDoSaleNum.setGoodSkuId(Long.parseLong(param.getGoodSkuId()));
            goodUpDoAllSaleNum.setGoodSkuId(Long.parseLong(param.getGoodSkuId()));
            if (param.getGoodSkuId() == null || param.getGoodSkuId() == "" || param.getNum() == null || param.getNum() == "") continue;
            Long skuId = Long.parseLong(param.getGoodSkuId());
            if (skuId > 100000000000L) {
                Integer newAllSaleNum;
                Integer newSaleNum2;
                Long newNum2;
                tradeGoodSkuVo = this.goodSkuRepository.selectSkuById(skuId);
                if (tradeGoodSkuVo == null) {
                    return result;
                }
                nowNum = tradeGoodSkuVo.getNums();
                nowSaleNum = tradeGoodSkuVo.getSaleNum();
                Integer allSaleNum = this.goodMapper.selectByPrimaryKey(Long.parseLong(tradeGoodSkuVo.getGoodId())).getSaleNum();
                nowNum = nowNum == null ? 0L : nowNum;
                nowSaleNum = nowSaleNum == null ? 0 : nowSaleNum;
                allSaleNum = allSaleNum == null ? 0 : allSaleNum;
                if (status == 0) {
                    if (Long.parseLong(param.getNum()) > nowNum) throw new RuntimeException("\u5546\u54c1sku\u7684\u5bf9\u5e94\u7684\u4e0a\u67b6\u6570\u91cf\u5c0f\u4e8e\u5ba2\u6237\u8d2d\u4e70\u7684\u6570\u91cf");
                    newNum2 = nowNum - Long.parseLong(param.getNum());
                    newSaleNum2 = nowSaleNum + Integer.parseInt(param.getNum());
                    newAllSaleNum = allSaleNum + Integer.parseInt(param.getNum());
                    goodUpDo.setNum(newNum2);
                    goodUpDoSaleNum.setNum(newSaleNum2.intValue());
                    goodUpDoAllSaleNum.setNum(newAllSaleNum.intValue());
                } else {
                    newNum2 = nowNum + Long.parseLong(param.getNum());
                    newSaleNum2 = nowSaleNum - Integer.parseInt(param.getNum());
                    newAllSaleNum = allSaleNum - Integer.parseInt(param.getNum());
                    goodUpDo.setNum(newNum2);
                    goodUpDo.setNum(newNum2);
                    goodUpDoSaleNum.setNum(newSaleNum2.intValue());
                    goodUpDoAllSaleNum.setNum(newAllSaleNum.intValue());
                }
                goodUpList.add(goodUpDo);
                goodUpSaleNumList.add(goodUpDoSaleNum);
                allSaleNumList.add(goodUpDoAllSaleNum);
                continue;
            }
            tradeGoodSkuVo = this.goodSkuRepository.selectPackageById(skuId);
            if (tradeGoodSkuVo == null) {
                return result;
            }
            nowNum = tradeGoodSkuVo.getNums();
            nowSaleNum = tradeGoodSkuVo.getSaleNum();
            nowNum = nowNum == null ? 0L : nowNum;
            nowSaleNum = nowSaleNum == null ? 0 : nowSaleNum;
            if (status == 0) {
                if (Long.parseLong(param.getNum()) > nowNum) throw new RuntimeException("\u5546\u54c1sku\u7684\u5bf9\u5e94\u7684\u4e0a\u67b6\u6570\u91cf\u5c0f\u4e8e\u5ba2\u6237\u8d2d\u4e70\u7684\u6570\u91cf");
                newNum = nowNum - Long.parseLong(param.getNum());
                newSaleNum = nowSaleNum + Integer.parseInt(param.getNum());
                this.goodSkuRepository.updatePackage(newNum, newSaleNum, tradeGoodSkuVo.getId());
                continue;
            }
            newNum = nowNum + Long.parseLong(param.getNum());
            newSaleNum = nowSaleNum - Integer.parseInt(param.getNum());
            goodUpDo.setNum(newNum);
            this.goodSkuRepository.updatePackage(newNum, newSaleNum, tradeGoodSkuVo.getId());
        }
        this.goodSkuRepository.updateNumById(goodUpList);
        this.goodSkuRepository.updateSaleNumById(goodUpSaleNumList);
        this.goodRepository.updateSaleNumById(allSaleNumList);
        result.put("result", "\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\u66f4\u6539\u6210\u529f");
        return result;
    }

    public int getLeftNums(long CargoSkuId) {
        return this.stockRepository.queryStockCountBySkuId(CargoSkuId);
    }

    @Override
    public Long ifGoodExgist(long cargoId) {
        return this.goodRepository.ifGoodExgist(cargoId);
    }

    @Override
    public List<GoodListVo> queryGoodList(Map<String, Object> map) {
        return this.goodRepository.queryGoodList(map);
    }

    @Override
    public GoodDetailsVo getGoodDetails(long goodId) {
        List<GoodEvaluationVo> goodEvaluationList;
        GoodDetailsVo goodDetailsVo = new GoodDetailsVo();
        Double marketPrice = 0.0;
        Double salePrice = 0.0;
        int index = 0;
        int nums = 0;
        HashMap<String, Object> skuType = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> skuTypeList = new ArrayList<Map<String, Object>>();
        List<TradeGoodSkuVo> tradeGoodSkuList = this.goodSkuRepository.selectSkuList(goodId);
        for (TradeGoodSkuVo tradeGoodSkuVo : tradeGoodSkuList) {
            if (tradeGoodSkuVo.getId() == null || tradeGoodSkuVo.getId().isEmpty()) continue;
            int leftNums = tradeGoodSkuVo.getNums() != null ? Integer.valueOf(tradeGoodSkuVo.getNums() + "") : 0;
            tradeGoodSkuVo.setLeftNums(leftNums);
            nums += leftNums;
            if (index == 0) {
                marketPrice = tradeGoodSkuVo.getMarketPrice();
                salePrice = tradeGoodSkuVo.getSalePrice();
                ++index;
            }
            if (tradeGoodSkuVo.getMarketPrice() > marketPrice) {
                marketPrice = tradeGoodSkuVo.getMarketPrice();
            }
            if (!(tradeGoodSkuVo.getSalePrice() < salePrice)) continue;
            salePrice = tradeGoodSkuVo.getSalePrice();
        }
        goodDetailsVo.setKucun(nums);
        goodDetailsVo.setGoodSkuList(tradeGoodSkuList);
        goodDetailsVo.setMarketPrice(new BigDecimal(Double.toString(marketPrice)));
        goodDetailsVo.setSalePrice(new BigDecimal(Double.toString(salePrice)));
        TradeGoodVo tradeGoodInfo = this.goodRepository.queryTradeGoodInfo(goodId);
        if (tradeGoodInfo != null) {
            List<CargoSkuTypeDo> cargoSkuTypeList;
            goodDetailsVo.setTradeGoodId(tradeGoodInfo.getId() + "");
            goodDetailsVo.setPost(tradeGoodInfo.getPost());
            goodDetailsVo.setName(tradeGoodInfo.getName());
            goodDetailsVo.setSaleNum(tradeGoodInfo.getSaleNum() == null ? 0 : tradeGoodInfo.getSaleNum());
            goodDetailsVo.setPostId(tradeGoodInfo.getPostid() == null ? "" : tradeGoodInfo.getPostid().toString());
            Long cargoId = tradeGoodInfo.getCargoId();
            CargoInfoVo cargoInfoVo = this.cargoService.getCargoInfo(cargoId);
            if (cargoInfoVo != null) {
                goodDetailsVo.setSmallImage(cargoInfoVo.getSmallImage() != null ? cargoInfoVo.getSmallImage().getUrl() : "");
                goodDetailsVo.setDetailImages(cargoInfoVo.getDetailImages());
                goodDetailsVo.setShowImages(cargoInfoVo.getShowImages());
            }
            if ((cargoSkuTypeList = this.cargoSkuTypeRepository.getListByCargoId(cargoId)) != null) {
                for (CargoSkuTypeDo cargoSkuTypeDo : cargoSkuTypeList) {
                    skuType = new HashMap();
                    skuType.put("skuName", cargoSkuTypeDo.getName());
                    skuType.put("skuType", cargoSkuTypeDo.getType());
                    skuTypeList.add(skuType);
                }
                goodDetailsVo.setSkuTypeList(skuTypeList);
            }
        }
        if ((goodEvaluationList = this.goodEvaluationService.selectEvaluationByGoodId(goodId)) != null) {
            goodDetailsVo.setGoodEvaluationList(goodEvaluationList);
        }
        return goodDetailsVo;
    }

    @Override
    public List<TradeGoodSkuVo> queryGoodSkuList(Long goodId) {
        return this.goodSkuRepository.selectGoodSkuByGoodId(goodId);
    }

    @Override
    public List<ShanguoGoodMsg> getSaleGoodListSer(Map<String, Object> param) {
        List<ShanguoGoodMsg> list = this.goodMapper.getSaleGoodList(param);
        return list;
    }

    @Override
    public List<ShanguoGoodMsg> getUnshelveGoodListSer(Map<String, Object> param) {
        List<ShanguoGoodMsg> list = this.goodMapper.getUnshelveGoodList(param);
        return list;
    }

    @Override
    public List<ShanguoGoodMsg> getGoodListByMap(Map<String, Object> param) {
        List<ShanguoGoodMsg> list = this.goodMapper.getGoodListByMap(param);
        return list;
    }

    @Override
    public List<ShanguoGoodMsg> getSearchGoodListSer(Map<String, Object> param) {
        List<ShanguoGoodMsg> list = this.goodMapper.getSearchGoodList(param);
        return list;
    }

    @Override
    public GoodDetailsVo getShanguoGoodDetailSer(Long goodId, Long shopId) {
        List<GoodEvaluationVo> goodEvaluationList;
        GoodDetailsVo goodDetailsVo = new GoodDetailsVo();
        HashMap<String, Object> skuType = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> skuTypeList = new ArrayList<Map<String, Object>>();
        List<TradeGoodSkuVo> tradeGoodSkuList = this.goodSkuRepository.selectSkuList(goodId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodId", goodId);
        map.put("shopId", shopId);
        ShanguoGoodMsg obj = this.goodMapper.getWeixinGoodObj(map);
        if (obj != null) {
            goodDetailsVo.setPostId(obj.getPostId());
            goodDetailsVo.setKucun(obj.getStock());
            goodDetailsVo.setGoodSkuList(tradeGoodSkuList);
            goodDetailsVo.setMarketPrice(new BigDecimal(obj.getMarketPrice() + "").setScale(2, RoundingMode.HALF_UP));
            if (obj.getSupplyPrice() != null) {
                goodDetailsVo.setSupplyPrice(new BigDecimal(obj.getSupplyPrice() + "").setScale(2, RoundingMode.HALF_UP));
            }
            goodDetailsVo.setSalePrice(new BigDecimal(obj.getSalePrice() + "").setScale(2, RoundingMode.HALF_UP));
            goodDetailsVo.setTradeGoodId(obj.getId() + "");
            goodDetailsVo.setPost(obj.getPost());
            goodDetailsVo.setName(obj.getGoodName());
            goodDetailsVo.setSaleNum(obj.getSaleNum());
            goodDetailsVo.setStartDate(obj.getStartDate());
            goodDetailsVo.setEndDate(obj.getEndDate());
            goodDetailsVo.setColumnName(obj.getColumnName());
            goodDetailsVo.setStoreNum(obj.getStoreNum());
            goodDetailsVo.setPostName(obj.getPostName());
            goodDetailsVo.setSaleAllNum(obj.getSaleAllNum());
            Long cargoId = obj.getCargoId();
            CargoInfoVo cargoInfoVo = null;
            if (cargoId != null) {
                cargoInfoVo = this.cargoService.getCargoInfo(cargoId);
            }
            if (cargoInfoVo != null) {
                goodDetailsVo.setSmallImage(cargoInfoVo.getSmallImage() != null ? cargoInfoVo.getSmallImage().getUrl() : "");
                goodDetailsVo.setDetailImages(cargoInfoVo.getDetailImages());
                goodDetailsVo.setShowImages(cargoInfoVo.getShowImages());
                goodDetailsVo.setCargoNo(cargoInfoVo.getCargoNo());
            }
            List<CargoSkuTypeDo> cargoSkuTypeList = null;
            if (cargoId != null) {
                cargoSkuTypeList = this.cargoSkuTypeRepository.getListByCargoId(cargoId);
            }
            if (cargoSkuTypeList != null) {
                for (CargoSkuTypeDo cargoSkuTypeDo : cargoSkuTypeList) {
                    skuType = new HashMap();
                    skuType.put("skuName", cargoSkuTypeDo.getName());
                    skuType.put("skuType", cargoSkuTypeDo.getType());
                    skuTypeList.add(skuType);
                }
                goodDetailsVo.setSkuTypeList(skuTypeList);
            }
        }
        if ((goodEvaluationList = this.goodEvaluationService.selectEvaluationByGoodId(goodId)) != null) {
            goodDetailsVo.setGoodEvaluationList(goodEvaluationList);
        }
        return goodDetailsVo;
    }

    @Override
    public GoodDetailsVo getShanguoPackageDetailSer(Long goodId, Long shopId) {
        List<GoodEvaluationVo> goodEvaluationList;
        GoodDetailsVo goodDetailsVo = new GoodDetailsVo();
        HashMap skuType = new HashMap();
        ArrayList skuTypeList = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodId", goodId);
        map.put("shopId", shopId);
        ShanguoGoodMsg obj = this.goodMapper.getWeixinPackageObj(map);
        if (obj != null) {
            goodDetailsVo.setPostId(obj.getPostId());
            goodDetailsVo.setKucun(obj.getStock());
            if (obj.getMarketPrice() != null) {
                goodDetailsVo.setMarketPrice(new BigDecimal(obj.getMarketPrice() + "").setScale(2, RoundingMode.HALF_UP));
            }
            if (obj.getSupplyPrice() != null) {
                goodDetailsVo.setSupplyPrice(new BigDecimal(obj.getSupplyPrice() + "").setScale(2, RoundingMode.HALF_UP));
            }
            goodDetailsVo.setSalePrice(new BigDecimal(obj.getSalePrice() + "").setScale(2, RoundingMode.HALF_UP));
            goodDetailsVo.setTradeGoodId(obj.getId() + "");
            goodDetailsVo.setPost(obj.getPost());
            goodDetailsVo.setName(obj.getGoodName());
            goodDetailsVo.setSaleNum(obj.getSaleNum());
            goodDetailsVo.setColumnName(obj.getColumnName());
            goodDetailsVo.setStoreNum(obj.getStoreNum());
            goodDetailsVo.setPostName(obj.getPostName());
            goodDetailsVo.setSaleAllNum(obj.getSaleAllNum());
            goodDetailsVo.setShowPhoto(obj.getShowPicture());
            goodDetailsVo.setDetailPhoto(obj.getDetailPhoto());
            goodDetailsVo.setPackSpec(obj.getPackSpec());
            goodDetailsVo.setSmallImage(obj.getMin_photo());
        }
        if ((goodEvaluationList = this.goodEvaluationService.selectEvaluationByGoodId(goodId)) != null) {
            goodDetailsVo.setGoodEvaluationList(goodEvaluationList);
        }
        return goodDetailsVo;
    }

    @Override
    public List<GoodsColumnVo> getColumnList() {
        List<GoodsColumnVo> list = this.goodsColumnExtendMapper.selectAllGoodsColumn();
        return list;
    }

    @Override
    public List<ShanguoGoodMsg> getWeixinGoodListSers(String conditionStr, int pageSize, int pageNum, String classifyId) {
        Map<String, Object> param = null;
        List<Long> listClassify = null;
        long classify = 0L;
        if (StringUtils.isNotEmpty(conditionStr)) {
            param = JsonUtil.toMap(conditionStr);
            if (param == null) {
                param = new HashMap<String, Object>();
            }
        } else {
            param = new HashMap<String, Object>();
        }
        if (classifyId != null && !"".equals(classifyId) && (classify = Long.parseLong(classifyId)) > 0L) {
            try {
                listClassify = this.cargoClassify.getAllIdsByIdAndStatus(classify, null);
                param.put("classify", listClassify);
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u5206\u7c7b\u5b50Id\u5f02\u5e38<getWeixinGoodListSer>:", (Throwable)e);
            }
        }
        param.put("start", (pageNum - 1) * pageSize);
        param.put("limit", pageSize);
        List<ShanguoGoodMsg> list = this.goodMapper.getWeixinGoodList(param);
        return list;
    }

    @Override
    public List<ShanguoGoodMsg> getGoodPackageList(String conditionStr, String goodName, int pageSize, int pageNum, String shopId) {
        Map<String, Object> param = null;
        if (StringUtils.isNotEmpty(conditionStr)) {
            param = JsonUtil.toMap(conditionStr);
            if (param == null) {
                param = new HashMap<String, Object>();
            }
        } else {
            param = new HashMap<String, Object>();
        }
        if (goodName != null && !"".equals(goodName)) {
            param.put("goodName", goodName);
        }
        if (shopId != null && !"".equals(shopId)) {
            param.put("shopId", shopId);
        }
        param.put("start", (pageNum - 1) * pageSize);
        param.put("limit", pageSize);
        List<ShanguoGoodMsg> list = this.goodMapper.getGoodPackageList(param);
        return list;
    }

    @Override
    public List<ShanguoGoodMsg> getSeachGoodListSers(String conditionStr, int pageSize, int pageNum, String shopId, String startPrice, String endPrice, String brandId, String classifyId, String oneType, String twoType, String threeType, String use, String columnId, String saleNumSort, String priceSort, String goodName, String category, String theme, String cargoNo) {
        Map<String, Object> param = null;
        long classify = 0L;
        List<Long> listClassify = null;
        if (StringUtils.isNotEmpty(conditionStr)) {
            param = JsonUtil.toMap(conditionStr);
            if (param != null) {
                if (param.containsKey("pageSize")) {
                    int n = pageSize = param.get("pageSize") != null && !"".equals(param.get("pageSize").toString()) ? Integer.valueOf(param.get("pageSize").toString()) : pageSize;
                }
                if (param.containsKey("pageNum")) {
                    pageNum = param.get("pageNum") != null && !"".equals(param.get("pageNum").toString()) ? Integer.valueOf(param.get("pageNum").toString()) : pageNum;
                }
            } else {
                param = new HashMap<String, Object>();
            }
        } else {
            param = new HashMap<String, Object>();
        }
        if (startPrice != null && !"".equals(startPrice)) {
            param.put("startPrice", startPrice);
        }
        if (endPrice != null && !"".equals(endPrice)) {
            param.put("endPrice", endPrice);
        }
        if (brandId != null && !"".equals(brandId)) {
            param.put("brandId", brandId);
        }
        if (shopId != null && !"".equals(shopId)) {
            param.put("shopId", shopId);
        }
        if (oneType != null && !"".equals(oneType)) {
            classifyId = oneType;
        }
        if (twoType != null && !"".equals(twoType)) {
            classifyId = twoType;
        }
        if (threeType != null && !"".equals(threeType)) {
            classifyId = threeType;
        }
        if (classifyId != null && !"".equals(classifyId) && (classify = Long.parseLong(classifyId)) > 0L) {
            try {
                listClassify = this.cargoClassify.getAllIdsByIdAndStatus(classify, null);
                param.put("classify", listClassify);
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u5206\u7c7b\u5b50Id\u5f02\u5e38<getWeixinGoodListSer>:", (Throwable)e);
            }
        }
        if (use != null && !"".equals(use)) {
            param.put("use", use);
        }
        if (columnId != null && !"".equals(columnId)) {
            param.put("columnId", columnId);
        }
        if (category != null && !"".equals(category)) {
            param.put("category", category);
        }
        if (theme != null && !"".equals(theme)) {
            param.put("theme", theme);
        }
        if (saleNumSort != null && !"".equals(saleNumSort)) {
            param.put("saleNumSort", saleNumSort);
        }
        if (priceSort != null && !"".equals(priceSort)) {
            param.put("priceSort", priceSort);
        }
        if (goodName != null && !"".equals(goodName)) {
            param.put("goodName", goodName);
        }
        if (cargoNo != null && !"".equals(cargoNo)) {
            param.put("cargoNo", cargoNo);
        }
        param.put("start", (pageNum - 1) * pageSize);
        param.put("limit", pageSize);
        List<ShanguoGoodMsg> list = this.goodMapper.getSeachGoodList(param);
        return list;
    }

    @Override
    public int countGoodNumByCateGory(String category) {
        List<Long> listClassify = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        try {
            listClassify = this.cargoClassify.getAllIdsByIdAndStatus(267363888026800128L, null);
            param.put("classify", listClassify);
            param.put("category", category);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5206\u7c7b\u5b50Id\u5f02\u5e38<getWeixinGoodListSer>:", (Throwable)e);
        }
        return this.goodMapper.countGoodNumByCateGory(param);
    }
}

