/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.core.common.Page;
import com.club.web.store.domain.GoodsBaseLabelDo;
import com.club.web.store.domain.repository.GoodsBaseLabelRepository;
import com.club.web.store.service.GoodsBaseLabelService;
import com.club.web.store.service.TradeHeadStoreService;
import com.club.web.store.vo.GoodsBaseLabelVo;
import com.club.web.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="goodsBaseLabelService")
public class GoodsBaseLabelServiceImpl
implements GoodsBaseLabelService {
    @Autowired
    GoodsBaseLabelRepository goodsBaseLabelRepository;
    @Autowired
    private TradeHeadStoreService tradeHeadStoreService;

    @Override
    public Page<Map<String, Object>> selectGoodsBaseLabelByLabelName(Page<Map<String, Object>> page, String labelName, String shopYn, HttpServletRequest request) {
        Page<Map<String, Object>> result = new Page<Map<String, Object>>();
        result.setStart(page.getStart());
        result.setLimit(page.getLimit());
        labelName = labelName.isEmpty() ? null : "%" + labelName + "%";
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("Y".equals(shopYn)) {
            Long shopId = this.tradeHeadStoreService.getStaffHeadStoreId(request);
            map.put("shopYn", shopId);
        }
        map.put("labelName", labelName);
        map.put("start", page.getStart());
        map.put("limit", page.getLimit());
        List<GoodsBaseLabelVo> list = this.goodsBaseLabelRepository.selectGoodsBaseLabelByLabelName(map);
        result.setResultList(CommonUtil.listObjTransToListMap(list));
        Long count = this.goodsBaseLabelRepository.queryGoodsBaseLabelCountPage(map);
        result.setTotalRecords(count.intValue());
        return result;
    }

    @Override
    public Map<String, Object> addGoodsBaseLabel(GoodsBaseLabelVo goodsBaseLabelVo, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodsBaseLabelDo goodsBaseLabelDo = this.goodsBaseLabelRepository.voChangeDo(goodsBaseLabelVo);
        if (goodsBaseLabelVo != null && "Y".equals(goodsBaseLabelVo.getShopFlag())) {
            Long shopId = this.tradeHeadStoreService.getStaffHeadStoreId(request);
            goodsBaseLabelDo.setShopId(shopId);
        }
        goodsBaseLabelDo.insert();
        return result;
    }

    @Override
    public Map<String, Object> editGoodsBaseLabel(GoodsBaseLabelVo goodsBaseLabelVo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodsBaseLabelDo goodsBaseLabelDo = this.goodsBaseLabelRepository.voChangeDo(goodsBaseLabelVo);
        if ("Y".equals(goodsBaseLabelVo.getShopFlag())) {
            if (goodsBaseLabelVo.getShopId() == null || goodsBaseLabelVo.getShopId().isEmpty()) {
                result.put("success", false);
                result.put("msg", "\u6807\u7b7e\uff1a" + goodsBaseLabelVo.getLabelName() + ":\u662f\u5e73\u53f0\u7684\u6570\u636e,\u603b\u5e97\u4e0d\u80fd\u4fee\u6539");
            } else {
                result.put("success", true);
                result.put("msg", "\u7f16\u8f91\u5546\u54c1\u6807\u7b7e\u6210\u529f");
                goodsBaseLabelDo.update();
            }
        } else if (goodsBaseLabelVo.getShopId() == null || goodsBaseLabelVo.getShopId().isEmpty()) {
            result.put("success", true);
            result.put("msg", "\u7f16\u8f91\u5546\u54c1\u6807\u7b7e\u6210\u529f");
            goodsBaseLabelDo.update();
        } else {
            result.put("success", false);
            result.put("msg", "\u6807\u7b7e\uff1a" + goodsBaseLabelVo.getLabelName() + ":\u662f\u603b\u5e97\u7684\u6570\u636e,\u5e73\u53f0\u4e0d\u80fd\u4fee\u6539");
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteGoodsBaseLabel(String idStr, String shopFlag) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] ids = idStr.split(",");
        try {
            for (String id : ids) {
                GoodsBaseLabelVo goodsBaseLabelVo = new GoodsBaseLabelVo();
                goodsBaseLabelVo = this.goodsBaseLabelRepository.selectGoodsBaseLabelById(Long.valueOf(id));
                if (goodsBaseLabelVo != null) {
                    if ("Y".equals(shopFlag)) {
                        if (goodsBaseLabelVo.getShopId() == null || goodsBaseLabelVo.getShopId().isEmpty()) {
                            result.put("success", false);
                            result.put("msg", "\u6807\u7b7e\uff1a" + goodsBaseLabelVo.getLabelName() + "\u662f\u5e73\u53f0\u7684\u6570\u636e\uff0c\u603b\u5e97\u4e0d\u80fd\u5220\u9664");
                            return result;
                        }
                        result.put("success", true);
                        result.put("msg", "\u5220\u9664\u5546\u54c1\u6807\u7b7e\u6210\u529f");
                        this.goodsBaseLabelRepository.deleteGoodsBaseLabel(Long.parseLong(id));
                        continue;
                    }
                    if (goodsBaseLabelVo.getShopId() == null || goodsBaseLabelVo.getShopId().isEmpty()) {
                        result.put("success", true);
                        result.put("msg", "\u5220\u9664\u5546\u54c1\u6807\u7b7e\u6210\u529f");
                        this.goodsBaseLabelRepository.deleteGoodsBaseLabel(Long.parseLong(id));
                        continue;
                    }
                    result.put("success", false);
                    result.put("msg", "\u6807\u7b7e\uff1a" + goodsBaseLabelVo.getLabelName() + "\u662f\u603b\u5e97\u7684\u6570\u636e\uff0c\u5e73\u53f0\u4e0d\u80fd\u5220\u9664");
                    return result;
                }
                result.put("success", false);
                result.put("msg", "\u6570\u636e\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> changeStatus(String idStr, String status) {
        String[] ids;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String id : ids = idStr.split(",")) {
            this.goodsBaseLabelRepository.updateStatusById(Long.valueOf(id), status);
        }
        return result;
    }

    @Override
    public List<GoodsBaseLabelVo> selectGoodsBaseLabelListByLabelName(Map<String, Object> page, String labelName, String shopYn, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<GoodsBaseLabelVo> goodsBaseLabelVoLst = new ArrayList();
        if ("Y".equals(shopYn)) {
            Long shopId = this.tradeHeadStoreService.getStaffHeadStoreId(request);
            map.put("shopYn", shopId);
        }
        labelName = labelName.isEmpty() ? null : "%" + labelName + "%";
        map.put("labelName", labelName);
        map.put("start", 0);
        map.put("limit", 9999);
        goodsBaseLabelVoLst = this.goodsBaseLabelRepository.selectGoodsBaseLabelListByLabelName(map);
        return goodsBaseLabelVoLst;
    }

    @Override
    public List<GoodsBaseLabelVo> findListAll() {
        return this.goodsBaseLabelRepository.findListAll();
    }
}

