/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.core.common.Page;
import com.club.web.image.service.ImageService;
import com.club.web.image.service.vo.ImageVo;
import com.club.web.stock.domain.CargoClassifyDo;
import com.club.web.stock.domain.repository.CargoClassifyRepository;
import com.club.web.store.domain.GoodsColumnDo;
import com.club.web.store.domain.RuleValueDo;
import com.club.web.store.domain.repository.GoodsColumnRepository;
import com.club.web.store.domain.repository.RuleSourceRepository;
import com.club.web.store.domain.repository.RuleValueRepository;
import com.club.web.store.listener.GoodsColumnListenerManager;
import com.club.web.store.service.GoodsColumnService;
import com.club.web.store.service.TradeHeadStoreService;
import com.club.web.store.vo.GoodListVo;
import com.club.web.store.vo.GoodsColumnIndexVo;
import com.club.web.store.vo.GoodsColumnVo;
import com.club.web.store.vo.RuleSourceVo;
import com.club.web.util.CommonUtil;
import com.club.web.util.IdGenerator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsColumnService")
public class GoodsColumnServiceImpl
implements GoodsColumnService {
    private Logger logger = LoggerFactory.getLogger(GoodsColumnServiceImpl.class);
    @Autowired
    GoodsColumnRepository goodsColumnRepository;
    @Autowired
    private TradeHeadStoreService tradeHeadStoreService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private RuleSourceRepository ruleSourceRepository;
    @Autowired
    private RuleValueRepository ruleValueRepository;
    @Autowired
    private GoodsColumnListenerManager goodsColumnListenerManager;
    @Autowired
    private CargoClassifyRepository cargoClassifyRepository;

    @Override
    public Page<Map<String, Object>> selectGoodsColumnByColumnName(Page<Map<String, Object>> page, String columnName, String shopYn, HttpServletRequest request) {
        Page<Map<String, Object>> result = new Page<Map<String, Object>>();
        result.setStart(page.getStart());
        result.setLimit(page.getLimit());
        columnName = columnName.isEmpty() ? null : "%" + columnName + "%";
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("Y".equals(shopYn)) {
            Long shopId = this.getShopId(request);
            map.put("shopYn", shopId);
        }
        map.put("columnName", columnName);
        map.put("start", page.getStart());
        map.put("limit", page.getLimit());
        try {
            List<GoodsColumnVo> list = this.goodsColumnRepository.selectGoodsColumnByColumnName(map);
            result.setResultList(CommonUtil.listObjTransToListMap(list));
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5546\u54c1\u680f\u76ee\u5f02\u5e38:", (Throwable)e);
        }
        try {
            Long count = this.goodsColumnRepository.queryGoodsColumnCountPage(map);
            result.setTotalRecords(count.intValue());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5546\u54c1\u680f\u76ee\u7b14\u6570\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> addGoodsColumn(GoodsColumnVo goodsColumnVo, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodsColumnDo goodsColumnDo = this.goodsColumnRepository.voChangeDo(goodsColumnVo);
        String ruleValue = goodsColumnVo.getRuleVal();
        Date ruleStarttime = goodsColumnVo.getRuleStarttime();
        Date ruleEndtime = goodsColumnVo.getRuleEndtime();
        if (goodsColumnVo != null && "Y".equals(goodsColumnVo.getShopFlag())) {
            Long shopId = this.getShopId(request);
            goodsColumnDo.setShopId(shopId);
        }
        if (goodsColumnVo != null && goodsColumnVo.getShowpicture() != null && !"".equals(goodsColumnVo.getShowpicture())) {
            try {
                ImageVo imageVo = this.imageService.saveImage(goodsColumnVo.getShowpicture());
                goodsColumnDo.setShowpicture(imageVo.getId() + "");
            }
            catch (Exception e) {
                this.logger.error("\u65b0\u589e\u56fe\u7247\u5f02\u5e38:", (Throwable)e);
            }
        }
        try {
            RuleValueDo ruleValueDo = new RuleValueDo();
            if (goodsColumnVo.getRuleId() != null && !goodsColumnVo.getRuleId().isEmpty()) {
                ruleValueDo.setRuleVal(ruleValue);
                ruleValueDo.setRuleId(Long.valueOf(goodsColumnVo.getRuleId()));
            }
            if (goodsColumnVo.getRuleId2() != null && !goodsColumnVo.getRuleId2().isEmpty()) {
                ruleValueDo.setRuleStarttime(ruleStarttime);
                ruleValueDo.setRuleEndtime(ruleEndtime);
                ruleValueDo.setRuleId2(Long.valueOf(goodsColumnVo.getRuleId2()));
            }
            ruleValueDo.setId(IdGenerator.getDefault().nextId());
            goodsColumnDo.setRuleSourceId(ruleValueDo.getId());
            this.ruleValueRepository.addRuleValue(ruleValueDo);
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u89c4\u683c\u503c\u5f02\u5e38:", (Throwable)e);
        }
        try {
            result.put("success", true);
            result.put("msg", "\u65b0\u589e\u5546\u54c1\u680f\u76ee\u6210\u529f");
            goodsColumnDo.setStatus(1);
            goodsColumnDo.insert();
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u65b0\u589e\u5546\u54c1\u680f\u76ee\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> editGoodsColumn(GoodsColumnVo goodsColumnVo) {
        ImageVo imageVo;
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodsColumnDo goodsColumnDo = this.goodsColumnRepository.voChangeDo(goodsColumnVo);
        if (goodsColumnVo.getValueId() != null && !goodsColumnVo.getValueId().isEmpty()) {
            try {
                RuleValueDo ruleValueDo = new RuleValueDo();
                ruleValueDo.setId(Long.valueOf(goodsColumnVo.getValueId()));
                if (goodsColumnVo.getRuleId() != null && !goodsColumnVo.getRuleId().isEmpty()) {
                    ruleValueDo.setRuleId(Long.valueOf(goodsColumnVo.getRuleId()));
                    ruleValueDo.setRuleVal(goodsColumnVo.getRuleVal());
                } else {
                    ruleValueDo.setRuleId(null);
                    ruleValueDo.setRuleVal(null);
                }
                if (goodsColumnVo.getRuleId2() != null && !goodsColumnVo.getRuleId2().isEmpty()) {
                    ruleValueDo.setRuleId2(Long.valueOf(goodsColumnVo.getRuleId2()));
                    ruleValueDo.setRuleStarttime(goodsColumnVo.getRuleStarttime());
                    ruleValueDo.setRuleEndtime(goodsColumnVo.getRuleEndtime());
                } else {
                    ruleValueDo.setRuleId2(null);
                    ruleValueDo.setRuleStarttime(null);
                    ruleValueDo.setRuleEndtime(null);
                }
                ruleValueDo.update();
            }
            catch (Exception e) {
                this.logger.error("\u4fee\u6539\u89c4\u683c\u503c\u5f02\u5e38:", (Throwable)e);
            }
        }
        if (goodsColumnVo.getShowpictureId() != null && !goodsColumnVo.getShowpictureId().isEmpty()) {
            try {
                imageVo = new ImageVo();
                imageVo.setId(Long.valueOf(goodsColumnVo.getShowpictureId()));
                imageVo.setPicUrl(goodsColumnVo.getShowpicture());
                this.imageService.updateImage(imageVo);
                goodsColumnDo.setShowpicture(imageVo.getId() + "");
            }
            catch (Exception e) {
                this.logger.error("\u4fee\u6539\u56fe\u7247\u5f02\u5e38:", (Throwable)e);
            }
        } else if (goodsColumnVo.getShowpicture() != null && !"".equals(goodsColumnVo.getShowpicture())) {
            try {
                imageVo = this.imageService.saveImage(goodsColumnVo.getShowpicture());
                goodsColumnDo.setShowpicture(imageVo.getId() + "");
            }
            catch (Exception e) {
                this.logger.error("\u65b0\u589e\u56fe\u7247\u5f02\u5e38:", (Throwable)e);
            }
        }
        try {
            result.put("success", true);
            result.put("msg", "\u7f16\u8f91\u5546\u54c1\u680f\u76ee\u6210\u529f");
            goodsColumnDo.update();
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u7f16\u8f91\u5546\u54c1\u680f\u76ee\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> deleteGoodsColumn(String idStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] ids = idStr.split(",");
        try {
            for (String id : ids) {
                String[] idSplit = id.split(";");
                try {
                    boolean flg = this.goodsColumnListenerManager.deleteGoodsColumn(Long.parseLong(idSplit[0]));
                    if (!flg) {
                        result.put("success", false);
                        result.put("msg", "\u5546\u54c1\u680f\u76ee\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
                        return result;
                    }
                    result.put("success", true);
                    result.put("msg", "\u5220\u9664\u5546\u54c1\u680f\u76ee\u6210\u529f");
                    this.goodsColumnRepository.deleteGoodsColumn(Long.parseLong(idSplit[0]));
                }
                catch (Exception e) {
                    result.put("success", false);
                    result.put("msg", e.getMessage());
                    this.logger.error("\u5220\u9664\u5546\u54c1\u680f\u76ee\u5f02\u5e38:", (Throwable)e);
                }
                if (idSplit[1] == null) continue;
                try {
                    this.ruleValueRepository.deleteRuleValue(Long.parseLong(idSplit[1]));
                }
                catch (Exception e) {
                    result.put("success", false);
                    result.put("msg", e.getMessage());
                    this.logger.error("\u5220\u9664\u89c4\u5219\u503c\u5f02\u5e38:", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @Override
    public Map<String, Object> updateStatusForGoodsColumnById(String idStr, String status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] ids = idStr.split(",");
        try {
            result.put("success", true);
            result.put("msg", "\u4fee\u6539\u72b6\u6001\u6210\u529f");
            for (String id : ids) {
                this.goodsColumnRepository.updateStatusForGoodsColumnById(Long.valueOf(id), status);
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u4fee\u6539\u72b6\u6001\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<GoodsColumnVo> selectGoodsColumnListByShopId(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<GoodsColumnVo> goodsColumnVoLst = new ArrayList();
        Long shopId = this.getShopId(request);
        map.put("shopYn", shopId);
        map.put("start", 0);
        map.put("limit", 9999);
        try {
            goodsColumnVoLst = this.goodsColumnRepository.selectGoodsColumnByColumnName(map);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u5e97\u94fa\u67e5\u8be2\u5546\u54c1\u680f\u76ee\u5f02\u5e38:", (Throwable)e);
        }
        return goodsColumnVoLst;
    }

    @Override
    public List<RuleSourceVo> selectRuleSourceList(int ruleType) {
        ArrayList<RuleSourceVo> ruleSourceVoLst = new ArrayList();
        try {
            ruleSourceVoLst = this.ruleSourceRepository.selectRuleSourceList(ruleType);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u89c4\u5219\u6765\u6e90\u5f02\u5e38:", (Throwable)e);
        }
        return ruleSourceVoLst;
    }

    public Long getShopId(HttpServletRequest request) {
        Long shopId = null;
        try {
            shopId = this.tradeHeadStoreService.getStaffHeadStoreId(request);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5546\u54c1\u680f\u76ee\u7b14\u6570\u5f02\u5e38:", (Throwable)e);
        }
        return shopId;
    }

    @Override
    public List<Map<String, Object>> getGoodsAndCloumn(Long shopId) throws SQLException {
        ArrayList<Map<String, Object>> columnList = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        CargoClassifyDo cargoClassifyDo = this.cargoClassifyRepository.findDoByIdAndStatus(1L, null);
        if (cargoClassifyDo != null) {
            map.put("classifyIds", cargoClassifyDo.getAllIds(1));
        }
        List<GoodListVo> goodList = this.goodsColumnRepository.selectColumnAllGoods(map);
        columnList = this.getColumnsGoodList(goodList);
        return columnList;
    }

    @Override
    public Map<String, Object> selectGoodsByColumnId(Long columnsId, int start, int limit) {
        HashMap<String, Object> tradegoodInfo = new HashMap<String, Object>();
        HashMap<String, Object> columnInfo = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> tradegoodList = new ArrayList<HashMap<String, Object>>();
        String columnName = "";
        String columnId = "";
        String columnPicture = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        CargoClassifyDo cargoClassifyDo = this.cargoClassifyRepository.findDoByIdAndStatus(1L, null);
        if (cargoClassifyDo != null) {
            map.put("classifyIds", cargoClassifyDo.getAllIds(1));
        }
        map.put("columnId", columnsId);
        map.put("start", start * limit);
        map.put("limit", limit);
        List<GoodListVo> goodList = this.goodsColumnRepository.selectGoodsByColumnId(map);
        if (goodList != null && goodList.size() > 0) {
            columnName = goodList.get(0).getColumnName();
            columnId = goodList.get(0).getColumnId();
            columnPicture = goodList.get(0).getColumnPicture();
        }
        for (GoodListVo good : goodList) {
            tradegoodInfo = new HashMap();
            tradegoodInfo.put("id", good.getId());
            tradegoodInfo.put("name", good.getName());
            tradegoodInfo.put("showPicture", good.getShowPicture());
            tradegoodInfo.put("score", good.getScore());
            tradegoodInfo.put("marketPrice", good.getMarketPrice());
            tradegoodInfo.put("salePrice", good.getSalePrice());
            tradegoodInfo.put("imgSquare", good.getImgSquare());
            tradegoodInfo.put("imgRectangle", good.getImgRectangle());
            tradegoodInfo.put("imgLarge", good.getImgLarge());
            tradegoodInfo.put("saleNum", good.getSaleNum());
            tradegoodList.add(tradegoodInfo);
        }
        columnInfo.put("columnName", columnName);
        columnInfo.put("columnId", columnId);
        columnInfo.put("columnPicture", columnPicture);
        columnInfo.put("goodsList", tradegoodList);
        return columnInfo;
    }

    @Override
    public List<Map<String, Object>> selectColumnsGood() {
        ArrayList<Map<String, Object>> columnList = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        CargoClassifyDo cargoClassifyDo = this.cargoClassifyRepository.findDoByIdAndStatus(1L, null);
        if (cargoClassifyDo != null) {
            map.put("classifyIds", cargoClassifyDo.getAllIds(1));
        }
        List<GoodListVo> goodList = this.goodsColumnRepository.selectColumnsGood(map);
        columnList = this.getColumnsGoodList(goodList);
        return columnList;
    }

    public List<Map<String, Object>> getColumnsGoodList(List<GoodListVo> goodList) {
        ArrayList<Map<String, Object>> columnList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> tradegoodInfo = new HashMap<String, Object>();
        Map columnInfo = new HashMap<String, String>();
        HashMap columnInfoMap = new HashMap();
        List<HashMap<String, Object>> tradegoodList = new ArrayList();
        String columnName = "";
        String columnId = "";
        String columnPicture = "";
        if (goodList != null && goodList.size() > 0) {
            columnName = goodList.get(0).getColumnName();
        }
        for (GoodListVo good : goodList) {
            tradegoodInfo = new HashMap();
            columnInfo = new HashMap();
            tradegoodList = new ArrayList();
            columnName = good.getColumnName();
            columnId = good.getColumnId();
            columnPicture = good.getColumnPicture();
            tradegoodInfo.put("id", good.getId());
            tradegoodInfo.put("name", good.getName());
            tradegoodInfo.put("showPicture", good.getShowPicture());
            tradegoodInfo.put("score", good.getScore());
            tradegoodInfo.put("marketPrice", good.getMarketPrice());
            tradegoodInfo.put("salePrice", good.getSalePrice());
            tradegoodInfo.put("imgSquare", good.getImgSquare());
            tradegoodInfo.put("imgRectangle", good.getImgRectangle());
            tradegoodInfo.put("imgLarge", good.getImgLarge());
            tradegoodInfo.put("saleNum", good.getSaleNum());
            if (columnInfoMap.containsKey(columnName)) {
                columnInfo = (Map)columnInfoMap.get(good.getColumnName());
                tradegoodList = (List)columnInfo.get("goodsList");
            } else {
                columnInfo.put("columnName", columnName);
                columnInfo.put("columnId", columnId);
                columnInfo.put("columnPicture", columnPicture);
            }
            tradegoodList.add(tradegoodInfo);
            columnInfo.put("goodsList", tradegoodList);
            columnInfoMap.put(columnName, columnInfo);
        }
        for (String key : columnInfoMap.keySet()) {
            columnList.add((Map<String, Object>)columnInfoMap.get(key));
        }
        return columnList;
    }

    @Override
    public Map<String, Object> goodsColumnService() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<GoodsColumnIndexVo> norule = this.goodsColumnRepository.selectNoRuleGoodsColumn();
        List<GoodsColumnIndexVo> rule = this.goodsColumnRepository.selectRuleGoodsColumn();
        result.put("norule", norule);
        result.put("rule", rule);
        return result;
    }

    @Override
    public Map<String, Object> goodsColumnList(Integer limit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("data", this.goodsColumnRepository.selectAllGoodsColumn(limit));
        result.put("msg", "\u6210\u529f");
        return result;
    }
}

