/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.core.common.Page;
import com.club.framework.util.BeanUtils;
import com.club.web.store.domain.GoodsThemeDo;
import com.club.web.store.domain.repository.GoodsThemeRepository;
import com.club.web.store.service.GoodsThemeService;
import com.club.web.store.vo.GoodsThemeVo;
import com.club.web.util.CommonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsThemeService")
public class GoodsThemeServiceImpl
implements GoodsThemeService {
    private Logger logger = LoggerFactory.getLogger(GoodsThemeServiceImpl.class);
    @Autowired
    GoodsThemeRepository goodsThemeRepository;

    @Override
    public Page<Map<String, Object>> selectGoodsThemeByThemeName(Page<Map<String, Object>> page, String ThemeName, String status, HttpServletRequest request) {
        Page<Map<String, Object>> result = new Page<Map<String, Object>>();
        result.setStart(page.getStart());
        result.setLimit(page.getLimit());
        ThemeName = ThemeName.isEmpty() ? null : "%" + ThemeName + "%";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ThemeName", ThemeName);
        map.put("status", status);
        map.put("start", page.getStart());
        map.put("limit", page.getLimit());
        try {
            List<GoodsThemeVo> list = this.goodsThemeRepository.selectGoodsThemeByThemeName(map);
            result.setResultList(CommonUtil.listObjTransToListMap(list));
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5546\u54c1\u680f\u76ee\u5f02\u5e38:", (Throwable)e);
        }
        try {
            Long count = this.goodsThemeRepository.queryGoodsThemeCountPage(map);
            result.setTotalRecords(count.intValue());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5546\u54c1\u680f\u76ee\u7b14\u6570\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> addGoodsTheme(GoodsThemeVo goodsThemeVo, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodsThemeDo goodsThemeDo = new GoodsThemeDo();
        BeanUtils.copyProperties(goodsThemeVo, goodsThemeDo);
        try {
            result.put("success", true);
            result.put("msg", "\u65b0\u589e\u5546\u54c1\u680f\u76ee\u6210\u529f");
            goodsThemeDo.setStatus(1);
            goodsThemeDo.insert();
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u65b0\u589e\u5546\u54c1\u680f\u76ee\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> editGoodsTheme(GoodsThemeVo goodsThemeVo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GoodsThemeDo goodsThemeDo = this.goodsThemeRepository.voChangeDo(goodsThemeVo);
        try {
            result.put("success", true);
            result.put("msg", "\u7f16\u8f91\u5546\u54c1\u680f\u76ee\u6210\u529f");
            goodsThemeDo.update();
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u7f16\u8f91\u5546\u54c1\u680f\u76ee\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> deleteGoodsTheme(String idStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] ids = idStr.split(",");
        try {
            for (String id : ids) {
                String[] idSplit = id.split(";");
                try {
                    boolean flg = true;
                    if (!flg) {
                        result.put("success", false);
                        result.put("msg", "\u5546\u54c1\u680f\u76ee\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
                        return result;
                    }
                    result.put("success", true);
                    result.put("msg", "\u5220\u9664\u5546\u54c1\u680f\u76ee\u6210\u529f");
                    this.goodsThemeRepository.deleteGoodsTheme(Long.parseLong(idSplit[0]));
                }
                catch (Exception e) {
                    result.put("success", false);
                    result.put("msg", e.getMessage());
                    this.logger.error("\u5220\u9664\u5546\u54c1\u680f\u76ee\u5f02\u5e38:", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @Override
    public Map<String, Object> updateStatusForGoodsThemeById(String idStr, String status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] ids = idStr.split(",");
        try {
            result.put("success", true);
            result.put("msg", "\u4fee\u6539\u72b6\u6001\u6210\u529f");
            for (String id : ids) {
                this.goodsThemeRepository.updateStatusForGoodsThemeById(Long.valueOf(id), status);
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u4fee\u6539\u72b6\u6001\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> selectGoodsThemeForMobileIndex(Integer limit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u6210\u529f");
        result.put("data", this.goodsThemeRepository.selectGoodsThemeListForIndex(limit));
        return result;
    }
}

