/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.framework.util.StringUtils;
import com.club.web.store.domain.MsgPushLogWithBLOBsDo;
import com.club.web.store.domain.repository.MsgPushRepository;
import com.club.web.store.service.PushMessageService;
import com.club.web.store.vo.MsgPushLogVo;
import com.club.web.store.vo.PushMsgVo;
import com.club.web.util.IdGenerator;
import com.club.web.util.SmsUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushMessageServiceImpl
implements PushMessageService {
    private Logger logger = LoggerFactory.getLogger(PushMessageServiceImpl.class);
    private Map<String, Object> result;
    @Autowired
    SmsUtil msgPush;
    @Autowired
    MsgPushRepository repository;

    @Override
    public Map<String, Object> pushMsgSer(PushMsgVo pushObj) throws Exception {
        this.result = new HashMap<String, Object>();
        MsgPushLogWithBLOBsDo obj = null;
        if (pushObj != null) {
            if (StringUtils.isNotEmpty(pushObj.getContent())) {
                if (StringUtils.isNotEmpty(pushObj.getPushType())) {
                    if (StringUtils.isNotEmpty(pushObj.getMsgType())) {
                        String customerOrder = String.valueOf(IdGenerator.getDefault().nextId());
                        this.result = this.msgPush.pushMsgUtil(pushObj, customerOrder);
                        if (this.result != null) {
                            try {
                                obj = this.repository.createCarouseObj(this.result, pushObj, customerOrder);
                                if (obj != null) {
                                    obj.save();
                                }
                            }
                            catch (Exception e) {
                                this.logger.error("\u6d88\u606f\u63a8\u9001\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25:", (Throwable)e);
                            }
                        }
                    } else {
                        this.result.put("code", "000001");
                        this.result.put("msg", "\u6d88\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                } else {
                    this.result.put("code", "000001");
                    this.result.put("msg", "\u63a8\u9001\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u63a8\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> getMsgPushStatus(PushMsgVo pushObj) throws Exception {
        this.result = new HashMap<String, Object>();
        if (pushObj != null) {
            if (StringUtils.isNotEmpty(pushObj.getMsgId())) {
                this.result = this.msgPush.getMsgPushStatus(pushObj);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u6d88\u606fId\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public List<MsgPushLogVo> getMsgPushListSer(String userId, String deviceType, int pageSize, int pageNum) {
        List<MsgPushLogVo> list = null;
        int user = 0;
        if (StringUtils.isNotEmpty(userId)) {
            if (pageSize < 1) {
                pageSize = 6;
            }
            if (pageNum < 1) {
                pageNum = 1;
            }
            user = Integer.valueOf(userId);
            list = this.repository.getMsgPushList(user, deviceType, (pageNum - 1) * pageSize, pageSize);
        }
        return list;
    }
}

