/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.framework.util.StringUtils;
import com.club.web.stock.domain.repository.StockManagerRepository;
import com.club.web.stock.vo.CargoSkuItemVo;
import com.club.web.store.domain.ShoppingCartDo;
import com.club.web.store.domain.repository.ShoppingCartRepository;
import com.club.web.store.service.ShoppingCartService;
import com.club.web.store.vo.ShoppingCartVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShoppingCartServiceImpl
implements ShoppingCartService {
    private Logger logger = LoggerFactory.getLogger(ShoppingCartServiceImpl.class);
    @Autowired
    ShoppingCartRepository repository;
    @Autowired
    StockManagerRepository stockRepository;
    private Map<String, Object> result;

    @Override
    public List<ShoppingCartVo> queryShoppingCartByUserId(long userId, int optionType) {
        List<ShoppingCartVo> list = this.repository.queryShoppingCartByUserId(userId, optionType);
        if (0 == optionType) {
            this.setCargoSkuSpecList(list);
        }
        return list;
    }

    @Override
    public List<ShoppingCartVo> queryShoppingCartByUserId(long userId, long shopId, int optionType) {
        List<ShoppingCartVo> list = this.repository.queryShoppingCartByUserId(userId, shopId, optionType);
        if (0 == optionType) {
            this.setCargoSkuSpecList(list);
        }
        return list;
    }

    @Override
    public List<ShoppingCartVo> queryQurShoppingCartByUserId(long userId, long shopId, int optionType) {
        List<ShoppingCartVo> list = this.repository.queryQurShoppingCartByUserId(userId, shopId, optionType);
        if (0 == optionType) {
            this.setCargoSkuSpecList(list);
        }
        return list;
    }

    private <T> void setCargoSkuSpecList(List<T> t) {
        List<CargoSkuItemVo> list = null;
        if (t != null && t.stream().count() > 0L) {
            for (T vo : t) {
                try {
                    ShoppingCartVo cart;
                    if (!(vo instanceof ShoppingCartVo) || (list = this.stockRepository.queryGoodsSpecList((cart = (ShoppingCartVo)vo).getSkuId())) == null || list.size() <= 0) continue;
                    StringBuffer str = new StringBuffer();
                    int i = 0;
                    while ((long)i < list.stream().count()) {
                        str.append(list.get(i).getType() + ":" + list.get(i).getSkuName());
                        if ((long)i != list.stream().count() - 1L) {
                            str.append(",");
                        }
                        ++i;
                    }
                    cart.setSkuItem(str.toString());
                }
                catch (Exception e) {
                    this.logger.error("\u8bbe\u7f6e\u5bf9\u8c61\u7684\u89c4\u683c\u503c\u5f02\u5e38<setCargoSkuSpecList>:", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Map<String, Object> addShoppingCartByUserId(long userId, String goodsId, String shopId, int count, double prize, int optionType, int status) throws Exception {
        this.result = new HashMap<String, Object>();
        ShoppingCartDo cart = null;
        long goodId = 0L;
        long storeId = 0L;
        if (StringUtils.isNotEmpty(goodsId)) {
            if (StringUtils.isNotEmpty(shopId)) {
                storeId = Long.valueOf(shopId);
            }
            goodId = Long.valueOf(goodsId);
            if (count <= 0) {
                count = 1;
            }
            if ((cart = this.repository.createShoppingCartObj(userId, goodId, storeId, count, prize, optionType, status)) != null) {
                if (cart.getFlag() == 1) {
                    cart.save();
                } else {
                    cart.update(count, 0);
                }
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u5bf9\u8c61\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u6dfb\u52a0\u5546\u54c1id\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> updateShoppingCartGoodsCount(long userId, String goodsId, String shopId, int count, int status, int optionType, int type) throws Exception {
        this.result = new HashMap<String, Object>();
        ShoppingCartDo cart = null;
        long goodId = Long.valueOf(goodsId);
        long storeId = Long.valueOf(shopId);
        if (count > 0) {
            cart = this.repository.queryCartObjByCondition(userId, goodId, storeId, optionType, type);
            if (cart != null) {
                cart.update(count, status);
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u4fee\u6539\u6570\u91cf\u8981\u5927\u4e8e0");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> deleteShoppingCartGoods(long userId, String goodsIds, String shopId, int optionType, int status) {
        String[] arr;
        this.result = new HashMap<String, Object>();
        ArrayList<Long> listIds = null;
        long storeId = 0L;
        if (StringUtils.isNotEmpty(goodsIds) && (arr = goodsIds.split(",")) != null && arr.length > 0) {
            listIds = new ArrayList<Long>();
            for (String str : arr) {
                listIds.add(Long.valueOf(str));
            }
        }
        if (StringUtils.isNotEmpty(shopId)) {
            storeId = Long.valueOf(shopId);
        }
        if (listIds != null && listIds.stream().count() > 0L) {
            this.repository.deleteShoppingCartGoods(userId, listIds, storeId, optionType, status);
            this.result.put("code", "000000");
            this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public int getCartCountSer(long userId, long shopId, int optionType) {
        int count = this.repository.getCartCount(userId, shopId, optionType);
        return count;
    }
}

