/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.core.common.Page;
import com.club.web.common.db.po.StaffT;
import com.club.web.store.dao.extend.StoreLevelExtendMapper;
import com.club.web.store.domain.StoreLevelDo;
import com.club.web.store.domain.repository.StoreLevelRepository;
import com.club.web.store.domain.repository.TradeHeadStoreRepository;
import com.club.web.store.service.StoreLevelService;
import com.club.web.store.vo.StoreLevelVo;
import com.club.web.util.IdGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="StoreLevelService")
@Transactional
public class StoreLevelServiceImpl
implements StoreLevelService {
    private Logger logger = LoggerFactory.getLogger(StoreLevelServiceImpl.class);
    @Autowired
    private StoreLevelRepository storeLevelRepository;
    @Autowired
    private TradeHeadStoreRepository tradeHeadStoreRepository;
    @Autowired
    private StoreLevelExtendMapper storeLevelExtendMapper;

    @Override
    public Map<String, Object> saveOrUpdateStoreLevel(StoreLevelVo storeLevelVo, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (storeLevelVo != null) {
            if (null == storeLevelVo.getName() || "".equals(storeLevelVo.getName())) {
                result.put("success", false);
                result.put("msg", "\u8bf7\u8f93\u5165\u5e97\u94fa\u7b49\u7ea7\u540d\u79f0");
                return result;
            }
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            List<StoreLevelVo> storeLevelByName = this.storeLevelRepository.queryStoreLevelByName(storeLevelVo.getName());
            int count = storeLevelByName.size();
            if (storeLevelVo.getLevelId() == null || "".equals(storeLevelVo.getLevelId())) {
                if (count > 0) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u5e97\u94fa\u7b49\u7ea7\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
                    return result;
                }
                storeLevelVo.setLevelId(IdGenerator.getDefault().nextId() + "");
                storeLevelVo.setCreateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    storeLevelVo.setCreateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                storeLevelVo.setUpdateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    storeLevelVo.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                storeLevelVo.setStatue(1L);
                StoreLevelDo storeLevelDo = this.storeLevelRepository.create(storeLevelVo);
                storeLevelDo.insert();
            } else {
                StoreLevelDo storeLevelDo = this.storeLevelRepository.getStoreLevelDoByLevelId(Long.parseLong(storeLevelVo.getLevelId()));
                if (count > 0 && !storeLevelDo.getName().equalsIgnoreCase(storeLevelVo.getName())) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u5e97\u94fa\u7b49\u7ea7\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
                    return result;
                }
                storeLevelDo.setName(storeLevelVo.getName());
                storeLevelDo.setStorePro(storeLevelVo.getStorePro());
                storeLevelDo.setUpdateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    storeLevelDo.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                storeLevelDo.update();
            }
            result.put("success", true);
        } else {
            result.put("success", false);
            result.put("msg", "\u5e97\u94fa\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @Override
    public Page<Map<String, Object>> queryStoreLevelPage(Page<Map<String, Object>> page, HttpServletRequest request) {
        Page<Map<String, Object>> result = new Page<Map<String, Object>>();
        result.setStart(page.getStart());
        result.setLimit(page.getLimit());
        List<Map<String, Object>> list = this.storeLevelRepository.queryStoreLevelPage(page, request);
        Long count = this.storeLevelRepository.queryStoreLevelCountPage(page, request);
        result.setResultList(list);
        result.setTotalRecords(count.intValue());
        return result;
    }

    @Override
    public Map<String, Object> updateStoreLevelStatue(String idStr, Long statue, HttpServletRequest request) {
        String[] Ids = idStr.split(",");
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        for (String id : Ids) {
            StoreLevelDo storeLevelDo = this.storeLevelRepository.getStoreLevelDoById(Long.parseLong(id));
            storeLevelDo.setStatue(statue);
            storeLevelDo.setUpdateTime(new Date());
            if (loginMap != null && loginMap.get("staffId") != null) {
                storeLevelDo.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
            }
            storeLevelDo.update();
        }
        result.put("success", true);
        return result;
    }

    @Override
    public Map<String, Object> deleteStoreLevel(String idStr) {
        String[] Ids = idStr.split(",");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String id : Ids) {
            this.storeLevelRepository.deleteByPrimaryKey(Long.parseLong(id));
        }
        result.put("success", true);
        return result;
    }

    @Override
    public List<StoreLevelVo> findAllStoreLevel(HttpServletRequest request) {
        List<StoreLevelVo> levelVoList = null;
        levelVoList = this.storeLevelRepository.findAllStoreLevel(request);
        return levelVoList;
    }

    @Override
    public StaffT subbranchLogin(String mobile) {
        return this.storeLevelExtendMapper.subbranchLogin(mobile);
    }
}

