/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.web.store.service.StoreData;
import com.club.web.store.service.StoreService;
import com.club.web.store.vo.ClassifyVO;
import com.club.web.store.vo.CommentVO;
import com.club.web.store.vo.DiscountGoodsVO;
import com.club.web.store.vo.GoodsCommentVO;
import com.club.web.store.vo.GoodsDetailVO;
import com.club.web.store.vo.GoodsSimpleVO;
import com.club.web.store.vo.OrderSimpleVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"classpath:/config/qrcode.properties"})
public class StoreServiceImpl
implements StoreService {
    public static final int RECOMMEND_GOODS_COUNT = 2;
    public static final int HOT_GOODS_COUNT = 2;
    public static final int DISCOUNT_GOODS_COUNT = 3;
    public static final int PAGE_SIZE = 4;
    @Value(value="${index_path}")
    private String indexPath;

    @Override
    public List<ClassifyVO> getClassifyList() {
        ArrayList<ClassifyVO> result = new ArrayList<ClassifyVO>();
        int i = 0;
        for (ClassifyVO classifyVO : StoreData.classifyMap.values()) {
            if (i++ >= 8) break;
            result.add(classifyVO);
        }
        return result;
    }

    @Override
    public DiscountGoodsVO getDiscountGoods() {
        if (StoreData.discountEndTime.getTime() < System.currentTimeMillis()) {
            StoreData.discountEndTime = new Date(System.currentTimeMillis() + (long)(Math.random() * 30.0 * 60.0 * 1000.0) + 3600000L);
        }
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(StoreData.discountEndTime);
        Collection<GoodsDetailVO> goodscollections = StoreData.goodsMap.values();
        ArrayList<GoodsSimpleVO> list = new ArrayList<GoodsSimpleVO>();
        for (GoodsDetailVO gdvo : goodscollections) {
            if (gdvo.isDiscountGoods()) {
                list.add(gdvo.getSimpleData());
            }
            if (list.size() < 3) continue;
            break;
        }
        DiscountGoodsVO dgvo = new DiscountGoodsVO(time, list);
        return dgvo;
    }

    @Override
    public List<GoodsSimpleVO> getRecommendGoods() {
        Collection<GoodsDetailVO> goodscollections = StoreData.goodsMap.values();
        ArrayList<GoodsSimpleVO> list = new ArrayList<GoodsSimpleVO>();
        for (GoodsDetailVO gdvo : goodscollections) {
            if (gdvo.isRecommend()) {
                list.add(gdvo.getSimpleData());
            }
            if (list.size() < 2) continue;
            break;
        }
        return list;
    }

    @Override
    public List<GoodsSimpleVO> getHotGoods() {
        Collection<GoodsDetailVO> goodscollections = StoreData.goodsMap.values();
        ArrayList<GoodsSimpleVO> list = new ArrayList<GoodsSimpleVO>();
        for (GoodsDetailVO gdvo : goodscollections) {
            if (gdvo.isHot()) {
                list.add(gdvo.getSimpleData());
            }
            if (list.size() < 2) continue;
            break;
        }
        return list;
    }

    @Override
    public List<GoodsSimpleVO> getGoodsList(long classifyid, int page) {
        int index = 0;
        int pageStart = (page - 1) * 4;
        Collection<GoodsDetailVO> goodscollections = StoreData.goodsMap.values();
        ArrayList<GoodsSimpleVO> list = new ArrayList<GoodsSimpleVO>();
        for (GoodsDetailVO gdvo : goodscollections) {
            if (gdvo == null || classifyid != 0L && gdvo.getClassify().getClassifyId() != classifyid) continue;
            if (index++ >= pageStart) {
                list.add(gdvo.getSimpleData());
            }
            if (list.size() < 4) continue;
            break;
        }
        return list;
    }

    @Override
    public GoodsDetailVO getGoodsInfo(long goodsId) {
        return StoreData.goodsMap.get(goodsId);
    }

    @Override
    public List<OrderSimpleVO> getOrders(int orderStatus, int page) {
        int index = 0;
        int pageStart = (page - 1) * 4;
        Collection<OrderSimpleVO> ordercollections = StoreData.orderMap.values();
        ArrayList<OrderSimpleVO> list = new ArrayList<OrderSimpleVO>();
        for (OrderSimpleVO osvo : ordercollections) {
            if (osvo == null || orderStatus != 0 && osvo.getStatusCode() != orderStatus) continue;
            if (index++ >= pageStart) {
                list.add(osvo);
            }
            if (list.size() < 4) continue;
            break;
        }
        return list;
    }

    @Override
    public String getQrCode(String phone) {
        return this.indexPath + "?phone=" + phone;
    }

    @Override
    public GoodsCommentVO getComment(long goodsId) {
        GoodsCommentVO vo = new GoodsCommentVO();
        ArrayList<CommentVO> list = StoreData.commentList;
        for (CommentVO cvo : list) {
            cvo.setGoodsId(goodsId);
        }
        vo.setList(list);
        vo.setRate(StoreData.goodsMap.get(goodsId).getRate());
        return vo;
    }
}

