/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.core.common.Page;
import com.club.framework.util.StringUtils;
import com.club.web.image.service.ImageService;
import com.club.web.image.service.vo.ImageVo;
import com.club.web.stock.domain.repository.CargoClassifyRepository;
import com.club.web.store.domain.ShopThemeManagerDo;
import com.club.web.store.domain.repository.ThemeManagerRepository;
import com.club.web.store.service.ThemeManagerService;
import com.club.web.store.vo.ShopThemeExtendVo;
import com.club.web.store.vo.ShopThemeManagerVo;
import com.club.web.util.CommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThemeManagerServiceImpl
implements ThemeManagerService {
    private Logger logger = LoggerFactory.getLogger(ThemeManagerServiceImpl.class);
    @Autowired
    ThemeManagerRepository repository;
    @Autowired
    private CargoClassifyRepository cargoClassifyRepository;
    @Autowired
    ImageService image;
    private Map<String, Object> result;

    @Override
    public Page<Map<String, Object>> queryThemeListSer(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        List<ShopThemeManagerVo> list = null;
        List<Map<String, Object>> listMap = null;
        int total = 0;
        int status = -1;
        String matchParam = StringUtils.EMPTY;
        try {
            if (page != null) {
                startIndex = page.getStart();
                pageSize = page.getLimit();
                Map<String, Object> con = page.getConditons();
                if (con != null) {
                    if (con.containsKey("status")) {
                        int n = status = con.get("status") != null ? Integer.valueOf(con.get("status").toString()) : 0;
                    }
                    if (con.containsKey("matchParam")) {
                        matchParam = con.get("matchParam") != null ? con.get("matchParam").toString() : StringUtils.EMPTY;
                    }
                }
                total = this.repository.queryThemeListTotal(status, matchParam);
                page.setTotalRecords(total);
                if (total > 0 && (list = this.repository.queryThemeList(status, matchParam, startIndex, pageSize)) != null && list.stream().count() > 0L) {
                    this.packThemeData(list);
                    listMap = CommonUtil.listObjTransToListMap(list);
                    page.setResultList(listMap);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u53c2\u6570\u67e5\u8be2\u4e3b\u9898\u5217\u8868\u4fe1\u606f\u5f02\u5e38<queryThemeListSer>:", (Throwable)e);
        }
        return page;
    }

    private void packThemeData(List<ShopThemeManagerVo> listMap) {
        if (listMap != null && listMap.stream().count() > 0L) {
            for (ShopThemeManagerVo obj : listMap) {
                String[] arr;
                StringBuilder classifyName = new StringBuilder("");
                String ids = obj.getClassifyId();
                if (StringUtils.isNotEmpty(ids) && (arr = ids.split(",")) != null && arr.length > 0) {
                    for (int i = 0; i < arr.length; ++i) {
                        String name = this.cargoClassifyRepository.queryNameById(Long.valueOf(arr[i].trim()));
                        if (!StringUtils.isNotEmpty(name)) continue;
                        classifyName.append(name + "");
                        if (i == arr.length - 1) continue;
                        classifyName.append(",");
                    }
                }
                obj.setClassify(classifyName.toString());
            }
        }
    }

    @Override
    public Map<String, Object> saveThemeMsgSer(Map<String, Object> param) throws Exception {
        this.result = new HashMap<String, Object>();
        ShopThemeManagerDo theme = null;
        ImageVo imgObj = null;
        if (param != null) {
            theme = this.repository.createThemeObj(param);
            if (theme != null) {
                if (theme.getFlag() == 0) {
                    imgObj = this.image.saveImage(theme.getTitlePicUrl());
                    theme.setTitlePicUrl(String.valueOf(imgObj.getId()));
                    theme.save();
                } else {
                    if (StringUtils.isNotEmpty(theme.getExtendId())) {
                        imgObj = new ImageVo();
                        imgObj.setId(Long.valueOf(theme.getExtendId()));
                        imgObj.setPicUrl(theme.getTitlePicUrl());
                        this.image.updateImage(imgObj);
                        theme.setTitlePicUrl(String.valueOf(imgObj.getId()));
                    }
                    theme.update();
                }
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> delThemeSer(Map<String, Object> paramMap) {
        this.result = new HashMap<String, Object>();
        ArrayList<Long> ids = null;
        String id = StringUtils.EMPTY;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = id = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (StringUtils.isNotEmpty(id) && (arr = id.split(",")) != null && arr.length > 0) {
                ids = new ArrayList<Long>();
                for (String str : arr) {
                    ids.add(Long.valueOf(str));
                }
            }
            if (ids != null && ids.stream().count() > 0L) {
                this.repository.delTheme((List<Long>)ids);
                this.result.put("code", "000000");
                this.result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            } else {
                this.result.put("code", "000003");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public Map<String, Object> updateThemeStatusSer(Map<String, Object> paramMap) throws Exception {
        this.result = new HashMap<String, Object>();
        int status = -1;
        ShopThemeManagerDo theme = null;
        String ids = StringUtils.EMPTY;
        ArrayList<Long> listId = null;
        if (paramMap != null) {
            String[] arr;
            if (paramMap.containsKey("ids")) {
                String string = ids = paramMap.get("ids") != null ? paramMap.get("ids").toString() : StringUtils.EMPTY;
            }
            if (paramMap.containsKey("status")) {
                int n = status = paramMap.get("status") != null ? Integer.valueOf(paramMap.get("status").toString()) : -1;
            }
            if (StringUtils.isNotEmpty(ids) && (arr = ids.split(",")) != null && arr.length > 0) {
                listId = new ArrayList<Long>();
                for (String str : arr) {
                    listId.add(Long.valueOf(str));
                }
            }
            if (listId != null && listId.stream().count() > 0L) {
                Iterator iterator = listId.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    theme = this.repository.queryThemeById(id);
                    theme.setStatus(status);
                    theme.setCreateTime(new Date());
                    theme.update();
                }
                this.result.put("code", "000000");
                this.result.put("msg", "\u4fee\u6539\u6210\u529f\uff01");
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        } else {
            this.result.put("code", "000001");
            this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.result;
    }

    @Override
    public List<ShopThemeManagerVo> queryStartThemeSer() {
        List<ShopThemeManagerVo> list = this.repository.queryStartTheme(1);
        return list;
    }

    @Override
    public List<ShopThemeExtendVo> queryPrevThemeSer() {
        List<ShopThemeExtendVo> list = this.repository.queryPrevTheme();
        return list;
    }
}

