/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.framework.util.StringUtils;
import com.club.web.store.constant.TimeCycleType;
import com.club.web.store.dao.extend.TimeCycleExtendMapper;
import com.club.web.store.domain.TimeCycleDo;
import com.club.web.store.service.TimeCycleService;
import com.club.web.store.vo.TimeCycleVo;
import com.club.web.util.IdGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeCycleServiceImpl
implements TimeCycleService {
    @Autowired
    private TimeCycleExtendMapper timeCycleDao;

    @Override
    public Map<String, Object> saveOrUpdate(TimeCycleVo timeCycle) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty(timeCycle.getDuration())) {
            result.put("success", false);
            result.put("msg", "\u8bf7\u8f93\u5165\u6570\u503c\uff01");
            return result;
        }
        if (!StringUtils.isNumeric(timeCycle.getDuration())) {
            result.put("success", false);
            result.put("msg", "\u5468\u671f\u65f6\u957f\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
            return result;
        }
        timeCycle.setUpdateTime(new Date());
        if (StringUtils.isEmpty(timeCycle.getId())) {
            timeCycle.setId(IdGenerator.getDefault().nextId() + "");
            this.getDoByVo(timeCycle).add();
        } else {
            this.getDoByVo(timeCycle).update();
        }
        result.put("success", true);
        result.put("msg", timeCycle.getId());
        return result;
    }

    @Override
    public TimeCycleVo detail(int type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        return this.timeCycleDao.findVoByMap(map);
    }

    @Override
    public TimeCycleVo getSettleTime() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TimeCycleType.\u7ed3\u7b97\u5468\u671f.getDbData());
        return this.timeCycleDao.findVoByMap(map);
    }

    @Override
    public TimeCycleVo getIndentShipTime() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TimeCycleType.\u8ba2\u5355\u81ea\u52a8\u6536\u8d27\u6709\u6548\u65f6\u95f4.getDbData());
        return this.timeCycleDao.findVoByMap(map);
    }

    private TimeCycleDo getDoByVo(TimeCycleVo src) {
        TimeCycleDo target = null;
        if (src != null) {
            target = new TimeCycleDo();
            target.setId(src.getId() == null ? null : Long.valueOf(src.getId()));
            target.setType(src.getType());
            target.setUpdateTime(src.getUpdateTime());
            target.setDuration(src.getDuration() == null ? null : Integer.valueOf(src.getDuration()));
        }
        return target;
    }

    @Override
    public TimeCycleVo getAgentSettleTime() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TimeCycleType.\u4ee3\u7406\u5546\u7ed3\u7b97\u5468\u671f.getDbData());
        return this.timeCycleDao.findVoByMap(map);
    }
}

