/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.service.impl;

import com.club.core.common.Page;
import com.club.web.store.domain.TradeHeadStoreDo;
import com.club.web.store.domain.repository.TradeHeadStoreRepository;
import com.club.web.store.service.TradeHeadStoreService;
import com.club.web.store.vo.TradeHeadStoreVo;
import com.club.web.util.CommonUtil;
import com.club.web.util.IdGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tradeHeadStoreService")
@Transactional
public class TradeHeadStoreServiceImpl
implements TradeHeadStoreService {
    private Logger logger = LoggerFactory.getLogger(TradeHeadStoreServiceImpl.class);
    @Autowired
    private TradeHeadStoreRepository tradeHeadStoreRepository;

    @Override
    public TradeHeadStoreVo getTradeHeadStoreVoById(Long id) {
        TradeHeadStoreVo headStoreVo = null;
        headStoreVo = this.tradeHeadStoreRepository.getTradeHeadStoreVoById(id);
        return headStoreVo;
    }

    @Override
    public Map<String, Object> saveOrUpdateTradeHeadStore(TradeHeadStoreVo tradeHeadStoreVo, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (tradeHeadStoreVo != null) {
            if (null == tradeHeadStoreVo.getName() || "".equals(tradeHeadStoreVo.getName())) {
                result.put("success", false);
                result.put("msg", "\u8bf7\u8f93\u5165\u603b\u5e97\u540d\u79f0");
                return result;
            }
            if (!("".equals(tradeHeadStoreVo.getTel()) || CommonUtil.isPhone(tradeHeadStoreVo.getTel()) || CommonUtil.isMobile(tradeHeadStoreVo.getTel()))) {
                result.put("success", false);
                result.put("msg", "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8054\u7cfb\u65b9\u5f0f");
                return result;
            }
            List<TradeHeadStoreVo> tradeHeadStoreByOwner = this.tradeHeadStoreRepository.queryTradeHeadStoreByOwner(tradeHeadStoreVo.getOwner());
            int conutOwner = tradeHeadStoreByOwner.size();
            List<TradeHeadStoreVo> tradeHeadStoreByName = this.tradeHeadStoreRepository.queryTradeHeadStoreByName(tradeHeadStoreVo.getName());
            int conutName = tradeHeadStoreByName.size();
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            if (tradeHeadStoreVo.getId() == null || "".equals(tradeHeadStoreVo.getId())) {
                if (conutName > 0) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u603b\u5e97\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
                    return result;
                }
                if (conutOwner > 0) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u5e97\u4e3b\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u603b\u5e97,\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff01");
                    return result;
                }
                tradeHeadStoreVo.setId(IdGenerator.getDefault().nextId() + "");
                tradeHeadStoreVo.setCreateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    tradeHeadStoreVo.setCreateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                tradeHeadStoreVo.setUpdateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    tradeHeadStoreVo.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                tradeHeadStoreVo.setStatue(1L);
                TradeHeadStoreDo tradeHeadStoreDo = this.tradeHeadStoreRepository.create(tradeHeadStoreVo);
                tradeHeadStoreDo.insert();
            } else {
                TradeHeadStoreDo tradeHeadStoreDo = this.tradeHeadStoreRepository.getTradeHeadStoreDoById(Long.parseLong(tradeHeadStoreVo.getId()));
                if (conutName > 0 && !tradeHeadStoreDo.getName().equalsIgnoreCase(tradeHeadStoreVo.getName())) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u603b\u5e97\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
                    return result;
                }
                if (conutOwner > 0 && tradeHeadStoreDo.getOwner() != tradeHeadStoreVo.getOwner()) {
                    result.put("success", false);
                    result.put("msg", "\u8be5\u62e5\u6709\u7740\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u603b\u5e97,\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff01");
                    return result;
                }
                tradeHeadStoreDo.setName(tradeHeadStoreVo.getName());
                tradeHeadStoreDo.setTel(tradeHeadStoreVo.getTel());
                tradeHeadStoreDo.setOwner(tradeHeadStoreVo.getOwner());
                tradeHeadStoreDo.setUpdateTime(new Date());
                if (loginMap != null && loginMap.get("staffId") != null) {
                    tradeHeadStoreDo.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
                }
                tradeHeadStoreDo.update();
            }
            result.put("success", true);
        } else {
            result.put("success", false);
            result.put("msg", "\u603b\u5e97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @Override
    public Map<String, Object> deleteTradeHeadStore(String idStr) {
        String[] Ids = idStr.split(",");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String id : Ids) {
            this.tradeHeadStoreRepository.deleteByPrimaryKey(Long.parseLong(id));
        }
        result.put("success", true);
        return result;
    }

    @Override
    public Page<Map<String, Object>> queryTradeHeadStorePage(Page<Map<String, Object>> page, HttpServletRequest request) {
        Page<Map<String, Object>> result = new Page<Map<String, Object>>();
        result.setStart(page.getStart());
        result.setLimit(page.getLimit());
        List<Map<String, Object>> list = this.tradeHeadStoreRepository.queryTradeHeadStorePage(page, request);
        Long count = this.tradeHeadStoreRepository.queryTradeHeadStoreCountPage(page, request);
        result.setResultList(list);
        result.setTotalRecords(count.intValue());
        return result;
    }

    @Override
    public Map<String, Object> updateTradeHeadStoreStatue(String idStr, Long statue, HttpServletRequest request) {
        String[] Ids = idStr.split(",");
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        for (String id : Ids) {
            TradeHeadStoreDo tradeHeadStoreDo = this.tradeHeadStoreRepository.getTradeHeadStoreDoById(Long.parseLong(id));
            tradeHeadStoreDo.setStatue(statue);
            tradeHeadStoreDo.setUpdateTime(new Date());
            if (loginMap != null && loginMap.get("staffId") != null) {
                tradeHeadStoreDo.setUpdateBy(Long.parseLong(loginMap.get("staffId").toString()));
            }
            tradeHeadStoreDo.update();
        }
        result.put("success", true);
        return result;
    }

    @Override
    public Long getStaffHeadStoreId(HttpServletRequest request) {
        Long id = null;
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        List<TradeHeadStoreVo> tradeHeadStoreByOwner = null;
        if (loginMap != null && loginMap.get("staffId") != null) {
            tradeHeadStoreByOwner = this.tradeHeadStoreRepository.queryTradeHeadStoreByOwner(Long.parseLong(loginMap.get("staffId").toString()));
        }
        id = tradeHeadStoreByOwner == null || tradeHeadStoreByOwner.size() <= 0 ? null : Long.valueOf(Long.parseLong(((TradeHeadStoreVo)tradeHeadStoreByOwner.get(0)).getId()));
        return id;
    }
}

