/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.store.vo;

import com.club.web.store.vo.ClassifyVO;
import com.club.web.store.vo.GoodsSimpleVO;
import com.club.web.store.vo.GoodsSpecVO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.List;

public class GoodsDetailVO {
    private boolean isRecommend;
    private boolean isHot;
    private List<GoodsSpecVO> specs;
    private ClassifyVO classify;
    private List<String> imagesTitle;
    private List<String> imagesDetail;
    private BigDecimal monthSell;
    private BigDecimal stock;
    private GoodsSimpleVO simpleData;

    public GoodsDetailVO(GoodsSimpleVO simpleData, List<GoodsSpecVO> specs, ClassifyVO classify, List<String> imagesTitle, List<String> imagesDetail, boolean isRecommend, boolean isHot, BigDecimal monthSell, BigDecimal stock) {
        this.simpleData = simpleData;
        this.specs = specs;
        this.isRecommend = isRecommend;
        this.isHot = isHot;
        this.classify = classify;
        this.imagesTitle = imagesTitle;
        this.imagesDetail = imagesDetail;
        this.monthSell = monthSell;
        this.stock = stock;
    }

    public long getGoodsId() {
        return this.simpleData.getGoodsId();
    }

    public String getTitle() {
        return this.simpleData.getTitle();
    }

    public BigDecimal getPrice() {
        return this.simpleData.getPrice();
    }

    public BigDecimal getDiscount() {
        return this.simpleData.getDiscount();
    }

    public String getCoverImg() {
        return this.simpleData.getCoverImg();
    }

    public BigDecimal getRate() {
        return this.simpleData.getRate();
    }

    public List<GoodsSpecVO> getSpecs() {
        return this.specs;
    }

    public ClassifyVO getClassify() {
        return this.classify;
    }

    public List<String> getImagesTitle() {
        return this.imagesTitle;
    }

    public List<String> getImagesDetail() {
        return this.imagesDetail;
    }

    public BigDecimal getMonthSell() {
        return this.monthSell;
    }

    public BigDecimal getStock() {
        return this.stock;
    }

    @JsonIgnore
    public boolean isDiscountGoods() {
        return this.getDiscount().compareTo(BigDecimal.ZERO) > 0 && this.getDiscount().compareTo(this.getPrice()) < 0;
    }

    @JsonIgnore
    public boolean isRecommend() {
        return this.isRecommend;
    }

    @JsonIgnore
    public boolean isHot() {
        return this.isHot;
    }

    @JsonIgnore
    public GoodsSimpleVO getSimpleData() {
        return this.simpleData;
    }
}

