/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.util;

import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.audience.AudienceTarget;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.club.web.util.IdGenerator;
import javax.annotation.PostConstruct;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:/config/jpush_debug.properties"})
public class AJpushUtils {
    @Value(value="${debug}")
    private String debug;
    @Value(value="${appKey}")
    private String appKey;
    @Value(value="${masterSecret}")
    private String masterSecret;
    public JPushClient jpushClient;
    public static Integer isDebug;
    static Logger logger;
    private static long timeToLive;

    public static void main(String[] args) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"msg_id", (Object)IdGenerator.getDefault().nextId());
        jsonObject.put((Object)"icon", (Object)"http://odv2wjw8i.bkt.clouddn.com/1481791118598d21d221.png");
        jsonObject.put((Object)"title", (Object)"\u7cfb\u7edf\u6d88\u606f");
        jsonObject.put((Object)"content", (Object)"\u65b0\u7684\u65e9\u6668\u5f00\u59cb\u4e86");
        jsonObject.put((Object)"deletable", (Object)1);
        jsonObject.put((Object)"type", (Object)0);
        jsonObject.put((Object)"date", (Object)System.currentTimeMillis());
        JSONObject json = new JSONObject();
        json.put((Object)"reason", (Object)"");
        json.put((Object)"request_id", (Object)"");
        jsonObject.put((Object)"extra", (Object)json);
        PushPayload payload = PushPayload.newBuilder().setOptions(Options.newBuilder().setApnsProduction(true).build()).setPlatform(Platform.all()).setAudience(Audience.all()).setMessage(Message.newBuilder().setTitle("\u6d4b\u8bd5").setMsgContent(jsonObject.toString()).build()).build();
        try {
            new AJpushUtils().jpushClient.sendPush(payload);
        }
        catch (APIConnectionException e) {
            e.printStackTrace();
        }
        catch (APIRequestException e) {
            e.printStackTrace();
        }
    }

    public void sendByAlias(String userId, String msg_content) {
        if (isDebug == 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"msg_id", (Object)IdGenerator.getDefault().nextId());
            jsonObject.put((Object)"icon", (Object)"http://odv2wjw8i.bkt.clouddn.com/1481791118598d21d221.png");
            jsonObject.put((Object)"title", (Object)"\u7cfb\u7edf\u6d88\u606f");
            jsonObject.put((Object)"content", (Object)msg_content);
            jsonObject.put((Object)"deletable", (Object)1);
            jsonObject.put((Object)"type", (Object)0);
            jsonObject.put((Object)"date", (Object)System.currentTimeMillis());
            JSONObject json = new JSONObject();
            json.put((Object)"reason", (Object)"");
            json.put((Object)"request_id", (Object)"");
            jsonObject.put((Object)"extra", (Object)json);
            try {
                this.jpushClient.sendAndroidMessageWithAlias("\u7cfb\u7edf\u6d88\u606f", jsonObject.toString(), new String[]{userId});
            }
            catch (APIConnectionException e) {
                e.printStackTrace();
            }
            catch (APIRequestException e) {
                e.printStackTrace();
            }
            try {
                this.jpushClient.sendIosMessageWithAlias("\u7cfb\u7edf\u6d88\u606f", jsonObject.toString(), new String[]{userId});
            }
            catch (APIConnectionException e) {
                e.printStackTrace();
            }
            catch (APIRequestException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendAll(String msg_content) {
        if (isDebug == 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"msg_id", (Object)IdGenerator.getDefault().nextId());
            jsonObject.put((Object)"icon", (Object)"http://odv2wjw8i.bkt.clouddn.com/1481791118598d21d221.png");
            jsonObject.put((Object)"title", (Object)"\u7cfb\u7edf\u6d88\u606f");
            jsonObject.put((Object)"content", (Object)msg_content);
            jsonObject.put((Object)"deletable", (Object)1);
            jsonObject.put((Object)"type", (Object)0);
            jsonObject.put((Object)"date", (Object)System.currentTimeMillis());
            JSONObject json = new JSONObject();
            json.put((Object)"reason", (Object)"");
            json.put((Object)"request_id", (Object)"");
            jsonObject.put((Object)"extra", (Object)json);
        }
    }

    public static PushPayload buildPushObject_android_and_ios(String notification_title, String msg_title, String msg_content, String extrasparam) {
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.all()).setNotification(Notification.newBuilder().setAlert((Object)notification_title).addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)notification_title).setTitle(notification_title).addExtra("androidNotification extras key", extrasparam)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)notification_title).incrBadge(1).setSound("sound.caf").addExtra("iosNotification extras key", extrasparam)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msg_content).setTitle(msg_title).addExtra("message extras key", extrasparam).build()).setOptions(Options.newBuilder().setApnsProduction(false).setSendno(1).setTimeToLive(86400L).build()).build();
    }

    public static PushPayload buildPushObject_all_all_alert(String content) {
        return PushPayload.alertAll((String)content);
    }

    public static PushPayload buildPushObject_all_alias_alert(String user, String content) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias((String[])new String[]{user})).setNotification(Notification.alert((Object)content)).build();
    }

    public static PushPayload buildPushObject_android_tag_alertWithTitle(String user, String title, String content) {
        return PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.tag((String[])new String[]{user})).setNotification(Notification.android((String)content, (String)title, null)).build();
    }

    public static PushPayload buildPushObject_ios_tagAnd_alertWithExtrasAndMessage(String alert, String content) {
        return PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.tag_and((String[])new String[]{"tag1", "tag_all"})).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)alert).setBadge(5).setSound("happy").addExtra("from", "JPush")).build()).build()).setMessage(Message.content((String)content)).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
    }

    public static PushPayload buildPushObject_ios_audienceMore_messageWithExtras() {
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.newBuilder().addAudienceTarget(AudienceTarget.tag((String[])new String[]{"tag1", "tag2"})).addAudienceTarget(AudienceTarget.alias((String[])new String[]{"alias1", "alias2"})).build()).setMessage(Message.newBuilder().setMsgContent("MSG_CONTENT").addExtra("from", "JPush").build()).build();
    }

    private static PushPayload buildPushObject_all_registrationId_alertWithTitle(String registrationId, String notification_title, String msg_title, String msg_content, String extrasparam) {
        System.out.println("----------buildPushObject_all_all_alert");
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId((String[])new String[]{registrationId})).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)notification_title).setTitle(notification_title).addExtra("androidNotification extras key", extrasparam)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)notification_title).incrBadge(1).setSound("sound.caf").addExtra("iosNotification extras key", extrasparam)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msg_content).setTitle(msg_title).addExtra("message extras key", extrasparam).build()).setOptions(Options.newBuilder().setApnsProduction(false).setSendno(1).setTimeToLive(86400L).build()).build();
    }

    private static PushPayload buildPushObject_android_all_alertWithTitle(String notification_title, String msg_title, String msg_content, String extrasparam) {
        System.out.println("----------buildPushObject_android_registrationId_alertWithTitle");
        return PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.all()).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)notification_title).setTitle(notification_title).addExtra("androidNotification extras key", extrasparam)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msg_content).setTitle(msg_title).addExtra("message extras key", extrasparam).build()).setOptions(Options.newBuilder().setApnsProduction(false).setSendno(1).setTimeToLive(86400L).build()).build();
    }

    private static PushPayload buildPushObject_ios_all_alertWithTitle(String notification_title, String msg_title, String msg_content, String extrasparam) {
        System.out.println("----------buildPushObject_ios_registrationId_alertWithTitle");
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias((String[])new String[]{"315632689586937856"})).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)notification_title).incrBadge(1).setSound("sound.caf").addExtra("iosNotification extras key", extrasparam)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msg_content).setTitle(msg_title).addExtra("message extras key", extrasparam).build()).setOptions(Options.newBuilder().setApnsProduction(false).setSendno(1).setTimeToLive(86400L).build()).build();
    }

    @PostConstruct
    public void init() {
        this.jpushClient = new JPushClient(this.masterSecret, this.appKey, 5);
        isDebug = Integer.parseInt(this.debug);
    }

    static {
        logger = LoggerFactory.getLogger(AJpushUtils.class);
        timeToLive = 86400L;
    }
}

