/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.util;

import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtil {
    public static <T> List<Map<String, Object>> listObjTransToListMap(List<T> t) {
        ArrayList<Map<String, Object>> listMap = null;
        if (t != null && t.size() > 0) {
            listMap = new ArrayList<Map<String, Object>>();
            for (T r : t) {
                listMap.add(JsonUtil.toMap(r));
            }
        }
        return listMap;
    }

    public static boolean isDigital(String str) {
        boolean flag = false;
        if (StringUtils.isNotEmpty(str)) {
            flag = str.matches("^\\d+$");
        }
        return flag;
    }

    public static boolean isMobile(String str) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static boolean isPhone(String str) {
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        boolean b = false;
        p1 = Pattern.compile("^[0][1-9]{2,3}?-?[0-9]{5,10}$");
        p2 = Pattern.compile("^[1-9]{1}[0-9]{5,8}$");
        if (str.length() > 9) {
            m = p1.matcher(str);
            b = m.matches();
        } else {
            m = p2.matcher(str);
            b = m.matches();
        }
        return b;
    }

    public static boolean checkEmail(String email) {
        boolean flag = false;
        try {
            String check = "^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(email);
            flag = matcher.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static String md5(String source) throws NoSuchAlgorithmException {
        String md5Str = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(source.getBytes());
        byte[] tmp = messageDigest.digest();
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        md5Str = new String(str);
        return md5Str;
    }

    public static String getHideIdCardVal(String hideParam, int prevIndex, int lastIndex, int count) {
        StringBuilder str = new StringBuilder();
        if (StringUtils.isNotEmpty(hideParam)) {
            str = str.append(hideParam.substring(0, prevIndex));
            for (int i = 0; i < count; ++i) {
                str = str.append("*");
            }
            str = str.append(hideParam.substring(hideParam.length() - lastIndex));
        }
        return str.toString();
    }

    public static String getRandByNum(int num) {
        String length = "1";
        for (int i = 0; i < num; ++i) {
            length = length + "0";
        }
        Random rad = new Random();
        String result = rad.nextInt(Integer.parseInt(length)) + "";
        if (result.length() != num) {
            return CommonUtil.getRandByNum(num);
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(CommonUtil.isPhone("0592-2176495"));
        System.out.println(CommonUtil.isPhone("0592217641"));
    }
}

