/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateParseUtil {
    protected static Logger logger = LoggerFactory.getLogger(DateParseUtil.class);
    public static final String NAME = "name";
    public static final String STARTDATE = "startDate";
    public static final String ENDDATE = "endDate";
    public static final String VALMAP = "valMap";
    public static final String KEYLIST = "keyList";

    public static Date parseDate(String dateString, String parsePattern) {
        try {
            return DateUtils.parseDate((String)dateString, (String[])new String[]{parsePattern});
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static Date parseDate(String dateString, String[] parsePatterns) {
        try {
            return DateUtils.parseDate((String)dateString, (String[])parsePatterns);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parseDate(String dateString) {
        try {
            return DateUtils.parseDate((String)dateString, (String[])new String[]{"yyyy-MM-dd"});
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static String formatDate(Date date, String ... formatPattern) {
        SimpleDateFormat sdf = formatPattern.length > 0 ? new SimpleDateFormat(formatPattern[0]) : new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static boolean isCorrectDate(String dateString, String[] parsePatterns) {
        try {
            DateUtils.parseDate((String)dateString, (String[])parsePatterns);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static int getMonthDifference(Date date1, Date date2) {
        Calendar bigCalendar = Calendar.getInstance();
        Calendar smallCalendar = Calendar.getInstance();
        bigCalendar.setTime(date1.getTime() > date2.getTime() ? date1 : date2);
        smallCalendar.setTime(date1.getTime() < date2.getTime() ? date1 : date2);
        int bigYear = bigCalendar.get(1);
        int smallYear = smallCalendar.get(1);
        int bigMonth = bigCalendar.get(2);
        int smallMonth = smallCalendar.get(2);
        int bigDay = bigCalendar.get(5);
        int smallDay = smallCalendar.get(5);
        return bigMonth + (bigYear > smallYear ? (bigYear - smallYear) * 12 : 0) - smallMonth + (bigDay >= smallDay ? 0 : -1);
    }

    public static Map<String, Object> getMapDate(String start, String end) {
        try {
            if (start == null || end == null) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date dateS = sdf.parse(start);
            Date dateE = sdf.parse(end);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            while (dateE.after(dateS) || dateE.equals(dateS)) {
                String mapKey = sdf.format(dateS);
                dateS = DateParseUtil.getNextMonth(dateS);
                map.put(mapKey, new Long(0L));
            }
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getUpaMonthYear(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date dateRes = sdf.parse(date);
            dateRes = DateParseUtil.getOnaYeah(dateRes);
            return sdf.format(dateRes);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getUpaMonth(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date dateRes = sdf.parse(date);
            dateRes = DateParseUtil.getOnaMonth(dateRes);
            return sdf.format(dateRes);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date getNextMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        gc.add(2, 1);
        return gc.getTime();
    }

    public static Date getJiduStart(int year, int quarterly) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.set(year, (quarterly - 1) * 3, 1, 0, 0, 0);
        return gc.getTime();
    }

    public static Date getNianduStart(int year) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.set(year, 0, 1, 0, 0, 0);
        return gc.getTime();
    }

    public static Map<String, Map<String, Date>> getDateList(int year, int yearend) {
        LinkedHashMap<String, Map<String, Date>> mapRes = new LinkedHashMap<String, Map<String, Date>>();
        if (yearend < year) {
            return mapRes;
        }
        while (year <= yearend) {
            HashMap<String, Date> map = new HashMap<String, Date>();
            String mapKey = year + "";
            map.put(STARTDATE, DateParseUtil.getNianduStart(year));
            map.put(ENDDATE, DateParseUtil.getNianduStart(++year));
            mapRes.put(mapKey, map);
        }
        return mapRes;
    }

    public static Map<String, Map<String, Date>> getDateList(int year, int quarterly, int yearend, int quarterlyend) {
        LinkedHashMap<String, Map<String, Date>> mapRes = new LinkedHashMap<String, Map<String, Date>>();
        while (year <= yearend && (year != yearend || quarterlyend >= quarterly)) {
            HashMap<String, Date> map = new HashMap<String, Date>();
            String mapKey = year + "-Q" + quarterly;
            map.put(STARTDATE, DateParseUtil.getJiduStart(year, quarterly));
            if (quarterly == 4) {
                ++year;
                quarterly = 1;
            } else {
                ++quarterly;
            }
            map.put(ENDDATE, DateParseUtil.getJiduStart(year, quarterly));
            mapRes.put(mapKey, map);
        }
        return mapRes;
    }

    public static Date getOnaYeah(Date date) {
        if (date == null) {
            return new Date();
        }
        Calendar ca1 = Calendar.getInstance();
        ca1.setTime(date);
        ca1.add(1, -1);
        return ca1.getTime();
    }

    public static Date getOnaMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar ca1 = Calendar.getInstance();
        ca1.setTime(date);
        ca1.add(2, -1);
        return ca1.getTime();
    }

    public static List<List<String>> getMapList(List<Map<String, Object>> list, List<Map<String, Object>> listUpA) {
        LinkedHashMap<String, List<String>> resMap = new LinkedHashMap<String, List<String>>();
        HashMap<String, List> valMapOld = new HashMap<String, List>();
        for (Map<String, Object> map : listUpA) {
            valMapOld.put(map.get(NAME).toString(), (List)map.get(VALMAP));
        }
        for (Map<String, Object> map : list) {
            Set keyList = (Set)map.get(KEYLIST);
            String name = map.get(NAME).toString();
            List valMap = (List)map.get(VALMAP);
            int k = 0;
            for (String key : keyList) {
                Long new1;
                List<String> listRes;
                if (valMapOld.get(name) != null && ((List)valMapOld.get(name)).size() > 0) {
                    Long old;
                    Long new12;
                    List<String> listRes2;
                    List valListOld = (List)valMapOld.get(name);
                    if (resMap.get(key) == null) {
                        listRes2 = new ArrayList<String>();
                        listRes2.add(key);
                        listRes2.add(valMap.get(k).toString());
                        new12 = (Long)valMap.get(k);
                        old = (Long)valListOld.get(k);
                        listRes2.add(old + "");
                        listRes2.add(DateParseUtil.shangge(old, new12));
                        resMap.put(key, listRes2);
                    } else {
                        listRes2 = (List)resMap.get(key);
                        listRes2.add(valMap.get(k).toString());
                        new12 = (Long)valMap.get(k);
                        old = (Long)valListOld.get(k);
                        listRes2.add(old + "");
                        listRes2.add(DateParseUtil.shangge(old, new12));
                        resMap.put(key, listRes2);
                    }
                } else if (resMap.get(key) == null) {
                    listRes = new ArrayList<String>();
                    listRes.add(key);
                    listRes.add(valMap.get(k).toString());
                    new1 = (Long)valMap.get(k);
                    listRes.add("0");
                    listRes.add(DateParseUtil.shangge(new Long(0L), new1));
                    resMap.put(key, listRes);
                } else {
                    listRes = (List)resMap.get(key);
                    listRes.add(valMap.get(k).toString());
                    new1 = (Long)valMap.get(k);
                    listRes.add("0");
                    listRes.add(DateParseUtil.shangge(new Long(0L), new1));
                    resMap.put(key, listRes);
                }
                ++k;
            }
        }
        return new ArrayList<List<String>>(resMap.values());
    }

    public static List<List<String>> getDoubleMapList(List<Map<String, Object>> list, List<Map<String, Object>> listUpA) {
        LinkedHashMap<String, List<String>> resMap = new LinkedHashMap<String, List<String>>();
        HashMap<String, List> valMapOld = new HashMap<String, List>();
        for (Map<String, Object> map : listUpA) {
            valMapOld.put(map.get(NAME).toString(), (List)map.get(VALMAP));
        }
        for (Map<String, Object> map : list) {
            Set keyList = (Set)map.get(KEYLIST);
            String name = map.get(NAME).toString();
            List valMap = (List)map.get(VALMAP);
            int k = 0;
            for (String key : keyList) {
                Double new1;
                List<String> listRes;
                if (valMapOld.get(name) != null && ((List)valMapOld.get(name)).size() > 0) {
                    Double old;
                    Double new12;
                    List<String> listRes2;
                    List valListOld = (List)valMapOld.get(name);
                    if (resMap.get(key) == null) {
                        listRes2 = new ArrayList<String>();
                        listRes2.add(key);
                        listRes2.add(valMap.get(k).toString());
                        new12 = (Double)valMap.get(k);
                        old = (Double)valListOld.get(k);
                        listRes2.add(old + "");
                        listRes2.add(DateParseUtil.shangge(old, new12));
                        resMap.put(key, listRes2);
                    } else {
                        listRes2 = (List)resMap.get(key);
                        listRes2.add(valMap.get(k).toString());
                        new12 = (Double)valMap.get(k);
                        old = (Double)valListOld.get(k);
                        listRes2.add(old + "");
                        listRes2.add(DateParseUtil.shangge(old, new12));
                        resMap.put(key, listRes2);
                    }
                } else if (resMap.get(key) == null) {
                    listRes = new ArrayList<String>();
                    listRes.add(key);
                    listRes.add(valMap.get(k).toString());
                    new1 = (Double)valMap.get(k);
                    listRes.add("0");
                    listRes.add(DateParseUtil.shangge(new Double(0.0), new1));
                    resMap.put(key, listRes);
                } else {
                    listRes = (List)resMap.get(key);
                    listRes.add(valMap.get(k).toString());
                    new1 = (Double)valMap.get(k);
                    listRes.add("0");
                    listRes.add(DateParseUtil.shangge(new Double(0.0), new1));
                    resMap.put(key, listRes);
                }
                ++k;
            }
        }
        return new ArrayList<List<String>>(resMap.values());
    }

    public static List<List<String>> getMapList(List<Map<String, Object>> list) {
        LinkedHashMap<String, List<String>> resMap = new LinkedHashMap<String, List<String>>();
        for (Map<String, Object> map : list) {
            Set keyList = (Set)map.get(KEYLIST);
            List valMap = (List)map.get(VALMAP);
            int k = 0;
            for (String key : keyList) {
                Long new1;
                Long old;
                List<String> listRes;
                if (k == 0) {
                    if (resMap.get(key) == null) {
                        listRes = new ArrayList<String>();
                        listRes.add(key);
                        listRes.add(valMap.get(k).toString());
                        listRes.add("--");
                        listRes.add("--");
                        resMap.put(key, listRes);
                    } else {
                        listRes = (List)resMap.get(key);
                        listRes.add(valMap.get(k).toString());
                        listRes.add("--");
                        listRes.add("--");
                        resMap.put(key, listRes);
                    }
                } else if (resMap.get(key) == null) {
                    listRes = new ArrayList();
                    listRes.add(key);
                    listRes.add(valMap.get(k).toString());
                    old = (Long)valMap.get(k - 1);
                    new1 = (Long)valMap.get(k);
                    listRes.add(old + "");
                    listRes.add(DateParseUtil.shangge(old, new1));
                    resMap.put(key, listRes);
                } else {
                    listRes = (List)resMap.get(key);
                    listRes.add(valMap.get(k).toString());
                    old = (Long)valMap.get(k - 1);
                    new1 = (Long)valMap.get(k);
                    listRes.add(old + "");
                    listRes.add(DateParseUtil.shangge(old, new1));
                    resMap.put(key, listRes);
                }
                ++k;
            }
        }
        return new ArrayList<List<String>>(resMap.values());
    }

    public static List<List<String>> getDoubleMapList(List<Map<String, Object>> list) {
        LinkedHashMap<String, List<String>> resMap = new LinkedHashMap<String, List<String>>();
        for (Map<String, Object> map : list) {
            Set keyList = (Set)map.get(KEYLIST);
            List valMap = (List)map.get(VALMAP);
            int k = 0;
            for (String key : keyList) {
                Double new1;
                Double old;
                List<String> listRes;
                if (k == 0) {
                    if (resMap.get(key) == null) {
                        listRes = new ArrayList<String>();
                        listRes.add(key);
                        listRes.add(valMap.get(k).toString());
                        listRes.add("--");
                        listRes.add("--");
                        resMap.put(key, listRes);
                    } else {
                        listRes = (List)resMap.get(key);
                        listRes.add(valMap.get(k).toString());
                        listRes.add("--");
                        listRes.add("--");
                        resMap.put(key, listRes);
                    }
                } else if (resMap.get(key) == null) {
                    listRes = new ArrayList();
                    listRes.add(key);
                    listRes.add(valMap.get(k).toString());
                    old = (Double)valMap.get(k - 1);
                    new1 = (Double)valMap.get(k);
                    listRes.add(old + "");
                    listRes.add(DateParseUtil.shangge(old, new1));
                    resMap.put(key, listRes);
                } else {
                    listRes = (List)resMap.get(key);
                    listRes.add(valMap.get(k).toString());
                    old = (Double)valMap.get(k - 1);
                    new1 = (Double)valMap.get(k);
                    listRes.add(old + "");
                    listRes.add(DateParseUtil.shangge(old, new1));
                    resMap.put(key, listRes);
                }
                ++k;
            }
        }
        return new ArrayList<List<String>>(resMap.values());
    }

    public static List<List<String>> getMapListBar(List<Map<String, Object>> list) {
        LinkedHashMap resMap = new LinkedHashMap();
        for (Map<String, Object> map : list) {
            Set keyList = (Set)map.get(KEYLIST);
            List valMap = (List)map.get(VALMAP);
            int k = 0;
            for (String key : keyList) {
                List<String> listRes;
                if (k == 0) {
                    if (resMap.get(key) == null) {
                        listRes = new ArrayList<String>();
                        listRes.add(key);
                        listRes.add(valMap.get(k).toString());
                        resMap.put(key, listRes);
                    } else {
                        listRes = (List)resMap.get(key);
                        listRes.add(valMap.get(k).toString());
                        resMap.put(key, listRes);
                    }
                } else if (resMap.get(key) == null) {
                    listRes = new ArrayList();
                    listRes.add(key);
                    listRes.add(valMap.get(k).toString());
                    resMap.put(key, listRes);
                } else {
                    listRes = (List)resMap.get(key);
                    listRes.add(valMap.get(k).toString());
                    resMap.put(key, listRes);
                }
                ++k;
            }
        }
        return new ArrayList<List<String>>(resMap.values());
    }

    public static List<List<String>> getMapListReason(Map<String, Map<String, Object>> tableMap) {
        LinkedHashMap resMap = new LinkedHashMap();
        for (String fisrtKey : tableMap.keySet()) {
            Map<String, Object> map = tableMap.get(fisrtKey);
            int k = 0;
            for (String key : map.keySet()) {
                List<String> listRes;
                if (k == 0) {
                    if (resMap.get(key) == null) {
                        listRes = new ArrayList<String>();
                        listRes.add(key);
                        listRes.add(map.get(key).toString());
                        resMap.put(key, listRes);
                    } else {
                        listRes = (List)resMap.get(key);
                        listRes.add(map.get(key).toString());
                        resMap.put(key, listRes);
                    }
                } else if (resMap.get(key) == null) {
                    listRes = new ArrayList();
                    listRes.add(key);
                    listRes.add(map.get(key).toString());
                    resMap.put(key, listRes);
                } else {
                    listRes = (List)resMap.get(key);
                    listRes.add(map.get(key).toString());
                    resMap.put(key, listRes);
                }
                ++k;
            }
        }
        return new ArrayList<List<String>>(resMap.values());
    }

    public static String count(String a, String b) {
        Long av = new Long(a);
        Long bv = new Long(b);
        return av + bv + "";
    }

    public static List<List<String>> getMapListBarCount(List<Map<String, Object>> list) {
        LinkedHashMap resMap = new LinkedHashMap();
        ArrayList<String> listResCount = new ArrayList<String>();
        listResCount.add("\u603b\u8ba1");
        for (Map<String, Object> map : list) {
            Set keyList = (Set)map.get(KEYLIST);
            List valMap = (List)map.get(VALMAP);
            int k = 0;
            Long count = 0L;
            for (String key : keyList) {
                List<String> listRes;
                if (k == 0) {
                    if (resMap.get(key) == null) {
                        listRes = new ArrayList<String>();
                        listRes.add(key);
                        listRes.add(valMap.get(k).toString());
                        resMap.put(key, listRes);
                    } else {
                        listRes = (List)resMap.get(key);
                        listRes.add(valMap.get(k).toString());
                        resMap.put(key, listRes);
                    }
                } else if (resMap.get(key) == null) {
                    listRes = new ArrayList();
                    listRes.add(key);
                    listRes.add(valMap.get(k).toString());
                    resMap.put(key, listRes);
                } else {
                    listRes = (List)resMap.get(key);
                    listRes.add(valMap.get(k).toString());
                    resMap.put(key, listRes);
                }
                count = count + new Long(valMap.get(k).toString());
                ++k;
            }
            listResCount.add(count + "");
        }
        resMap.put("\u603b\u8ba1", listResCount);
        return new ArrayList<List<String>>(resMap.values());
    }

    public static List<String[]> countAsProduct(List<String[]> list) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (String[] str : list) {
            String productName = str[1];
            double val = Double.valueOf(str[6]);
            if (map.get(productName) == null) {
                map.put(productName, val);
                countMap.put(productName, 1);
                continue;
            }
            if ((Double)map.get(productName) < val) {
                map.put(productName, val);
            }
            countMap.put(productName, (Integer)countMap.get(productName) + 1);
        }
        ArrayList<String[]> res = new ArrayList<String[]>();
        for (String key : map.keySet()) {
            String[] str = new String[]{key, String.valueOf(map.get(key)), String.valueOf(countMap.get(key))};
            res.add(str);
        }
        return res;
    }

    public static double countDate(Date start, Date end) {
        long lo = start.getTime() - end.getTime();
        double x = (double)lo / 24.0 / 60.0 / 60.0 / 1000.0;
        return Math.floor(x) + 1.0;
    }

    public static String shangge(Long old, Long new1) {
        if (old == 0L) {
            if (new1 == 0L) {
                return "0%";
            }
            return "100%";
        }
        float x = (float)(new1 - old) / (float)old.longValue() * 100.0f;
        if (x == 0.0f) {
            return "0%";
        }
        DecimalFormat df = new DecimalFormat("#.00");
        return df.format(x) + "%";
    }

    public static String shangge(Double old, Double new1) {
        if (old == 0.0 || old == 0.0) {
            if (new1 == 0.0 || new1 == 0.0) {
                return "0%";
            }
            return "100%";
        }
        double x = (new1 - old) / old * 100.0;
        if (x == 0.0 || x == 0.0) {
            return "0%";
        }
        DecimalFormat df = new DecimalFormat("#.00");
        return df.format(x) + "%";
    }

    public static float getMathCount(Long old, Long new1) {
        if (old == 0L) {
            if (new1 == 0L) {
                return 0.0f;
            }
            return 100.0f;
        }
        float x = (float)(new1 - old) / (float)old.longValue() * 100.0f;
        BigDecimal bg = new BigDecimal(x);
        float f1 = bg.setScale(2, 4).floatValue();
        return f1;
    }

    public static Date[] getLastWeekTime(Date ... date) {
        Date s_time;
        Date e_time;
        Date c_time = date.length < 1 ? new Date() : date[0];
        Calendar cal = Calendar.getInstance();
        cal.setTime(c_time);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        int c_wd = cal.get(7);
        if (c_wd == 1) {
            cal.add(5, -6);
            e_time = cal.getTime();
            cal.add(5, -7);
            s_time = cal.getTime();
        } else {
            cal.add(5, 2 - c_wd);
            e_time = cal.getTime();
            cal.add(5, -7);
            s_time = cal.getTime();
        }
        return new Date[]{s_time, e_time};
    }

    public static Date[] getCurrentWeekTime(Date ... date) {
        Date e_time;
        Date s_time;
        Date c_time = date.length < 1 ? new Date() : date[0];
        Calendar cal = Calendar.getInstance();
        cal.setTime(c_time);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        int c_wd = cal.get(7);
        if (c_wd == 1) {
            cal.add(5, -6);
            s_time = cal.getTime();
            cal.add(5, 7);
            e_time = cal.getTime();
        } else {
            cal.add(5, 2 - c_wd);
            s_time = cal.getTime();
            cal.add(5, 7);
            e_time = cal.getTime();
        }
        return new Date[]{s_time, e_time};
    }

    public static Date[] getQuarterRange(int quarter, int year) {
        quarter = quarter > 4 ? 4 : quarter;
        quarter = quarter < 1 ? 1 : quarter;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, (quarter - 1) * 3);
        Date start = calendar.getTime();
        calendar.add(2, 3);
        calendar.add(14, -1);
        Date end = calendar.getTime();
        return new Date[]{start, end};
    }

    public static Date[] getCurrentQuarterRange() {
        return DateParseUtil.getQuarterRange(DateParseUtil.getCurrentQuarter(), DateParseUtil.getCurrentYear());
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return date == null ? 0 : calendar.get(1);
    }

    public static int getQuarter(Date date) {
        int month = DateParseUtil.getMonth(date);
        return month == 0 ? 0 : month / 3 + 1;
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        return date == null ? 0 : month;
    }

    public static int getCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static int getCurrentQuarter() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) / 3 + 1;
    }

    public static final Date getDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static final Date getCurrentDateOnlyDate() {
        return DateParseUtil.getDate(new Date());
    }

    public static final int getCurrentMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static final Date getBeforeDate(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -num);
        return calendar.getTime();
    }

    public static final Date getLastDate(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, num);
        return calendar.getTime();
    }

    public static final Date getBeforeMonthDate(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -num);
        return calendar.getTime();
    }

    public static final Date getLastMonthDate(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, num);
        return calendar.getTime();
    }

    public static final boolean equalDate(Date d1, Date d2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(d1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(d2);
        return calendar1.get(1) == calendar2.get(1) && calendar1.get(6) == calendar2.get(6);
    }

    public static final int getDifferenceDate(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        c1.set(11, 0);
        c2.set(11, 0);
        c1.set(12, 0);
        c2.set(12, 0);
        c1.set(13, 0);
        c2.set(13, 0);
        c1.set(14, 0);
        c2.set(14, 0);
        int result = (int)((c1.getTime().getTime() - c2.getTime().getTime()) / 1000L / 3600L / 24L);
        return result;
    }

    public static final int getDifferenceDateWithNow(Date date) {
        return DateParseUtil.getDifferenceDate(date, new Date());
    }

    public static final String addDate(String dateStr, int increment) {
        Date d = DateParseUtil.parseDate(dateStr);
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(6, increment);
        Date nd = c.getTime();
        return DateParseUtil.formatDate(nd, new String[0]);
    }

    public static String getmonthByDateStringAndAmount(String indexDate, int amount) {
        Date date = DateParseUtil.parseDate(indexDate + "-01");
        date = DateUtils.addMonths((Date)date, (int)amount);
        return DateFormatUtils.format((Date)date, (String)"yyyy-MM");
    }

    public static String getDate(int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, offset);
        return DateParseUtil.formatDate(calendar.getTime(), new String[0]);
    }

    public static String getCurrentWeekStartDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int b = date.getDay();
        if (b > 0) {
            Long endTime = date.getTime() + (long)((1 - b) * 24 * 3600000);
            date.setTime(endTime);
            return sdf.format(date);
        }
        Long endTime = date.getTime() - 518400000L;
        date.setTime(endTime);
        return sdf.format(date);
    }

    public static String getCurrentWeekEndDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int b = date.getDay();
        if (b > 0) {
            Long endTime = date.getTime() + (long)((7 - b) * 24 * 3600000);
            date.setTime(endTime);
            return sdf.format(date);
        }
        return sdf.format(date);
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static Date simpleDateFormat(String dateString, String parsePattern) {
        try {
            if (parsePattern != "" && dateString != "") {
                SimpleDateFormat fmt = new SimpleDateFormat(parsePattern);
                return fmt.parse(dateString);
            }
            if (parsePattern == "" || dateString == "") {
                SimpleDateFormat fmt = new SimpleDateFormat(parsePattern == "" ? "yyyy-MM-dd HH:mm:ss" : parsePattern);
                return dateString == "" ? new Date() : fmt.parse(dateString);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new Date();
    }

    public static final int isDefferenceDate(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        c1.set(5, 0);
        c2.set(5, 0);
        c1.set(11, 0);
        c2.set(11, 0);
        c1.set(12, 0);
        c2.set(12, 0);
        c1.set(13, 0);
        c2.set(13, 0);
        c1.set(14, 0);
        c2.set(14, 0);
        int result = (int)((c1.getTime().getTime() - c2.getTime().getTime()) / 1000L / 3600L / 24L / 30L);
        return result;
    }

    public static final int getDifferenceHour(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        c1.set(12, 0);
        c2.set(12, 0);
        c1.set(13, 0);
        c2.set(13, 0);
        c1.set(14, 0);
        c2.set(14, 0);
        int result = (int)((c1.getTime().getTime() - c2.getTime().getTime()) / 1000L / 3600L);
        return result;
    }

    public static String getYesterDay(Date date, String ... formatPattern) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        return DateParseUtil.formatDate(calendar.getTime(), formatPattern);
    }

    public static Date getDayBy(Integer day) {
        Calendar curr = Calendar.getInstance();
        if (curr.get(5) > day) {
            curr.set(2, curr.get(2) + 1);
        }
        curr.set(5, day);
        Date date = curr.getTime();
        return date;
    }
}

