/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.pili.Hub;
import com.pili.PiliException;
import com.pili.Stream;
import com.qiniu.Credentials;
import com.qiniu.util.Auth;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:/config/qiniu.properties"})
public class QiNiuUtils {
    @Value(value="${qiniu.access_key}")
    private String access_key;
    @Value(value="${qiniu.secret_key}")
    private String secret_key;
    @Value(value="${qiniu.bucketname}")
    private String bucketname;
    @Value(value="${qiniu.bucketnamefile}")
    private String bucketnamefile;
    @Value(value="${qiniu.hubname}")
    private String hubName;
    Auth qiNiuAuth;
    Credentials credentials;
    Hub hub;

    public String getQiNiuToken() {
        return this.qiNiuAuth.uploadToken(this.bucketname, null, 36000000L, null);
    }

    public String getQiNiuFileToken() {
        return this.qiNiuAuth.uploadToken(this.bucketnamefile, null, 36000000L, null);
    }

    public String createStream(String title) {
        return this.createStream(title, null, null);
    }

    public String createStream(String title, String publishKey, String publishSecurity) {
        Stream stream = null;
        try {
            stream = this.hub.createStream(title, publishKey, publishSecurity);
            System.out.println("hub.createStream:");
            return stream.toJsonString();
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getStream(String streamId) {
        Stream stream = null;
        try {
            stream = this.hub.getStream(streamId);
            System.out.println("hub.getStream:");
            return stream.toJsonString();
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String listStreams(String status, String marker, long limit, String titlePrefix) {
        try {
            Stream.StreamList streamList = this.hub.listStreams(status, marker, limit, titlePrefix);
            System.out.println("hub.listStreams()");
            System.out.println("marker:" + streamList.getMarker());
            List list = streamList.getStreams();
            JSONArray jsonArray = new JSONArray();
            for (Stream stream : list) {
                jsonArray.add((Object)JSONObject.parseObject((String)stream.toJsonString()));
            }
            return jsonArray.toJSONString();
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String updateStream(String streamId, String newPublishKey, String newPublishSecurity, boolean newDisabled) {
        try {
            Stream stream = this.hub.getStream(streamId);
            Stream newStream = stream.update(newPublishKey, newPublishSecurity, newDisabled);
            System.out.println("Stream update()");
            return newStream.toJsonString();
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean disableStream(String streamId) {
        try {
            Stream stream = this.hub.getStream(streamId);
            Stream disabledStream = stream.disable();
            System.out.println("Stream disable()");
            return disabledStream.isDisabled();
        }
        catch (PiliException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean enableStream(String streamId) {
        try {
            Stream stream = this.hub.getStream(streamId);
            Stream enabledStream = stream.enable();
            System.out.println("Stream enable()");
            return !enabledStream.isDisabled();
        }
        catch (PiliException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getStreamStatus(String streamId) {
        try {
            Stream stream = this.hub.getStream(streamId);
            Stream.Status status = stream.status();
            System.out.println("Stream status()");
            return status.toString();
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createRTMPPublishUrl(String streamId) {
        try {
            Stream stream = this.hub.getStream(streamId);
            String publishUrl = stream.rtmpPublishUrl();
            System.out.println("Stream rtmpPublishUrl()");
            return publishUrl;
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createRTMPLiveUrl(String streamId) {
        Stream stream = null;
        try {
            stream = this.hub.getStream(streamId);
            String originUrl = (String)stream.rtmpLiveUrls().get("ORIGIN");
            System.out.println("Stream rtmpLiveUrls()");
            return originUrl;
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createHLSLiveUrl(String streamId) {
        Stream stream = null;
        try {
            stream = this.hub.getStream(streamId);
            String originUrl = (String)stream.hlsLiveUrls().get("ORIGIN");
            System.out.println("Stream hlsLiveUrls()");
            return originUrl;
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createHLSPlaybackUrl(String streamId, long startHlsPlayback, long endHlsPlayback) {
        try {
            Stream stream = this.hub.getStream(streamId);
            String hlsPlaybackUrl = (String)stream.hlsPlaybackUrls(startHlsPlayback, endHlsPlayback).get("ORIGIN");
            System.out.println("Stream hlsPlaybackUrls()");
            return hlsPlaybackUrl;
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String snapShotStream(String streamId, String format, String name, long time, String notifyUrl) {
        try {
            Stream stream = this.hub.getStream(streamId);
            Stream.SnapshotResponse response = stream.snapshot(name, format, time, notifyUrl);
            System.out.println("Stream snapshot()");
            return response.toString();
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String saveStreamAsFile(String streamId, String saveAsFormat, String saveAsName, long saveAsStart, long saveAsEnd, String saveAsNotifyUrl) {
        try {
            Stream stream = this.hub.getStream(streamId);
            Stream.SaveAsResponse response = stream.saveAs(saveAsName, saveAsFormat, saveAsStart, saveAsEnd, saveAsNotifyUrl);
            System.out.println("Stream saveAs()");
            return response.toString();
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String deleteStream(String streamId) {
        try {
            Stream stream = this.hub.getStream(streamId);
            String res = stream.delete();
            System.out.println("Stream delete()");
            return res;
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createFLVLiveUrl(String streamId) {
        Stream stream = null;
        try {
            stream = this.hub.getStream(streamId);
            String originUrl = (String)stream.httpFlvLiveUrls().get("ORIGIN");
            System.out.println("Stream httpFlvLiveUrls()");
            return originUrl;
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Stream.SegmentList getStreamSegments(String streamId, long start, long end, int limit) {
        try {
            Stream stream = this.hub.getStream(streamId);
            Stream.SegmentList segmentList = stream.segments(start, end, limit);
            System.out.println("Stream segments()");
            for (Stream.Segment segment : segmentList.getSegmentList()) {
                System.out.println("start:" + segment.getStart() + ",end:" + segment.getEnd());
            }
            return segmentList;
        }
        catch (PiliException e) {
            e.printStackTrace();
            return null;
        }
    }

    @PostConstruct
    public void init() {
        this.qiNiuAuth = Auth.create((String)this.access_key, (String)this.secret_key);
        this.credentials = new Credentials(this.access_key, this.secret_key);
        this.hub = new Hub(this.credentials, this.hubName);
    }
}

