/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.util;

import com.club.framework.util.HttpUtils;
import com.club.framework.util.StringUtils;
import com.club.web.store.vo.PushMsgVo;
import com.club.web.util.CommonUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:/config/sms.properties"})
public class SmsUtil {
    private Logger logger = LoggerFactory.getLogger(SmsUtil.class);
    @Value(value="${sms.address}")
    private String address;
    @Value(value="${sms.uri}")
    private String uri;
    @Value(value="${sms.userid}")
    private String userid;
    @Value(value="${sms.token}")
    private String token;
    @Value(value="${sms.template.regist}")
    private String registTemplate;
    @Value(value="${sms.template.reviewSuc}")
    private String reviewSuc;
    @Value(value="${sms.template.reviewSuc1}")
    private String reviewSuc1;
    @Value(value="${sms.template.reviewFail}")
    private String reviewFail;
    @Value(value="${sms.template.reviewFail1}")
    private String reviewFail1;
    @Value(value="${sms.template.delivery}")
    private String deliveryTemplate;
    @Value(value="${sms.template.buymyself}")
    private String buymyselfTemplate;
    @Value(value="${sms.template.buyother}")
    private String buyotherTemplate;
    @Value(value="${sms.template.coupon}")
    private String couponTemplate;
    @Value(value="${sms.appKey}")
    private String appKey;
    @Value(value="${sms.secretKey}")
    private String secretKey;
    @Value(value="${sms.hostPush}")
    private String hostPush;
    @Value(value="${sms.hostPushStatus}")
    private String hostPushStatus;
    @Value(value="${sms.channel}")
    private String channel;

    private String send(String phone, String msg) {
        try {
            String message = URLEncoder.encode(msg, "utf-8");
            String query = this.uri + "?userId=" + this.userid + "&mobile=" + phone + "&content=" + msg;
            String sign = StringUtils.md5(query + this.token);
            String result = HttpUtils.sendGet(this.address + this.uri, "userId=" + this.userid + "&mobile=" + phone + "&content=" + message + "&sign=" + sign);
            this.logger.debug("\u53d1\u9001\u77ed\u4fe1: {}, \u5730\u5740: {}, \u7ed3\u679c: {}.", new Object[]{msg, this.address, result});
            return result;
        }
        catch (Exception e) {
            this.logger.debug("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            return null;
        }
    }

    public static void main(String[] args) {
        SmsUtil smsUtil = new SmsUtil();
        smsUtil.sendMsg("13774666937", "\u6d4b\u8bd5\u77ed\u4fe1");
    }

    public String sendMsg(String phone, String msg) {
        return this.send(phone, msg);
    }

    public String sendSucMsg(String phone, String userName) {
        return this.send(phone, this.reviewSuc.replace("{phone}", phone).replace("{name}", userName));
    }

    public String sendSucMsg1(String phone, String userName) {
        return this.send(phone, this.reviewSuc1.replace("{phone}", phone).replace("{name}", userName));
    }

    public String sendFailMsg(String mobile, String userName, String reason) {
        if (reason != null && !"".equals(reason)) {
            return this.send(mobile, this.reviewFail1.replace("{phone}", mobile).replace("{name}", userName).replace("{reason}", reason));
        }
        return this.send(mobile, this.reviewFail1.replace("{phone}", mobile).replace("{name}", userName).replace("{reason}", "\u65e0"));
    }

    public String sendFailMsg1(String mobile, String userName, String reason) {
        return this.send(mobile, this.reviewFail1.replace("{phone}", mobile).replace("{name}", userName).replace("{reason}", reason));
    }

    public String sendCheckFailMsg(String mobile, String userName, String reason, String checkUser) {
        if (reason != null && !"".equals(reason)) {
            return this.send(mobile, this.reviewFail.replace("{phone}", mobile).replace("{name}", userName).replace("{reason}", reason).replace("{checkUser}", checkUser));
        }
        return this.send(mobile, this.reviewFail.replace("{phone}", mobile).replace("{name}", userName).replace("{reason}", "\u65e0").replace("{checkUser}", checkUser));
    }

    public String sendRegistVerifyCode(String phone, String verifyCode) {
        return this.send(phone, this.registTemplate.replace("{verifyCode}", verifyCode));
    }

    public String sendDeliveryInfo(String phone, String username, String orderno, String deliveryname, String deliveryno) {
        return this.send(phone, this.deliveryTemplate.replace("{username}", username).replace("{orderno}", orderno).replace("{deliveryname}", deliveryname).replace("{deliveryno}", deliveryno));
    }

    public String sendBuyMyselInfo(String phone, String shopName, String buyer, String indentName, String expressCompany, String expressNumber) {
        return this.send(phone, this.buymyselfTemplate.replace("{shopName}", shopName).replace("{buyer}", buyer).replace("{indentName}", indentName).replace("{expressCompany}", expressCompany).replace("{expressNumber}", expressNumber));
    }

    public String sendBuyOtherInfo(String phone, String shopName, String receiver, String expressCompany, String expressNumber) {
        return this.send(phone, this.buyotherTemplate.replace("{shopName}", shopName).replace("{receiver}", receiver).replace("{expressCompany}", expressCompany).replace("{expressNumber}", expressNumber));
    }

    public String sendCouponInfo(String phone, String ticketNum, String receiver, String expressCompany, String expressNumber) {
        return this.send(phone, this.couponTemplate.replace("{ticketNum}", ticketNum).replace("{receiver}", receiver).replace("{expressCompany}", expressCompany).replace("{expressNumber}", expressNumber));
    }

    public Map<String, Object> pushMsgUtil(PushMsgVo pushObj, String customerOrder) throws Exception {
        pushObj.setCustomerOrder(customerOrder);
        pushObj.setAppKey(this.appKey);
        pushObj.setSecretKey(this.secretKey);
        pushObj.setUserId(Long.valueOf(this.userid));
        String sign = CommonUtil.md5("POST" + this.address + this.hostPush + pushObj.getUserId() + pushObj.getAppKey() + pushObj.getCustomerOrder() + this.token);
        pushObj.setSign(sign);
        pushObj.setChannel(this.channel);
        Map<String, Object> result = SmsUtil.httpPost(this.address + this.hostPush, JSONObject.fromObject((Object)pushObj));
        return result;
    }

    public Map<String, Object> getMsgPushStatus(PushMsgVo pushObj) throws Exception {
        pushObj.setAppKey(this.appKey);
        pushObj.setSecretKey(this.secretKey);
        pushObj.setUserId(Long.valueOf(this.userid));
        String sign = CommonUtil.md5("POST" + this.address + this.hostPushStatus + pushObj.getUserId() + pushObj.getAppKey() + this.token);
        pushObj.setSign(sign);
        pushObj.setChannel(this.channel);
        Map<String, Object> result = SmsUtil.httpPost(this.address + this.hostPushStatus, JSONObject.fromObject((Object)pushObj));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> httpPost(String url, JSONObject param) throws Exception {
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse httpResponse = null;
        JSONObject resultJson = null;
        Map result = null;
        try {
            HttpPost httpRequest = new HttpPost(url);
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            formParams.add(new BasicNameValuePair("param", param.toString()));
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(formParams, "UTF-8");
            httpRequest.setEntity((HttpEntity)formEntity);
            httpclient = HttpClients.createDefault();
            httpResponse = httpclient.execute((HttpUriRequest)httpRequest);
            HttpEntity resultEntity = httpResponse.getEntity();
            String strResult = EntityUtils.toString((HttpEntity)resultEntity);
            resultJson = JSONObject.fromObject((Object)strResult);
            if (resultJson != null) {
                result = (Map)JSONObject.toBean((JSONObject)resultJson, Map.class);
            }
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException iOException) {}
            }
            if (httpclient != null) {
                try {
                    httpclient.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }
}

