/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.util.listener;

import com.club.web.util.listener.IBaseListener;
import com.club.web.util.listener.IgnoreListenerScaner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component(value="listenerScaner")
public class ListenerScaner {
    protected final Logger logger = LoggerFactory.getLogger(ListenerScaner.class);
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private List<String> packagesList = new LinkedList<String>();
    private List<TypeFilter> ignoreFilters = new ArrayList<TypeFilter>();
    private Map<Class<? extends IBaseListener>, List<TypeFilter>> typeFilters = new HashMap<Class<? extends IBaseListener>, List<TypeFilter>>();
    private Map<Class<? extends IBaseListener>, Set<Class<? extends IBaseListener>>> classes = new HashMap<Class<? extends IBaseListener>, Set<Class<? extends IBaseListener>>>();

    public ListenerScaner(String[] packagesToScan) {
        if (packagesToScan != null) {
            for (String packagePath : packagesToScan) {
                this.packagesList.add(packagePath);
            }
        }
    }

    @PostConstruct
    public void init() throws IOException, ClassNotFoundException {
    }

    private Set<ClassInfo> loadClasses() throws IOException {
        HashSet<ClassInfo> set = new HashSet<ClassInfo>();
        for (String pkg : this.packagesList) {
            String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
            Resource[] resources = this.resourcePatternResolver.getResources(pattern);
            CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
            for (Resource resource : resources) {
                if (!resource.isReadable()) continue;
                MetadataReader reader = readerFactory.getMetadataReader(resource);
                set.add(new ClassInfo(reader.getClassMetadata().getClassName(), reader, (MetadataReaderFactory)readerFactory));
            }
        }
        return set;
    }

    private void initFilters(Set<ClassInfo> classes) throws IOException, ClassNotFoundException {
        AssignableTypeFilter filter = new AssignableTypeFilter(IBaseListener.class);
        for (ClassInfo ci : classes) {
            if (!filter.match(ci.reader, ci.readerFactory) || !this.checkIgnore(ci.reader, ci.readerFactory) || ci.className.equals(IBaseListener.class.getName())) continue;
            Class<?> clazz = Class.forName(ci.className);
            try {
                clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("found listener: {}", (Object)clazz.getName());
                }
                this.addTypeFilter(clazz, (TypeFilter)new AssignableTypeFilter(clazz));
            }
        }
    }

    private void initClasses(Set<ClassInfo> classes) throws IOException, ClassNotFoundException {
        this.ignoreFilters.add((TypeFilter)new AnnotationTypeFilter(IgnoreListenerScaner.class));
        this.classes.clear();
        for (ClassInfo ci : classes) {
            Class<? extends IBaseListener> key = this.matchesEntityTypeFilter(ci.reader, ci.readerFactory);
            if (key == null || ci.className.equals(key.getName())) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("found class: {} --> {}", (Object)ci.className, (Object)key.getName());
            }
            this.addClass(key, Class.forName(ci.className));
        }
    }

    public <T extends IBaseListener> Set<T> getClassSet(Class<T> listener) {
        Set<Class<? extends IBaseListener>> set = this.classes.get(listener);
        HashSet<IBaseListener> result = new HashSet<IBaseListener>();
        if (set != null) {
            for (Class<? extends IBaseListener> clz : set) {
                try {
                    result.add(clz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {}
            }
        }
        return result;
    }

    private void addTypeFilter(Class<? extends IBaseListener> listener, TypeFilter filter) {
        if (!this.typeFilters.containsKey(listener)) {
            this.typeFilters.put(listener, new ArrayList());
        }
        this.typeFilters.get(listener).add(filter);
    }

    private void addClass(Class<? extends IBaseListener> listener, Class<? extends IBaseListener> clazz) {
        if (!this.classes.containsKey(listener)) {
            this.classes.put(listener, new HashSet());
        }
        this.classes.get(listener).add(clazz);
    }

    private boolean checkIgnore(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter ignoreFilter : this.ignoreFilters) {
            if (!ignoreFilter.match(reader, readerFactory)) continue;
            return false;
        }
        return true;
    }

    private Class<? extends IBaseListener> matchesEntityTypeFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (!this.checkIgnore(reader, readerFactory)) {
            return null;
        }
        for (Map.Entry<Class<? extends IBaseListener>, List<TypeFilter>> filters : this.typeFilters.entrySet()) {
            for (TypeFilter filter : filters.getValue()) {
                if (!filter.match(reader, readerFactory)) continue;
                return filters.getKey();
            }
        }
        return null;
    }

    private static class ClassInfo {
        String className;
        MetadataReader reader;
        MetadataReaderFactory readerFactory;

        ClassInfo(String className, MetadataReader reader, MetadataReaderFactory readerFactory) {
            this.className = className;
            this.reader = reader;
            this.readerFactory = readerFactory;
        }
    }
}

