/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.wxpay.util;

import com.club.web.stock.vo.U8Stock;
import com.club.web.wxpay.util.HttpClientUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XMLUtil {
    public static Map doXMLParse(String strxml) throws JDOMException, IOException {
        if (null == (strxml = strxml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"")) || "".equals(strxml)) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        ByteArrayInputStream in = new ByteArrayInputStream(strxml.getBytes("UTF-8"));
        SAXBuilder builder = new SAXBuilder();
        org.jdom.Document doc = builder.build((InputStream)in);
        Element root = doc.getRootElement();
        List list = root.getChildren();
        for (Element e : list) {
            String k = e.getName();
            String v = "";
            List children = e.getChildren();
            v = children.isEmpty() ? e.getTextNormalize() : XMLUtil.getChildrenText(children);
            m.put(k, v);
        }
        ((InputStream)in).close();
        return m;
    }

    public static String doXMLParseForU8(String strxml) throws JDOMException, IOException {
        if (null == (strxml = strxml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"")) || "".equals(strxml)) {
            return null;
        }
        String res = "";
        ByteArrayInputStream in = new ByteArrayInputStream(strxml.getBytes("UTF-8"));
        SAXBuilder builder = new SAXBuilder();
        org.jdom.Document doc = builder.build((InputStream)in);
        Element root = doc.getRootElement();
        List list = root.getChildren();
        for (Element e : list) {
            String k = e.getName();
            String v = "";
            List children = e.getChildren();
            v = children.isEmpty() ? e.getTextNormalize() : XMLUtil.getChildrenText(children);
            res = v;
        }
        ((InputStream)in).close();
        return res;
    }

    public static String getChildrenText(List children) {
        StringBuffer sb = new StringBuffer();
        if (!children.isEmpty()) {
            for (Element e : children) {
                String name = e.getName();
                String value = e.getTextNormalize();
                List list = e.getChildren();
                sb.append("<" + name + ">");
                if (!list.isEmpty()) {
                    sb.append(XMLUtil.getChildrenText(list));
                }
                sb.append(value);
                sb.append("</" + name + ">");
            }
        }
        return sb.toString();
    }

    public static String getXMLEncoding(String strxml) throws JDOMException, IOException {
        InputStream in = HttpClientUtil.String2Inputstream(strxml);
        SAXBuilder builder = new SAXBuilder();
        org.jdom.Document doc = builder.build(in);
        in.close();
        return (String)doc.getProperty("encoding");
    }

    public static U8Stock doParseForStock(String xml) {
        try {
            String head = "<?xml version=\"1.0\"?>";
            Document document = DocumentHelper.parseText((String)(head + xml));
            org.dom4j.Element node = document.getRootElement();
            U8Stock u8Stock = null;
            if ("depart".equals(node.getName())) {
                u8Stock = new U8Stock();
                Iterator it = node.elementIterator();
                while (it.hasNext()) {
                    org.dom4j.Element e = (org.dom4j.Element)it.next();
                    if ("cinvcode".equals(e.getName())) {
                        u8Stock.setCinvcode(e.getText());
                    }
                    if (!"iquantity".equals(e.getName())) continue;
                    u8Stock.setIquantity(Double.parseDouble(e.getText()));
                }
            }
            return u8Stock;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<U8Stock> doParseForStockList(String xml) {
        try {
            String head = "<?xml version=\"1.0\"?><finterface roottag=\"SQLEXE\" receiver=\"999\" sender=\"u8\" proc=\"depart\" codeexchanged=\"n\" docid=\"\" maxdataitems=\"20000\" bignoreextenduserdefines=\"y\" request-roottag=\"sqlexe\"><NewDataSet>";
            String foot = "</NewDataSet></finterface>";
            Document document = DocumentHelper.parseText((String)(head + xml + foot));
            org.dom4j.Element node = document.getRootElement();
            ArrayList<U8Stock> packList = new ArrayList<U8Stock>();
            U8Stock u8Stock = null;
            XMLUtil.listNodes(node, packList, u8Stock);
            return packList;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<U8Stock> listNodes(org.dom4j.Element node, List<U8Stock> packList, U8Stock u8Stock) {
        if ("depart".equals(node.getName())) {
            u8Stock = new U8Stock();
        }
        if ("cinvcode".equals(node.getName())) {
            u8Stock.setCinvcode(node.getText());
        }
        if ("iquantity".equals(node.getName())) {
            u8Stock.setIquantity(Double.parseDouble(node.getText()));
        }
        if (u8Stock != null && u8Stock.getIquantity() != null) {
            packList.add(u8Stock);
        }
        Iterator it = node.elementIterator();
        while (it.hasNext()) {
            org.dom4j.Element e = (org.dom4j.Element)it.next();
            XMLUtil.listNodes(e, packList, u8Stock);
        }
        return packList;
    }
}

