package com.crawler.pay.alipay;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.crawler.pay.alipay.config.AlipayConfig;
import com.crawler.pay.common.OrderBase;

/**
 * 支付宝工具类
 * @author rubekid
 * @date 2016年9月8日
 */
public class AlipayUtils {
	
	
	/**
	 * 支付宝订单查询接口
	 */
	public static final String ALIPAY_TRADE_QUERY = "https://openapi.alipay.com/gateway.do";
	
	/**
	 * 获取订单信息
	 * @param BaseUrl
	 * @param orderNo
	 * @param subject
	 * @param detail
	 * @param totalFee
	 * @return
	 */
	public static String getOrderInfo(String notifyUrl, String orderNo, String subject, String detail, BigDecimal totalFee) {
		
		// 签约合作者身份ID
		String orderInfo = "partner=" + "\"" + AlipayConfig.PARTNER + "\"";

		// 签约卖家支付宝账号
		orderInfo += "&seller_id=" + "\"" + AlipayConfig.SELLER_EMAIL + "\"";

		// 商户网站唯一订单号
		orderInfo += "&out_trade_no=" + "\"" + orderNo + "\"";

		// 商品名称
		orderInfo += "&subject=" + "\"" + subject + "\"";

		// 商品详情
		orderInfo += "&body=" + "\"" + detail + "\"";

		// 商品金额
		orderInfo += "&total_fee=" + "\"" +  totalFee  + "\"";

		// 服务器异步通知页面路径
		orderInfo += "&notify_url=" + "\"" + notifyUrl + "\"";

		// 服务接口名称， 固定值
		orderInfo += "&service=\"mobile.securitypay.pay\"";

		// 支付类型， 固定值
		orderInfo += "&payment_type=\"1\"";

		// 参数编码， 固定值
		orderInfo += "&_input_charset=\"utf-8\"";

		// 设置未付款交易的超时时间
		// 默认30分钟，一旦超时，该笔交易就会自动被关闭。
		// 取值范围：1m～15d。
		// m-分钟，h-小时，d-天，1c-当天（无论交易何时创建，都在0点关闭）。
		// 该参数数值不接受小数点，如1.5h，可转换为90m。
		orderInfo += "&it_b_pay=\"30m\"";

		// extern_token为经过快登授权获取到的alipay_open_id,带上此参数用户将使用授权的账户进行支付
		// orderInfo += "&extern_token=" + "\"" + extern_token + "\"";

		// 支付宝处理完请求后，当前页面跳转到商户指定页面的路径，可空
		//orderInfo += "&return_url=\"m.alipay.com\"";

		return orderInfo;
	}
	
	/**
	 * 统一下单2.0
	 * @param order
	 * @param notifyUrl
	 * @return
	 */
	public static String unifiedOrder(OrderBase order, String notifyUrl){
		//实例化客户端
		AlipayClient alipayClient = new DefaultAlipayClient(ALIPAY_TRADE_QUERY, AlipayConfig.APP_ID,AlipayConfig.APP_PRIVATE_KEY, "json", AlipayConfig.CHARSET, AlipayConfig.ALIPAY_PUBLIC_KEY, AlipayConfig.SIGN_TYPE);
		//实例化具体API对应的request类,类名称和接口名称对应,当前调用接口名称：alipay.trade.app.pay
		AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
		//SDK已经封装掉了公共参数，这里只需要传入业务参数。以下方法为sdk的model入参方式(model和biz_content同时存在的情况下取biz_content)。
		AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
		model.setBody(order.getDetail());
		model.setSubject(order.getTitle());
		model.setOutTradeNo(order.getOrderNo());
		model.setTimeoutExpress("30m");
		model.setTotalAmount(String.valueOf(order.getFee()));
		model.setProductCode("QUICK_MSECURITY_PAY");
		request.setBizModel(model);
		request.setNotifyUrl(notifyUrl);
		try {
		        //这里和普通的接口调用不同，使用的是sdkExecute
		        AlipayTradeAppPayResponse response = alipayClient.sdkExecute(request);
		        return response.getBody();
		    } catch (AlipayApiException e) {
		        e.printStackTrace();
		}
		return null;
	}
	
	/**
	 * 统一下单2.0
	 * @param order
	 * @param notifyUrl
	 * @return
	 */
	public static String wapUnifiedOrder(OrderBase order, String notifyUrl){
		
		AlipayClient alipayClient = new DefaultAlipayClient(ALIPAY_TRADE_QUERY, AlipayConfig.APP_ID,AlipayConfig.APP_PRIVATE_KEY, "json", AlipayConfig.CHARSET, AlipayConfig.ALIPAY_PUBLIC_KEY, AlipayConfig.SIGN_TYPE);
	    AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
		AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
		model.setBody(order.getDetail());
		model.setSubject(order.getTitle());
		model.setOutTradeNo(order.getOrderNo());
		model.setTimeoutExpress("30m");
		model.setTotalAmount(String.valueOf(order.getFee()));
		model.setProductCode("QUICK_WAP_WAY");
		request.setBizModel(model);
		request.setNotifyUrl(notifyUrl);
		try {
		        //这里和普通的接口调用不同，使用的是sdkExecute
				String form = alipayClient.pageExecute(request).getBody(); //调用SDK生成表单
			 
		        return form;
		    } catch (AlipayApiException e) {
		        e.printStackTrace();
		}
		return null;
	}
	
	/**
	 * 检测异步通知参数
	 * @param request
	 * @return
	 * @throws AlipayApiException
	 */
	public static boolean notifyCheck(HttpServletRequest request) throws AlipayApiException{
		//获取支付宝POST过来反馈信息
		Map<String,String> params = new HashMap<String,String>();
		Map requestParams = request.getParameterMap();
		for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext();) {
		    String name = (String) iter.next();
		    String[] values = (String[]) requestParams.get(name);
		    String valueStr = "";
		    for (int i = 0; i < values.length; i++) {
		        valueStr = (i == values.length - 1) ? valueStr + values[i]
		                    : valueStr + values[i] + ",";
		  }
		  //乱码解决，这段代码在出现乱码时使用。
		  //valueStr = new String(valueStr.getBytes("ISO-8859-1"), "utf-8");
		  params.put(name, valueStr);
		 }
		//切记alipaypublickey是支付宝的公钥，请去open.alipay.com对应应用下查看。
		//boolean AlipaySignature.rsaCheckV1(Map<String, String> params, String publicKey, String charset, String sign_type)
		return  AlipaySignature.rsaCheckV1(params, AlipayConfig.ALIPAY_PUBLIC_KEY, AlipayConfig.CHARSET, AlipayConfig.SIGN_TYPE);
	}
	
	/**
	 * 申请退款
	 * @param orderNo
	 * @param tradeNo
	 * @param amount 退款额度
	 * @return
	 * @throws AlipayApiException
	 */
	public static boolean refund(String orderNo, String tradeNo, BigDecimal amount, String reason) throws AlipayApiException{
		AlipayClient alipayClient =  new DefaultAlipayClient(ALIPAY_TRADE_QUERY, AlipayConfig.APP_ID, AlipayConfig.APP_PRIVATE_KEY, "JSON", AlipayConfig.CHARSET);
		AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
		request.setBizContent("{" +
		"    \"out_trade_no\":\""+ orderNo +"\"," +
		"    \"trade_no\":\""+ tradeNo +"\"," +
		"    \"refund_amount\":"+ amount +"," +
		"    \"refund_reason\":\""+ reason +"\"" +
		"  }");
		AlipayTradeRefundResponse response = alipayClient.execute(request);
		if(response.isSuccess()){
			return true;
		} else {
			return false;
		}
	}
}
