package com.crawler.pay.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

/**
 * xml 工具
 */
public class XmlUtils {

    private static Logger logger = LoggerFactory.getLogger(XmlUtils.class);

    /**
     * 解析xml
     *
     * @param xml
     * @return
     * @throws IOException
     */
    public static JSONObject parse(String xml){
        if(xml == null){
            return null;
        }
        xml = xml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"");
        if (null == xml || "".equals(xml)) {
            return null;
        }

        JSONObject json = new JSONObject();

        try{
            InputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(in);
            Element root = doc.getRootElement();
            List<Element> list = root.getChildren();
            Iterator<Element> it = list.iterator();
            while (it.hasNext()) {
                Element e = (Element) it.next();
                String key = e.getName();
                Object value = "";
                List<Element> children = e.getChildren();
                if (children.isEmpty()) {
                    value = e.getTextNormalize();
                } else {
                    value = parseChildren(children);
                }
                json.put(key, value);
            }
            in.close();
        }
        catch( JDOMException | IOException ex){
            logger.error("XML解析失败" + ex.getMessage());
            throw new RuntimeException("XML解析失败");
        }

        return json;
    }

    /**
     * 获取子结点的xml
     *
     * @param children
     * @return String
     */
    public static Object parseChildren(List<Element> children) {


        if (!children.isEmpty()) {
            boolean isArray = false;
            // 只有一个子元素 且子元素不是文本 或者 大于一个元素且 元素的名称一样
            if((children.size() == 1 && !children.get(0).getChildren().isEmpty())
            || (children.size() >1 && children.get(0).getName().equals(children.get(1).getName()))){
                isArray = true;
            }
            if(isArray){
                JSONArray array = new JSONArray();
                Iterator<Element> it = children.iterator();

                while (it.hasNext()) {
                    Element e = (Element) it.next();
;
                    Object value = e.getTextNormalize();
                    List<Element> list = e.getChildren();
                    if (!list.isEmpty()) {
                        value = parseChildren(list);
                    }
                    array.add(value);

                }
                return array;
            }
            else{
                JSONObject json = new JSONObject();
                Iterator<Element> it = children.iterator();
                while (it.hasNext()) {
                    Element e = (Element) it.next();
                    String name = e.getName();

                    Object value = e.getTextNormalize();
                    List<Element> list = e.getChildren();
                    if (!list.isEmpty()) {
                        value = parseChildren(list);
                    }
                    json.put(name, value);

                }
                return json;
            }

        }
        return null;
    }
}
